/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.privateuse.util;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.client.core.BoxfuseConnectConfig;
import com.boxfuse.generator.config.BoxfuseConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigUtils.class);
    private static final String BOXFUSE_PROPERTY_PREFIX = "boxfuse.";

    private ConfigUtils() {
    }

    public static void addConfigFromConfigFile(Map<String, String> config, File configFile) {
        if (configFile == null) {
            return;
        }
        if (!configFile.canRead() || !configFile.isFile()) {
            LOGGER.debug("Skipping non-existent config file: " + configFile.getAbsolutePath());
            return;
        }
        LOGGER.debug("Loading configuration from " + configFile.getAbsolutePath() + " ...");
        try {
            Properties configFileProps = new Properties();
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configFile), "UTF-8");
            configFileProps.load(reader);
            reader.close();
            for (String prop : configFileProps.stringPropertyNames()) {
                String value = configFileProps.getProperty(prop);
                ConfigUtils.addConfigParam(config, prop.trim(), value.trim());
            }
        }
        catch (IOException e) {
            throw new BoxfuseException("Unable to load config file: " + configFile, e);
        }
    }

    public static void addConfigFromStandardConfigFiles(Map<String, String> config, String env) {
        String userHome = System.getProperty("user.home");
        ConfigUtils.addConfigFromConfigFile(config, new File(userHome + "/.boxfuse/boxfuse.conf"));
        if (env != null) {
            ConfigUtils.addConfigFromConfigFile(config, new File(userHome + "/.boxfuse/boxfuse-" + env + ".conf"));
        }
        ConfigUtils.addConfigFromConfigFile(config, new File("./boxfuse.conf"));
        if (env != null) {
            ConfigUtils.addConfigFromConfigFile(config, new File("./boxfuse-" + env + ".conf"));
        }
    }

    public static void addConfigFromProperties(Map<String, String> config, Properties properties) {
        for (String prop : properties.stringPropertyNames()) {
            if (!prop.startsWith(BOXFUSE_PROPERTY_PREFIX)) continue;
            String key = prop.substring(BOXFUSE_PROPERTY_PREFIX.length());
            String value = properties.getProperty(prop);
            ConfigUtils.addConfigParam(config, key, value);
        }
    }

    public static void addConfigFromProperties(Map<String, String> config, Map<String, ?> properties) {
        for (String prop : properties.keySet()) {
            if (!prop.startsWith(BOXFUSE_PROPERTY_PREFIX)) continue;
            String key = prop.substring(BOXFUSE_PROPERTY_PREFIX.length());
            String value = "" + properties.get(prop);
            ConfigUtils.addConfigParam(config, key, value);
        }
    }

    private static void addConfigParam(Map<String, String> config, String key, String value) {
        String displayValue = value;
        if ("secret".equals(key)) {
            displayValue = value.length() < 4 ? StringUtils.trimOrPad("", value.length(), '*') : StringUtils.trimOrPad(value.substring(0, 4), value.length(), '*');
        }
        LOGGER.debug(key + " -> " + displayValue);
        if (StringUtils.hasLength(value)) {
            config.put(key, value);
        } else {
            config.remove(key);
        }
    }

    public static void validateConfig(Map<String, String> config) {
        Set<String> keys2 = config.keySet();
        BoxfuseConnectConfig.removeAllValidKeys(keys2);
        BoxfuseConfig.removeAllValidKeys(keys2);
        keys2.remove("configfile");
        keys2.remove("version");
        keys2.remove("skip");
        keys2.remove("serverid");
        keys2.remove("X");
        keys2.remove("XX");
        keys2.remove("m");
        keys2.remove("o");
        keys2.remove("u");
        keys2.remove("v");
        Iterator<String> iterator2 = keys2.iterator();
        while (iterator2.hasNext()) {
            String key = iterator2.next();
            if (!key.startsWith("instances.") && !key.startsWith("instancesResult.") && !key.startsWith("aws.") && !key.startsWith("database.")) continue;
            iterator2.remove();
        }
        if (!keys2.isEmpty()) {
            throw new BoxfuseException("Invalid Boxfuse configuration settings: " + StringUtils.collectionToDelimitedString(keys2, ", "));
        }
    }
}

