/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.jar;

import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.payload.PayloadEntry;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.types.Pair;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.generator.builder.ramdisk.RamDisk;
import com.boxfuse.generator.builder.ramdisk.jvm.NewRelicConfig;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.JarPayload;
import com.boxfuse.generator.payload.DirectoryPayload;
import com.boxfuse.generator.payload.PayloadFormat;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;

public class JarDirectoyPayload
extends DirectoryPayload
implements JarPayload {
    private static final String SYSCTL_CONF = "sysctl.conf";
    private Boolean customJRE;
    protected String classesDir = "";

    public static boolean supports(PayloadFormat format, Map<String, PayloadEntry> entries) {
        return PayloadFormat.DIRECTORY == format && entries.keySet().contains("META-INF/MANIFEST.MF");
    }

    public JarDirectoyPayload(File file, long payloadSize, Map<String, PayloadEntry> entries, boolean live) {
        super(file, payloadSize, entries, live);
    }

    @Override
    public PayloadType getType() {
        return PayloadType.JAR;
    }

    @Override
    public Collection<String> getJavaAgents() {
        File[] agents;
        ArrayList<String> javaAgents = new ArrayList<String>();
        File agentsDir = new File(this.file.getAbsolutePath() + "/" + this.classesDir + "javaagents");
        if (agentsDir.isDirectory() && agentsDir.canRead() && (agents = agentsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })) != null) {
            for (File agent : agents) {
                javaAgents.add("/app/" + this.classesDir + "javaagents/" + agent.getName());
            }
        }
        return javaAgents;
    }

    @Override
    public NewRelicConfig getNewRelicConfig() {
        File configFile = new File(this.file.getAbsolutePath() + "/" + this.classesDir + "newrelic.yml");
        if (configFile.isFile()) {
            return new NewRelicConfig(IOUtils.copyToString(configFile));
        }
        return null;
    }

    @Override
    public boolean hasCustomJRE() {
        if (this.customJRE == null) {
            this.customJRE = new File(this.file.getAbsolutePath() + "/" + this.classesDir + "jre/bin/java").isFile();
        }
        return this.customJRE;
    }

    @Override
    public byte[] getCACerts() {
        byte[] cacerts = IOUtils.copyToByteArray(new File(this.file.getAbsolutePath() + "/" + this.classesDir + "cacerts"));
        if (cacerts == null && this.customJRE.booleanValue()) {
            cacerts = IOUtils.copyToByteArray(new File(this.file.getAbsolutePath() + "/" + this.classesDir + "jre/lib/security/cacerts"));
        }
        return cacerts;
    }

    @Override
    public byte[] getLocalPolicyJar() {
        return IOUtils.copyToByteArray(new File(this.file.getAbsolutePath() + "/" + this.classesDir + "local_policy.jar"));
    }

    @Override
    public byte[] getUsExportPolicyJar() {
        return IOUtils.copyToByteArray(new File(this.file.getAbsolutePath() + "/" + this.classesDir + "US_export_policy.jar"));
    }

    @Override
    public DbType detectDbType() {
        for (DbType dbType : DbType.values()) {
            if (DbType.NONE == dbType || !this.entries.keySet().contains(dbType.getJdbcDriverClass().replace(".", "/") + ".class")) continue;
            return dbType;
        }
        return DbType.NONE;
    }

    @Override
    public Pair<String, byte[]> getSysCtlConf() {
        if (this.entries.keySet().contains(SYSCTL_CONF)) {
            return Pair.of(SYSCTL_CONF, null);
        }
        return null;
    }

    @Override
    public void installInto(RamDisk ramDisk, String baseDir) throws IOException {
        if (this.live) {
            ramDisk.createSymLink("app", "/live");
        } else {
            ramDisk.installDirectory(this.file, "app", true, Pattern.quote("jmxremote.password"));
        }
    }

    @Override
    public byte[] getManifest() {
        return IOUtils.copyToByteArray(new File(this.file.getAbsolutePath() + "/META-INF/MANIFEST.MF"));
    }

    @Override
    public String getClassPath() {
        return "/app";
    }

    @Override
    public void installCustomJREInto(RamDisk ramDisk, String baseDir) throws IOException {
        ramDisk.createSymLink(baseDir, "/app/" + this.classesDir + "jre");
    }

    @Override
    public void installNativeBinariesAndLibsInto(RamDisk ramDisk, String nativeDirectory) throws IOException {
        ramDisk.createSymLink(nativeDirectory, "/app/" + this.classesDir + "native");
    }
}

