/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.nodejs;

import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.TlsType;
import com.boxfuse.base.env.EnvVarName;
import com.boxfuse.base.env.EnvVarValue;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.types.ComponentId;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.Template;
import com.boxfuse.generator.builder.certificate.CertificateManager;
import com.boxfuse.generator.builder.ramdisk.RamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.nodejs.NodeJsConfig;
import com.boxfuse.generator.builder.ramdisk.nodejs.NodeJsPayload;
import com.boxfuse.generator.image.ImageSpecImpl;
import com.boxfuse.generator.inventory.Component;
import com.boxfuse.generator.inventory.Inventory;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeJsRamDiskBuilder
extends RamDiskBuilder<NodeJsPayload> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeJsRamDiskBuilder.class);
    static final String NODEJS_INCLUDE_REGEX = "^bin/node$|^LICENSE$";
    private final String nodeStartCmd;
    private Component nodejs;
    private NodeJsConfig nodeJsConfig;

    public NodeJsRamDiskBuilder(CertificateManager certificateManager, Inventory inventory, ImageSpecImpl spec, Collection<Component> virtualDiskComponents) {
        super(certificateManager, inventory, spec, virtualDiskComponents);
        this.nodeStartCmd = ((NodeJsPayload)this.payload).getNodeExecutable() + " $debug ";
        this.nodeJsConfig = ((NodeJsPayload)this.payload).getNodeJsConfig();
        if (!spec.getComponents().containsKey((Object)ComponentId.NODEJS) && this.nodeJsConfig.getNodeJsVersion() != null) {
            LOGGER.debug("Auto-detected Node.js version in package.json: " + this.nodeJsConfig.getNodeJsVersion());
            this.nodejs = inventory.get(ComponentId.NODEJS, this.nodeJsConfig.getNodeJsVersion());
        } else {
            this.nodejs = this.getComponent(ComponentId.NODEJS);
        }
        this.components.add(this.nodejs);
    }

    @Override
    protected void doBuild() throws IOException {
        this.ramDisk.createDir("nodejs");
        this.ramDisk.installTarXzArchive(this.nodejs.getBytes(), "nodejs/", "node-v" + this.nodejs.getVersion() + "-linux-x64/", NODEJS_INCLUDE_REGEX);
    }

    @Override
    protected void doAdjustSpecBasedOnConfig() {
        if (!this.spec.getPorts().containsKey(PortName.HTTP) && !this.spec.getPorts().containsKey(PortName.HTTPS)) {
            this.spec.getPorts().put(PortName.HTTP, Port.HTTP);
            if (!this.messagesDisplayed) {
                LOGGER.debug("Auto-configured http port to 80");
            }
        }
    }

    @Override
    protected DbType detectDbType() {
        if (this.nodeJsConfig.hasDependency("pg")) {
            return DbType.POSTGRESQL;
        }
        if (this.nodeJsConfig.hasDependency("mysql")) {
            return DbType.MYSQL;
        }
        return DbType.NONE;
    }

    @Override
    protected void doGenerateEnvVars(Map<EnvVarName, EnvVarValue> envVars) {
        Port port = this.spec.getPorts().get(PortName.HTTPS);
        if (port == null) {
            port = this.spec.getPorts().get(PortName.HTTP);
        }
        if (port != null) {
            envVars.put(EnvVarName.of("PORT"), EnvVarValue.asIs("" + port.getNumber()));
        }
    }

    @Override
    protected String getStartDir() {
        return "/app";
    }

    @Override
    protected void installPayloadWithDependencies() throws IOException {
        ((NodeJsPayload)this.payload).installInto(this.ramDisk, "app");
        if (DbType.POSTGRESQL == this.spec.getDbType()) {
            this.ramDisk.createFile("cacerts/rds.pem", false, IOUtils.copyToByteArray("rds-combined-ca-bundle.pem"));
        }
        if (this.spec.getTlsType() == TlsType.ACM) {
            this.ramDisk.createFile("app-config/boxfuse-selfsigned-cert.pem", false, IOUtils.copyToByteArray("generator/selfsigned/boxfuse-selfsigned-cert.pem"));
            this.ramDisk.createFile("app-config/boxfuse-selfsigned-key.pem", false, IOUtils.copyToByteArray("generator/selfsigned/boxfuse-selfsigned-key.pem"));
        }
    }

    @Override
    protected String createLaunchScript(String straceCmd, Map<EnvVarName, EnvVarValue> envVars) {
        String nodejsCmd;
        if (this.nodeJsConfig.getMain() == null && this.nodeJsConfig.getStart() == null) {
            throw new BoxfuseException("Unable to determine how to start application => ensure either main or a start script is defined in package.json");
        }
        if (this.nodeJsConfig.getStart() == null) {
            nodejsCmd = this.nodeStartCmd + this.nodeJsConfig.getMain();
        } else {
            nodejsCmd = this.nodeJsConfig.getStart();
            if (nodejsCmd.startsWith("npm ")) {
                throw new BoxfuseException("Your application is configured to use \"" + nodejsCmd + "\" to start, however npm is not present inside a Boxfuse image => ensure all yarn build steps have run first and your application only needs node to start");
            }
            if (nodejsCmd.startsWith("yarn ")) {
                throw new BoxfuseException("Your application is configured to use \"" + nodejsCmd + "\" to start, however yarn is not present inside a Boxfuse image => ensure all yarn build steps have run first and your application only needs node to start");
            }
            if (nodejsCmd.startsWith("node ")) {
                nodejsCmd = this.nodeStartCmd + this.nodeJsConfig.getStart().substring("node ".length());
            }
        }
        return Template.process("generator/launch-nodejs.template", this.getStartDir(), nodejsCmd, straceCmd);
    }

    @Override
    protected String extraPathDirs() {
        return ":/nodejs/bin:/app/native/bin";
    }

    @Override
    protected String extraLdLibraryPathDirs() {
        return ":/app/native/lib";
    }
}

