/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.config;

import com.boxfuse.base.aws.AwsELBName;
import com.boxfuse.base.aws.AwsInstanceProfileArn;
import com.boxfuse.base.aws.AwsSecurityGroupId;
import com.boxfuse.base.aws.AwsSubnetId;
import com.boxfuse.base.aws.AwsTagKey;
import com.boxfuse.base.aws.AwsTagValue;
import com.boxfuse.base.aws.AwsTargetGroupName;
import com.boxfuse.base.coordinates.AppCoordinates;
import com.boxfuse.base.coordinates.ImageCoordinates;
import com.boxfuse.base.coordinates.Owner;
import com.boxfuse.base.enums.AppType;
import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.LogsType;
import com.boxfuse.base.enums.TlsType;
import com.boxfuse.base.env.EnvVarName;
import com.boxfuse.base.env.EnvVarValue;
import com.boxfuse.base.logs.cloudwatchlogs.LogsFieldName;
import com.boxfuse.base.logs.cloudwatchlogs.LogsLayout;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.port.Protocol;
import com.boxfuse.base.types.Capacity;
import com.boxfuse.base.types.ComponentId;
import com.boxfuse.base.types.Domain;
import com.boxfuse.base.types.EnvName;
import com.boxfuse.base.types.HealthcheckTimeout;
import com.boxfuse.base.types.IpAddress;
import com.boxfuse.base.types.Path;
import com.boxfuse.base.types.TmpGB;
import com.boxfuse.base.types.Version;
import com.boxfuse.base.util.DateUtils;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.generator.config.BoxfuseConfigProperty;
import com.boxfuse.generator.config.ConfigUtils;
import com.boxfuse.generator.config.CpuCount;
import com.boxfuse.generator.config.InstanceId;
import com.boxfuse.generator.config.LogsFilters;
import com.boxfuse.generator.config.RamMB;
import com.boxfuse.generator.newrelic.NewRelicLicenseKey;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxfuseConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoxfuseConfig.class);
    public static final Version VERSION = BoxfuseConfig.getVersion();
    private final Owner owner;
    private static final String KEY_APP = "app";
    @Deprecated
    private static final String KEY_APPTYPE = "apptype";
    private static final String KEY_APP_TYPE = "app.type";
    private static final String KEY_CAPACITY = "capacity";
    private static final String KEY_CMD = "cmd";
    private static final String KEY_COMPONENT = "component";
    private static final String KEY_COMPONENTS_PREFIX = "components.";
    private static final String KEY_CPUS = "cpus";
    private static final String KEY_DB = "db";
    @Deprecated
    private static final String KEY_DBTYPE = "dbtype";
    private static final String KEY_DB_TYPE = "db.type";
    private static final String KEY_DEBUG = "debug";
    private static final String KEY_DEBUG_WAIT = "debug.wait";
    static final String KEY_DOMAIN = "domain";
    static final String KEY_ELASTICIP = "elasticip";
    private static final String KEY_ELB = "elb";
    private static final String KEY_ENV = "env";
    private static final String KEY_ENVVARS_PREFIX = "envvars.";
    private static final String KEY_HEALTHCHECK = "healthcheck";
    private static final String KEY_HEALTHCHECK_PATH = "healthcheck.path";
    private static final String KEY_HEALTHCHECK_PORT = "healthcheck.port";
    private static final String KEY_HEALTHCHECK_TIMEOUT = "healthcheck.timeout";
    private static final String KEY_IMAGE = "image";
    private static final String KEY_INSTANCEPROFILE = "instanceprofile";
    private static final String KEY_INSTANCES = "instances";
    private static final String KEY_JVM_ARGS = "jvm.args";
    private static final String KEY_JVM_JMX = "jvm.jmx";
    private static final String KEY_JVM_MAIN_CLASS = "jvm.main.class";
    private static final String KEY_JVM_MAIN_ARGS = "jvm.main.args";
    private static final String KEY_LINUX_ARGS = "linux.args";
    private static final String KEY_LIVE = "live";
    private static final String KEY_LOGS_AUTO = "logs.auto";
    private static final String KEY_LOGS_BOOT = "logs.boot";
    private static final String KEY_LOGS_DIR = "logs.dir";
    private static final String KEY_LOGS_FILTER_PREFIX = "logs.filter.";
    private static final String KEY_LOGS_LAYOUT = "logs.layout";
    private static final String KEY_LOGS_TAIL = "logs.tail";
    private static final String KEY_LOGS_TYPE = "logs.type";
    private static final String KEY_NEWRELIC_LICENSEKEY = "newrelic.licensekey";
    private static final String KEY_PAYLOAD = "payload";
    private static final String KEY_PAYLOAD_PATH = "payload.path";
    private static final String KEY_PAYLOAD_PORT = "payload.port";
    private static final String KEY_PAYLOAD_SEARCHDIR = "payloadSearchDir";
    static final String KEY_PORTS_PREFIX = "ports.";
    private static final String KEY_PORTSMAP_PREFIX = "portsmap.";
    private static final String KEY_RAM = "ram";
    private static final String KEY_SECURITYGROUP = "securitygroup";
    private static final String KEY_STRACE = "strace";
    @Deprecated
    private static final String KEY_SUBNET = "subnet";
    private static final String KEY_SUBNETS = "subnets";
    private static final String KEY_TAGS_PREFIX = "tags.";
    private static final String KEY_TARGETGROUP = "targetgroup";
    private static final String KEY_TLS_TYPE = "tls.type";
    private static final String KEY_TMP = "tmp";
    private static final String KEY_VAULT = "vault";
    private static final String KEY_VIRTUALBOX_NATNETWORK = "virtualbox.natnetwork";
    private static final String KEY_WINDOWS_PASSWORD = "windows.password";
    private static final String KEY_WINDOWS_USER = "windows.user";
    public final BoxfuseConfigProperty<AppCoordinates> app = new BoxfuseConfigProperty();
    public final BoxfuseConfigProperty<AppType> appType = new BoxfuseConfigProperty(AppType.SINGLE_INSTANCE);
    public final BoxfuseConfigProperty<Capacity> capacity = new BoxfuseConfigProperty();
    public final BoxfuseConfigProperty<String> cmd = new BoxfuseConfigProperty();
    public final BoxfuseConfigProperty<ComponentId> component = new BoxfuseConfigProperty();
    public final Map<ComponentId, Version> components = new TreeMap<ComponentId, Version>();
    public final BoxfuseConfigProperty<CpuCount> cpus = new BoxfuseConfigProperty(CpuCount.of(2));
    public final BoxfuseConfigProperty<Boolean> db = new BoxfuseConfigProperty(Boolean.FALSE);
    public final BoxfuseConfigProperty<DbType> dbType = new BoxfuseConfigProperty(DbType.NONE);
    public final DebugBoxfuseConfig debug = new DebugBoxfuseConfig();
    public final BoxfuseConfigProperty<Domain> domain = new BoxfuseConfigProperty(Domain.AUTO);
    public final BoxfuseConfigProperty<IpAddress> elasticip = new BoxfuseConfigProperty(IpAddress.AUTO);
    public final BoxfuseConfigProperty<AwsELBName> elb = new BoxfuseConfigProperty(AwsELBName.AUTO);
    public final BoxfuseConfigProperty<EnvName> env = new BoxfuseConfigProperty(EnvName.DEV);
    public final Map<EnvVarName, EnvVarValue> envvars = new TreeMap<EnvVarName, EnvVarValue>();
    public final HealthcheckBoxfuseConfig healthcheck = new HealthcheckBoxfuseConfig();
    public final BoxfuseConfigProperty<ImageCoordinates> image = new BoxfuseConfigProperty();
    public final BoxfuseConfigProperty<AwsInstanceProfileArn> instanceprofile = new BoxfuseConfigProperty();
    public final BoxfuseConfigProperty<Set<InstanceId>> instances = new BoxfuseConfigProperty(new TreeSet());
    public final JvmBoxfuseConfig jvm = new JvmBoxfuseConfig();
    public final BoxfuseConfigProperty<String> linuxArgs = new BoxfuseConfigProperty("quiet");
    public final BoxfuseConfigProperty<Boolean> live = new BoxfuseConfigProperty(Boolean.FALSE);
    public final LogsBoxfuseConfig logs;
    public final BoxfuseConfigProperty<NewRelicLicenseKey> newrelicLicensekey = new BoxfuseConfigProperty();
    public final PayloadBoxfuseConfig payload = new PayloadBoxfuseConfig();
    public final Map<PortName, Port> ports = new TreeMap<PortName, Port>();
    public final Map<PortName, Port> portsmap = new TreeMap<PortName, Port>();
    public final BoxfuseConfigProperty<RamMB> ram = new BoxfuseConfigProperty(RamMB.of(1024));
    public final BoxfuseConfigProperty<AwsSecurityGroupId> securitygroup = new BoxfuseConfigProperty();
    public final BoxfuseConfigProperty<Boolean> strace = new BoxfuseConfigProperty(Boolean.FALSE);
    public final BoxfuseConfigProperty<Set<AwsSubnetId>> subnets = new BoxfuseConfigProperty(new TreeSet());
    public final Map<AwsTagKey, AwsTagValue> tags = new TreeMap<AwsTagKey, AwsTagValue>();
    public final BoxfuseConfigProperty<AwsTargetGroupName> targetgroup = new BoxfuseConfigProperty(AwsTargetGroupName.AUTO);
    public final BoxfuseConfigProperty<TlsType> tlsType = new BoxfuseConfigProperty(TlsType.NONE);
    public final BoxfuseConfigProperty<TmpGB> tmp = new BoxfuseConfigProperty(TmpGB.of(1));
    public final BoxfuseConfigProperty<Boolean> vault = new BoxfuseConfigProperty(Boolean.FALSE);
    public final BoxfuseConfigProperty<Boolean> virtualboxNatnetwork = new BoxfuseConfigProperty(Boolean.FALSE);
    public final WindowsBoxfuseConfig windows = new WindowsBoxfuseConfig();

    private static Version getVersion() {
        Properties properties = new Properties();
        try {
            properties.load(BoxfuseConfig.class.getClassLoader().getResourceAsStream("version.properties"));
        }
        catch (IOException e) {
            LOGGER.debug("Unable to load version info");
            return new Version("0.0." + System.currentTimeMillis());
        }
        String version = properties.getProperty("version");
        if (version.contains("${")) {
            return new Version("0.0." + System.currentTimeMillis());
        }
        return new Version(version.replace("-SNAPSHOT", "0.0." + DateUtils.toUtcDateTime(properties.getProperty("timestamp")).getTime()));
    }

    public static void removeAllValidKeys(Set<String> keys2) {
        keys2.removeAll(Arrays.asList(KEY_APP, KEY_APPTYPE, KEY_APP_TYPE, KEY_CAPACITY, KEY_CMD, KEY_COMPONENT, KEY_CPUS, KEY_DB, KEY_DB_TYPE, KEY_DB_TYPE, KEY_DEBUG, KEY_DEBUG_WAIT, KEY_DOMAIN, KEY_ELASTICIP, KEY_ELB, KEY_ENV, KEY_HEALTHCHECK, KEY_HEALTHCHECK_PATH, KEY_HEALTHCHECK_PORT, KEY_HEALTHCHECK_TIMEOUT, KEY_IMAGE, KEY_INSTANCEPROFILE, KEY_INSTANCES, KEY_JVM_ARGS, KEY_JVM_JMX, KEY_JVM_MAIN_ARGS, KEY_JVM_MAIN_CLASS, KEY_LINUX_ARGS, KEY_LIVE, KEY_LOGS_AUTO, KEY_LOGS_BOOT, KEY_LOGS_DIR, KEY_LOGS_LAYOUT, KEY_LOGS_TAIL, KEY_LOGS_TYPE, KEY_NEWRELIC_LICENSEKEY, KEY_PAYLOAD, KEY_PAYLOAD_PATH, KEY_PAYLOAD_PORT, KEY_PAYLOAD_SEARCHDIR, KEY_RAM, KEY_SECURITYGROUP, KEY_STRACE, KEY_SUBNET, KEY_SUBNETS, KEY_TARGETGROUP, KEY_TLS_TYPE, KEY_TMP, KEY_VAULT, KEY_VIRTUALBOX_NATNETWORK, KEY_WINDOWS_PASSWORD, KEY_WINDOWS_USER));
        keys2.removeIf(key -> key.startsWith(KEY_COMPONENTS_PREFIX) || key.startsWith(KEY_ENVVARS_PREFIX) || key.startsWith(KEY_LOGS_FILTER_PREFIX) || key.startsWith(KEY_PORTS_PREFIX) || key.startsWith(KEY_PORTSMAP_PREFIX) || key.startsWith(KEY_TAGS_PREFIX));
    }

    public BoxfuseConfig(Owner owner) {
        this.owner = owner;
        this.logs = new LogsBoxfuseConfig(owner);
    }

    public void configure(Map<String, String> cfg) {
        Set<AwsSubnetId> subnetIds;
        Protocol defaultProtocol;
        PortName portName;
        this.app.set((AppCoordinates[])new AppCoordinates[]{AppCoordinates.of(cfg.get(KEY_APP), this.owner)});
        this.appType.set((AppType[])new AppType[]{AppType.of(cfg.get(KEY_APP_TYPE)), AppType.of(cfg.get(KEY_APPTYPE))});
        this.capacity.set((Capacity[])new Capacity[]{Capacity.of(cfg.get(KEY_CAPACITY))});
        this.cmd.set((String[])new String[]{cfg.get(KEY_CMD)});
        this.component.set((ComponentId[])new ComponentId[]{ComponentId.of(cfg.get(KEY_COMPONENT))});
        for (Map.Entry<String, String> entry : cfg.entrySet()) {
            if (!entry.getKey().startsWith(KEY_COMPONENTS_PREFIX)) continue;
            this.components.put(ComponentId.of(entry.getKey().substring(KEY_COMPONENTS_PREFIX.length())), new Version(entry.getValue(), true));
        }
        this.cpus.set((CpuCount[])new CpuCount[]{CpuCount.of(cfg.get(KEY_CPUS))});
        this.db.set((Boolean[])new Boolean[]{ConfigUtils.booleanOf(cfg, KEY_DB)});
        this.dbType.set((DbType[])new DbType[]{DbType.of(cfg.get(KEY_DB_TYPE)), DbType.of(cfg.get(KEY_DBTYPE))});
        this.debug.configure(cfg);
        this.domain.set((Domain[])new Domain[]{Domain.of(cfg.get(KEY_DOMAIN))});
        this.elasticip.set((IpAddress[])new IpAddress[]{IpAddress.of(cfg.get(KEY_ELASTICIP))});
        this.elb.set((AwsELBName[])new AwsELBName[]{AwsELBName.of(cfg.get(KEY_ELB))});
        this.env.set((EnvName[])new EnvName[]{EnvName.of(cfg.get(KEY_ENV))});
        for (Map.Entry<String, String> entry : cfg.entrySet()) {
            if (!entry.getKey().startsWith(KEY_ENVVARS_PREFIX)) continue;
            this.envvars.put(EnvVarName.of(entry.getKey().substring(KEY_ENVVARS_PREFIX.length())), EnvVarValue.flexi(entry.getValue()));
        }
        this.healthcheck.configure(cfg);
        this.image.set((ImageCoordinates[])new ImageCoordinates[]{ImageCoordinates.of(cfg.get(KEY_IMAGE), this.owner)});
        this.instanceprofile.set((AwsInstanceProfileArn[])new AwsInstanceProfileArn[]{AwsInstanceProfileArn.of(cfg.get(KEY_INSTANCEPROFILE))});
        this.instances.set(ConfigUtils.instanceIdSetOf(cfg.get(KEY_INSTANCES)));
        this.jvm.configure(cfg);
        this.linuxArgs.set((String[])new String[]{cfg.get(KEY_LINUX_ARGS)});
        this.live.set((Boolean[])new Boolean[]{ConfigUtils.booleanOf(cfg, KEY_LIVE)});
        this.logs.configure(cfg);
        this.newrelicLicensekey.set((NewRelicLicenseKey[])new NewRelicLicenseKey[]{NewRelicLicenseKey.of(cfg.get(KEY_NEWRELIC_LICENSEKEY))});
        this.payload.configure(cfg);
        for (Map.Entry<String, String> entry : cfg.entrySet()) {
            if (!entry.getKey().startsWith(KEY_PORTS_PREFIX)) continue;
            portName = PortName.of(entry.getKey().substring(KEY_PORTS_PREFIX.length()));
            defaultProtocol = portName.getProtocol();
            this.ports.put(portName, Port.of(entry.getValue(), defaultProtocol));
        }
        for (Map.Entry<String, String> entry : cfg.entrySet()) {
            if (!entry.getKey().startsWith(KEY_PORTSMAP_PREFIX)) continue;
            portName = PortName.of(entry.getKey().substring(KEY_PORTSMAP_PREFIX.length()));
            defaultProtocol = portName.getProtocol();
            this.portsmap.put(portName, Port.of(entry.getValue(), defaultProtocol));
        }
        this.ram.set((RamMB[])new RamMB[]{RamMB.of(cfg.get(KEY_RAM))});
        this.securitygroup.set((AwsSecurityGroupId[])new AwsSecurityGroupId[]{AwsSecurityGroupId.of(cfg.get(KEY_SECURITYGROUP))});
        this.strace.set((Boolean[])new Boolean[]{ConfigUtils.booleanOf(cfg, KEY_STRACE)});
        TreeSet<AwsSubnetId> awsSubnetIds = new TreeSet<AwsSubnetId>();
        AwsSubnetId awsSubnetId = AwsSubnetId.of(cfg.get(KEY_SUBNET));
        if (awsSubnetId != null) {
            awsSubnetIds.add(awsSubnetId);
        }
        if ((subnetIds = ConfigUtils.awsSubnetIdSetOf(cfg.get(KEY_SUBNETS))) != null) {
            awsSubnetIds.addAll(subnetIds);
        }
        if (!awsSubnetIds.isEmpty()) {
            this.subnets.set(awsSubnetIds);
        }
        for (Map.Entry<String, String> entry : cfg.entrySet()) {
            if (!entry.getKey().startsWith(KEY_TAGS_PREFIX)) continue;
            this.tags.put(AwsTagKey.of(entry.getKey().substring(KEY_TAGS_PREFIX.length())), AwsTagValue.of(entry.getValue()));
        }
        this.targetgroup.set((AwsTargetGroupName[])new AwsTargetGroupName[]{AwsTargetGroupName.of(cfg.get(KEY_TARGETGROUP))});
        this.tlsType.set((TlsType[])new TlsType[]{TlsType.of(cfg.get(KEY_TLS_TYPE))});
        this.tmp.set((TmpGB[])new TmpGB[]{TmpGB.of(cfg.get(KEY_TMP))});
        this.vault.set((Boolean[])new Boolean[]{ConfigUtils.booleanOf(cfg, KEY_VAULT)});
        this.virtualboxNatnetwork.set((Boolean[])new Boolean[]{ConfigUtils.booleanOf(cfg, KEY_VIRTUALBOX_NATNETWORK)});
        this.windows.configure(cfg);
    }

    public Map<String, String> toMap() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (this.app.isSet()) {
            map.put(KEY_APP, this.app.getConfigured().getCoordinates());
        }
        if (this.appType.isSet()) {
            map.put(KEY_APP_TYPE, this.appType.getConfigured().getName());
        }
        if (this.capacity.isSet()) {
            map.put(KEY_CAPACITY, this.capacity.getConfigured().getDescriptor());
        }
        if (this.cmd.isSet()) {
            map.put(KEY_CMD, this.cmd.getConfigured());
        }
        if (this.component.isSet()) {
            map.put(KEY_COMPONENT, this.component.getConfigured().getId());
        }
        for (Map.Entry<ComponentId, Version> entry : this.components.entrySet()) {
            map.put(KEY_COMPONENTS_PREFIX + (Object)((Object)entry.getKey()), entry.getValue().getVersion());
        }
        if (this.cpus.isSet()) {
            map.put(KEY_CPUS, this.cpus.getConfigured().toString());
        }
        if (this.db.isSet()) {
            map.put(KEY_DB, this.db.getConfigured().toString());
        }
        if (this.dbType.isSet()) {
            map.put(KEY_DB_TYPE, this.dbType.getConfigured().getName());
        }
        map.putAll(this.debug.toMap());
        if (this.domain.isSet()) {
            map.put(KEY_DOMAIN, this.domain.getConfigured().getDomain());
        }
        if (this.elasticip.isSet()) {
            map.put(KEY_ELASTICIP, this.elasticip.getConfigured().getIpAddress());
        }
        if (this.elb.isSet()) {
            map.put(KEY_ELB, this.elb.getConfigured().getName());
        }
        if (this.env.isSet()) {
            map.put(KEY_ENV, this.env.getConfigured().getName());
        }
        for (Map.Entry<Object, Object> entry : this.envvars.entrySet()) {
            map.put(KEY_ENVVARS_PREFIX + entry.getKey(), BoxfuseConfig.censor(((EnvVarValue)entry.getValue()).getValue()));
        }
        map.putAll(this.healthcheck.toMap());
        if (this.instanceprofile.isSet()) {
            map.put(KEY_INSTANCEPROFILE, this.instanceprofile.getConfigured().getValue());
        }
        if (this.instances.isSet()) {
            map.put(KEY_INSTANCES, StringUtils.collectionToDelimitedString((Collection)this.instances.get(), ","));
        }
        map.putAll(this.jvm.toMap());
        if (this.linuxArgs.isSet()) {
            map.put(KEY_LINUX_ARGS, this.linuxArgs.getConfigured());
        }
        if (this.live.isSet()) {
            map.put(KEY_LIVE, this.live.getConfigured().toString());
        }
        map.putAll(this.logs.toMap());
        if (this.newrelicLicensekey.isSet()) {
            map.put(KEY_NEWRELIC_LICENSEKEY, BoxfuseConfig.censor(this.newrelicLicensekey.getConfigured().getLicenseKey()));
        }
        map.putAll(this.payload.toMap());
        for (Map.Entry<Object, Object> entry : this.ports.entrySet()) {
            map.put(KEY_PORTS_PREFIX + entry.getKey(), ((Port)entry.getValue()).toSpec());
        }
        for (Map.Entry<Object, Object> entry : this.portsmap.entrySet()) {
            map.put(KEY_PORTSMAP_PREFIX + entry.getKey(), ((Port)entry.getValue()).toSpec());
        }
        if (this.ram.isSet()) {
            map.put(KEY_RAM, this.ram.getConfigured().toString());
        }
        if (this.securitygroup.isSet()) {
            map.put(KEY_SECURITYGROUP, this.securitygroup.getConfigured().getValue());
        }
        if (this.strace.isSet()) {
            map.put(KEY_STRACE, this.strace.getConfigured().toString());
        }
        if (this.subnets.isSet()) {
            map.put(KEY_SUBNETS, StringUtils.collectionToDelimitedString((Collection)this.subnets.get(), ","));
        }
        for (Map.Entry<Object, Object> entry : this.tags.entrySet()) {
            map.put(KEY_TAGS_PREFIX + entry.getKey(), ((AwsTagValue)entry.getValue()).getValue());
        }
        if (this.targetgroup.isSet()) {
            map.put(KEY_TARGETGROUP, this.targetgroup.getConfigured().getName());
        }
        if (this.tlsType.isSet()) {
            map.put(KEY_TLS_TYPE, this.tlsType.getConfigured().getName());
        }
        if (this.tmp.isSet()) {
            map.put(KEY_TMP, this.tmp.getConfigured().toString());
        }
        if (this.vault.isSet()) {
            map.put(KEY_VAULT, this.vault.getConfigured().toString());
        }
        if (this.virtualboxNatnetwork.isSet()) {
            map.put(KEY_VIRTUALBOX_NATNETWORK, this.virtualboxNatnetwork.getConfigured().toString());
        }
        map.putAll(this.windows.toMap());
        return map;
    }

    public Owner getOwner() {
        return this.owner;
    }

    private static String censor(String original) {
        if (original.length() < 4) {
            return StringUtils.trimOrPad("", original.length(), '*');
        }
        return StringUtils.trimOrPad(original.substring(0, 4), original.length(), '*');
    }

    public static class WindowsBoxfuseConfig {
        public final BoxfuseConfigProperty<String> user = new BoxfuseConfigProperty(System.getProperty("user.name"));
        public final BoxfuseConfigProperty<String> password = new BoxfuseConfigProperty();

        WindowsBoxfuseConfig() {
        }

        void configure(Map<String, String> cfg) {
            this.user.set((String[])new String[]{cfg.get(BoxfuseConfig.KEY_WINDOWS_USER)});
            this.password.set((String[])new String[]{cfg.get(BoxfuseConfig.KEY_WINDOWS_PASSWORD)});
        }

        Map<String, String> toMap() {
            TreeMap<String, String> map = new TreeMap<String, String>();
            if (this.user.isSet()) {
                map.put(BoxfuseConfig.KEY_WINDOWS_USER, this.user.getConfigured());
            }
            if (this.password.isSet()) {
                map.put(BoxfuseConfig.KEY_WINDOWS_PASSWORD, BoxfuseConfig.censor(this.password.getConfigured()));
            }
            return map;
        }
    }

    public static class PayloadBoxfuseConfig {
        public final BoxfuseConfigProperty<String> location = new BoxfuseConfigProperty();
        public final BoxfuseConfigProperty<Path> path = new BoxfuseConfigProperty(Path.of("/"));
        public final BoxfuseConfigProperty<PortName> port = new BoxfuseConfigProperty();
        public final BoxfuseConfigProperty<String> searchDir = new BoxfuseConfigProperty(System.getProperty("user.dir"));

        PayloadBoxfuseConfig() {
        }

        void configure(Map<String, String> cfg) {
            this.location.set((String[])new String[]{cfg.get(BoxfuseConfig.KEY_PAYLOAD)});
            this.path.set((Path[])new Path[]{Path.of(cfg.get(BoxfuseConfig.KEY_PAYLOAD_PATH))});
            this.port.set((PortName[])new PortName[]{PortName.of(cfg.get(BoxfuseConfig.KEY_PAYLOAD_PORT))});
            this.searchDir.set((String[])new String[]{cfg.get(BoxfuseConfig.KEY_PAYLOAD_SEARCHDIR)});
        }

        Map<String, String> toMap() {
            TreeMap<String, String> map = new TreeMap<String, String>();
            if (this.location.isSet()) {
                map.put(BoxfuseConfig.KEY_PAYLOAD, this.location.getConfigured());
            }
            if (this.path.isSet()) {
                map.put(BoxfuseConfig.KEY_PAYLOAD_PATH, this.path.getConfigured().getPath());
            }
            if (this.port.isSet()) {
                map.put(BoxfuseConfig.KEY_PAYLOAD_PORT, this.port.getConfigured().getName());
            }
            if (this.searchDir.isSet()) {
                map.put(BoxfuseConfig.KEY_PAYLOAD_SEARCHDIR, this.searchDir.getConfigured());
            }
            return map;
        }
    }

    public static class LogsBoxfuseConfig {
        public final BoxfuseConfigProperty<Boolean> auto = new BoxfuseConfigProperty(Boolean.TRUE);
        public final BoxfuseConfigProperty<Boolean> boot = new BoxfuseConfigProperty(Boolean.TRUE);
        public final BoxfuseConfigProperty<String> dir = new BoxfuseConfigProperty();
        public final LogsFilters filter;
        public final BoxfuseConfigProperty<LogsLayout> layout = new BoxfuseConfigProperty(LogsLayout.DEFAULT);
        public final BoxfuseConfigProperty<Boolean> tail = new BoxfuseConfigProperty(Boolean.FALSE);
        public final BoxfuseConfigProperty<LogsType> type = new BoxfuseConfigProperty(LogsType.CLOUDWATCH_LOGS);

        LogsBoxfuseConfig(Owner owner) {
            this.filter = new LogsFilters(owner);
        }

        void configure(Map<String, String> cfg) {
            this.auto.set((Boolean[])new Boolean[]{ConfigUtils.booleanOf(cfg, BoxfuseConfig.KEY_LOGS_AUTO)});
            this.boot.set((Boolean[])new Boolean[]{ConfigUtils.booleanOf(cfg, BoxfuseConfig.KEY_LOGS_BOOT)});
            this.dir.set((String[])new String[]{cfg.get(BoxfuseConfig.KEY_LOGS_DIR)});
            for (Map.Entry<String, String> entry : cfg.entrySet()) {
                if (!entry.getKey().startsWith(BoxfuseConfig.KEY_LOGS_FILTER_PREFIX)) continue;
                this.filter.addFilter(LogsFieldName.fromFilterName(entry.getKey().substring(BoxfuseConfig.KEY_LOGS_FILTER_PREFIX.length())), entry.getValue());
            }
            this.layout.set((LogsLayout[])new LogsLayout[]{LogsLayout.of(cfg.get(BoxfuseConfig.KEY_LOGS_LAYOUT))});
            this.tail.set((Boolean[])new Boolean[]{ConfigUtils.booleanOf(cfg, BoxfuseConfig.KEY_LOGS_TAIL)});
            this.type.set((LogsType[])new LogsType[]{LogsType.of(cfg.get(BoxfuseConfig.KEY_LOGS_TYPE))});
        }

        Map<String, String> toMap() {
            TreeMap<String, String> map = new TreeMap<String, String>();
            if (this.auto.isSet()) {
                map.put(BoxfuseConfig.KEY_LOGS_AUTO, this.auto.getConfigured().toString());
            }
            if (this.boot.isSet()) {
                map.put(BoxfuseConfig.KEY_LOGS_BOOT, this.boot.getConfigured().toString());
            }
            if (this.dir.isSet()) {
                map.put(BoxfuseConfig.KEY_LOGS_DIR, this.dir.getConfigured());
            }
            if (this.layout.isSet()) {
                map.put(BoxfuseConfig.KEY_LOGS_LAYOUT, this.layout.getConfigured().getSpec());
            }
            if (this.tail.isSet()) {
                map.put(BoxfuseConfig.KEY_LOGS_TAIL, this.tail.getConfigured().toString());
            }
            if (this.type.isSet()) {
                map.put(BoxfuseConfig.KEY_LOGS_TYPE, this.type.getConfigured().getName());
            }
            return map;
        }
    }

    public static class JvmBoxfuseConfig {
        public final BoxfuseConfigProperty<String> args = new BoxfuseConfigProperty();
        public final BoxfuseConfigProperty<String> mainClass = new BoxfuseConfigProperty();
        public final BoxfuseConfigProperty<String> mainArgs = new BoxfuseConfigProperty();
        public final BoxfuseConfigProperty<Boolean> jmx = new BoxfuseConfigProperty(Boolean.FALSE);

        JvmBoxfuseConfig() {
        }

        void configure(Map<String, String> cfg) {
            this.args.set((String[])new String[]{cfg.get(BoxfuseConfig.KEY_JVM_ARGS)});
            this.mainClass.set((String[])new String[]{cfg.get(BoxfuseConfig.KEY_JVM_MAIN_CLASS)});
            this.mainArgs.set((String[])new String[]{cfg.get(BoxfuseConfig.KEY_JVM_MAIN_ARGS)});
            this.jmx.set((Boolean[])new Boolean[]{ConfigUtils.booleanOf(cfg, BoxfuseConfig.KEY_JVM_JMX)});
        }

        Map<String, String> toMap() {
            TreeMap<String, String> map = new TreeMap<String, String>();
            if (this.args.isSet()) {
                map.put(BoxfuseConfig.KEY_JVM_ARGS, this.args.getConfigured());
            }
            if (this.args.isSet()) {
                map.put(BoxfuseConfig.KEY_JVM_MAIN_CLASS, this.mainClass.getConfigured());
            }
            if (this.mainArgs.isSet()) {
                map.put(BoxfuseConfig.KEY_JVM_MAIN_ARGS, this.mainArgs.getConfigured());
            }
            if (this.jmx.isSet()) {
                map.put(BoxfuseConfig.KEY_JVM_JMX, this.jmx.getConfigured().toString());
            }
            return map;
        }
    }

    public static class HealthcheckBoxfuseConfig {
        public final BoxfuseConfigProperty<Boolean> enabled = new BoxfuseConfigProperty(Boolean.TRUE);
        public final BoxfuseConfigProperty<Path> path = new BoxfuseConfigProperty();
        public final BoxfuseConfigProperty<PortName> port = new BoxfuseConfigProperty();
        public final BoxfuseConfigProperty<HealthcheckTimeout> timeout = new BoxfuseConfigProperty(HealthcheckTimeout.of("300"));

        HealthcheckBoxfuseConfig() {
        }

        void configure(Map<String, String> cfg) {
            this.enabled.set((Boolean[])new Boolean[]{ConfigUtils.booleanOf(cfg, BoxfuseConfig.KEY_HEALTHCHECK)});
            this.path.set((Path[])new Path[]{Path.of(cfg.get(BoxfuseConfig.KEY_HEALTHCHECK_PATH))});
            this.port.set((PortName[])new PortName[]{PortName.of(cfg.get(BoxfuseConfig.KEY_HEALTHCHECK_PORT))});
            this.timeout.set((HealthcheckTimeout[])new HealthcheckTimeout[]{HealthcheckTimeout.of(cfg.get(BoxfuseConfig.KEY_HEALTHCHECK_TIMEOUT))});
        }

        Map<String, String> toMap() {
            TreeMap<String, String> map = new TreeMap<String, String>();
            if (this.enabled.isSet()) {
                map.put(BoxfuseConfig.KEY_HEALTHCHECK, this.enabled.getConfigured().toString());
            }
            if (this.path.isSet()) {
                map.put(BoxfuseConfig.KEY_HEALTHCHECK_PATH, this.path.getConfigured().getPath());
            }
            if (this.port.isSet()) {
                map.put(BoxfuseConfig.KEY_HEALTHCHECK_PORT, this.port.getConfigured().getName());
            }
            if (this.timeout.isSet()) {
                map.put(BoxfuseConfig.KEY_HEALTHCHECK_TIMEOUT, "" + this.timeout.getConfigured().getValue());
            }
            return map;
        }
    }

    public static class DebugBoxfuseConfig {
        public final BoxfuseConfigProperty<Boolean> enabled = new BoxfuseConfigProperty(Boolean.FALSE);
        public final BoxfuseConfigProperty<Boolean> wait = new BoxfuseConfigProperty(Boolean.FALSE);

        DebugBoxfuseConfig() {
        }

        void configure(Map<String, String> cfg) {
            this.enabled.set((Boolean[])new Boolean[]{ConfigUtils.booleanOf(cfg, BoxfuseConfig.KEY_DEBUG)});
            this.wait.set((Boolean[])new Boolean[]{ConfigUtils.booleanOf(cfg, BoxfuseConfig.KEY_DEBUG_WAIT)});
        }

        Map<String, String> toMap() {
            TreeMap<String, String> map = new TreeMap<String, String>();
            if (this.enabled.isSet()) {
                map.put(BoxfuseConfig.KEY_DEBUG, this.enabled.getConfigured().toString());
            }
            if (this.wait.isSet()) {
                map.put(BoxfuseConfig.KEY_DEBUG_WAIT, this.wait.getConfigured().toString());
            }
            return map;
        }
    }
}

