/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.aws;

import com.boxfuse.base.aws.AwsRegion;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public enum AwsInstanceType {
    T3_NANO("t3.nano", "2 vCPU, 0.5 GB RAM", new AwsRegion[0]),
    T3_MICRO("t3.micro", "2 vCPU, 1 GB RAM", new AwsRegion[0]),
    T3_SMALL("t3.small", "2 vCPU, 2 GB RAM", new AwsRegion[0]),
    T3_MEDIUM("t3.medium", "2 vCPU, 4 GB RAM", new AwsRegion[0]),
    T3_LARGE("t3.large", "2 vCPU, 8 GB RAM", new AwsRegion[0]),
    T3_XLARGE("t3.xlarge", "4 vCPU, 16 GB RAM", new AwsRegion[0]),
    T3_2XLARGE("t3.2xlarge", "8 vCPU, 32 GB RAM", new AwsRegion[0]),
    T2_NANO("t2.nano", "1 vCPU, 0.5 GB RAM", new AwsRegion[0]),
    T2_MICRO("t2.micro", "1 vCPU, 1 GB RAM", new AwsRegion[0]),
    T2_SMALL("t2.small", "1 vCPU, 2 GB RAM", new AwsRegion[0]),
    T2_MEDIUM("t2.medium", "2 vCPU, 4 GB RAM", new AwsRegion[0]),
    T2_LARGE("t2.large", "2 vCPU, 8 GB RAM", new AwsRegion[0]),
    T2_XLARGE("t2.xlarge", "4 vCPU, 16 GB RAM", new AwsRegion[0]),
    T2_2XLARGE("t2.2xlarge", "8 vCPU, 32 GB RAM", new AwsRegion[0]),
    M6I_LARGE("m6i.large", "2 vCPU, 8 GB RAM", new AwsRegion[0]),
    M6I_XLARGE("m6i.xlarge", "4 vCPU, 16 GB RAM", new AwsRegion[0]),
    M6I_2XLARGE("m6i.2xlarge", "8 vCPU, 32 GB RAM", new AwsRegion[0]),
    M6I_4XLARGE("m6i.4xlarge", "16 vCPU, 64 GB RAM", new AwsRegion[0]),
    M6I_12XLARGE("m6i.12xlarge", "48 vCPU, 192 GB RAM", new AwsRegion[0]),
    M6I_16XLARGE("m6i.16xlarge", "64 vCPU, 256 GB RAM", new AwsRegion[0]),
    M6I_24XLARGE("m6i.24xlarge", "96 vCPU, 384 GB RAM", new AwsRegion[0]),
    M6I_32XLARGE("m6i.32xlarge", "128 vCPU, 512 GB RAM", new AwsRegion[0]),
    M6IN_LARGE("m6in.large", "2 vCPU, 8 GB RAM", new AwsRegion[0]),
    M6IN_XLARGE("m6in.xlarge", "4 vCPU, 16 GB RAM", new AwsRegion[0]),
    M6IN_2XLARGE("m6in.2xlarge", "8 vCPU, 32 GB RAM", new AwsRegion[0]),
    M6IN_4XLARGE("m6in.4xlarge", "16 vCPU, 64 GB RAM", new AwsRegion[0]),
    M6IN_12XLARGE("m6in.12xlarge", "48 vCPU, 192 GB RAM", new AwsRegion[0]),
    M6IN_16XLARGE("m6in.16xlarge", "64 vCPU, 256 GB RAM", new AwsRegion[0]),
    M6IN_24XLARGE("m6in.24xlarge", "96 vCPU, 384 GB RAM", new AwsRegion[0]),
    M6IN_32XLARGE("m6in.32xlarge", "128 vCPU, 512 GB RAM", new AwsRegion[0]),
    M5_LARGE("m5.large", "2 vCPU, 8 GB RAM", new AwsRegion[0]),
    M5_XLARGE("m5.xlarge", "4 vCPU, 16 GB RAM", new AwsRegion[0]),
    M5_2XLARGE("m5.2xlarge", "8 vCPU, 32 GB RAM", new AwsRegion[0]),
    M5_4XLARGE("m5.4xlarge", "16 vCPU, 64 GB RAM", new AwsRegion[0]),
    M5_8XLARGE("m5.8xlarge", "32 vCPU, 128 GB RAM", new AwsRegion[0]),
    M5_12XLARGE("m5.12xlarge", "48 vCPU, 192 GB RAM", new AwsRegion[0]),
    M5_16XLARGE("m5.16xlarge", "64 vCPU, 256 GB RAM", new AwsRegion[0]),
    M5_24XLARGE("m5.24xlarge", "96 vCPU, 384 GB RAM", new AwsRegion[0]),
    M4_LARGE("m4.large", "2 vCPU, 8 GB RAM", AwsRegion.EU_WEST_3),
    M4_XLARGE("m4.xlarge", "4 vCPU, 16 GB RAM", AwsRegion.EU_WEST_3),
    M4_2XLARGE("m4.2xlarge", "8 vCPU, 32 GB RAM", AwsRegion.EU_WEST_3),
    M4_4XLARGE("m4.4xlarge", "16 vCPU, 64 GB RAM", AwsRegion.EU_WEST_3),
    M4_10XLARGE("m4.10xlarge", "40 vCPU, 160 GB RAM", AwsRegion.EU_WEST_3),
    M4_16XLARGE("m4.16xlarge", "64 vCPU, 256 GB RAM", AwsRegion.EU_WEST_3),
    M3_MEDIUM("m3.medium", "1 vCPU, 3.75 GB RAM", AwsRegion.AP_NORTHEAST_2, AwsRegion.AP_SOUTH_1, AwsRegion.CA_CENTRAL_1, AwsRegion.EU_WEST_2, AwsRegion.EU_WEST_3, AwsRegion.US_EAST_2),
    M3_LARGE("m3.large", "2 vCPU, 7.5 GB RAM", AwsRegion.AP_NORTHEAST_2, AwsRegion.AP_SOUTH_1, AwsRegion.CA_CENTRAL_1, AwsRegion.EU_WEST_2, AwsRegion.EU_WEST_3, AwsRegion.US_EAST_2),
    M3_XLARGE("m3.xlarge", "4 vCPU, 15 GB RAM", AwsRegion.AP_NORTHEAST_2, AwsRegion.AP_SOUTH_1, AwsRegion.CA_CENTRAL_1, AwsRegion.EU_WEST_2, AwsRegion.EU_WEST_3, AwsRegion.US_EAST_2),
    M3_2XLARGE("m3.2xlarge", "8 vCPU, 30 GB RAM", AwsRegion.AP_NORTHEAST_2, AwsRegion.AP_SOUTH_1, AwsRegion.CA_CENTRAL_1, AwsRegion.EU_WEST_2, AwsRegion.EU_WEST_3, AwsRegion.US_EAST_2),
    C6I_LARGE("c6i.large", "2 vCPU, 4 GB RAM", new AwsRegion[0]),
    C6I_XLARGE("c6i.xlarge", "4 vCPU, 8 GB RAM", new AwsRegion[0]),
    C6I_2XLARGE("c6i.2xlarge", "8 vCPU, 16 GB RAM", new AwsRegion[0]),
    C6I_4XLARGE("c6i.4xlarge", "16 vCPU, 32 GB RAM", new AwsRegion[0]),
    C6I_8XLARGE("c6i.8xlarge", "32 vCPU, 64 GB RAM", new AwsRegion[0]),
    C6I_12XLARGE("c6i.12xlarge", "48 vCPU, 96 GB RAM", new AwsRegion[0]),
    C6I_16XLARGE("c6i.16xlarge", "64 vCPU, 128 GB RAM", new AwsRegion[0]),
    C6I_24XLARGE("c6i.24xlarge", "96 vCPU, 192 GB RAM", new AwsRegion[0]),
    C6I_32XLARGE("c6i.32xlarge", "128 vCPU, 256 GB RAM", new AwsRegion[0]),
    C6IN_LARGE("c6in.large", "2 vCPU, 4 GB RAM", new AwsRegion[0]),
    C6IN_XLARGE("c6in.xlarge", "4 vCPU, 8 GB RAM", new AwsRegion[0]),
    C6IN_2XLARGE("c6in.2xlarge", "8 vCPU, 16 GB RAM", new AwsRegion[0]),
    C6IN_4XLARGE("c6in.4xlarge", "16 vCPU, 32 GB RAM", new AwsRegion[0]),
    C6IN_8XLARGE("c6in.8xlarge", "32 vCPU, 64 GB RAM", new AwsRegion[0]),
    C6IN_12XLARGE("c6in.12xlarge", "48 vCPU, 96 GB RAM", new AwsRegion[0]),
    C6IN_16XLARGE("c6in.16xlarge", "64 vCPU, 128 GB RAM", new AwsRegion[0]),
    C6IN_24XLARGE("c6in.24xlarge", "96 vCPU, 192 GB RAM", new AwsRegion[0]),
    C6IN_32XLARGE("c6in.32xlarge", "128 vCPU, 256 GB RAM", new AwsRegion[0]),
    C5_LARGE("c5.large", "2 vCPU, 4 GB RAM", new AwsRegion[0]),
    C5_XLARGE("c5.xlarge", "4 vCPU, 8 GB RAM", new AwsRegion[0]),
    C5_2XLARGE("c5.2xlarge", "8 vCPU, 16 GB RAM", new AwsRegion[0]),
    C5_4XLARGE("c5.4xlarge", "16 vCPU, 32 GB RAM", new AwsRegion[0]),
    C5_9XLARGE("c5.9xlarge", "36 vCPU, 72 GB RAM", new AwsRegion[0]),
    C5_12XLARGE("c5.12xlarge", "48 vCPU, 96 GB RAM", new AwsRegion[0]),
    C5_18XLARGE("c5.18xlarge", "72 vCPU, 144 GB RAM", new AwsRegion[0]),
    C5_24XLARGE("c5.24xlarge", "96 vCPU, 192 GB RAM", new AwsRegion[0]),
    C4_LARGE("c4.large", "2 vCPU, 3.75 GB RAM", AwsRegion.EU_WEST_3),
    C4_XLARGE("c4.xlarge", "4 vCPU, 7.5 GB RAM", AwsRegion.EU_WEST_3),
    C4_2XLARGE("c4.2xlarge", "8 vCPU, 15 GB RAM", AwsRegion.EU_WEST_3),
    C4_4XLARGE("c4.4xlarge", "16 vCPU, 30 GB RAM", AwsRegion.EU_WEST_3),
    C4_8XLARGE("c4.8xlarge", "32 vCPU, 60 GB RAM", AwsRegion.EU_WEST_3),
    C3_LARGE("c3.large", "2 vCPU, 3.75 GB RAM", AwsRegion.AP_NORTHEAST_2, AwsRegion.AP_SOUTH_1, AwsRegion.CA_CENTRAL_1, AwsRegion.EU_WEST_2, AwsRegion.EU_WEST_3, AwsRegion.US_EAST_2),
    C3_XLARGE("c3.xlarge", "4 vCPU, 7.5 GB RAM", AwsRegion.AP_NORTHEAST_2, AwsRegion.AP_SOUTH_1, AwsRegion.CA_CENTRAL_1, AwsRegion.EU_WEST_2, AwsRegion.EU_WEST_3, AwsRegion.US_EAST_2),
    C3_2XLARGE("c3.2xlarge", "8 vCPU, 15 GB RAM", AwsRegion.AP_NORTHEAST_2, AwsRegion.AP_SOUTH_1, AwsRegion.CA_CENTRAL_1, AwsRegion.EU_WEST_2, AwsRegion.EU_WEST_3, AwsRegion.US_EAST_2),
    C3_4XLARGE("c3.4xlarge", "16 vCPU, 30 GB RAM", AwsRegion.AP_NORTHEAST_2, AwsRegion.AP_SOUTH_1, AwsRegion.CA_CENTRAL_1, AwsRegion.EU_WEST_2, AwsRegion.EU_WEST_3, AwsRegion.US_EAST_2),
    C3_8XLARGE("c3.8xlarge", "32 vCPU, 60 GB RAM", AwsRegion.AP_NORTHEAST_2, AwsRegion.AP_SOUTH_1, AwsRegion.CA_CENTRAL_1, AwsRegion.EU_WEST_2, AwsRegion.EU_WEST_3, AwsRegion.US_EAST_2),
    R6I_LARGE("r6i.large", "2 vCPU, 16 GB RAM", new AwsRegion[0]),
    R6I_XLARGE("r6i.xlarge", "4 vCPU, 32 GB RAM", new AwsRegion[0]),
    R6I_2XLARGE("r6i.2xlarge", "8 vCPU, 64 GB RAM", new AwsRegion[0]),
    R6I_4XLARGE("r6i.4xlarge", "16 vCPU, 128 GB RAM", new AwsRegion[0]),
    R6I_12XLARGE("r6i.12xlarge", "48 vCPU, 384 GB RAM", new AwsRegion[0]),
    R6I_24XLARGE("r6i.24xlarge", "96 vCPU, 768 GB RAM", new AwsRegion[0]),
    R6I_32XLARGE("r6i.32xlarge", "128 vCPU, 1024 GB RAM", new AwsRegion[0]),
    R6IN_LARGE("r6in.large", "2 vCPU, 16 GB RAM", new AwsRegion[0]),
    R6IN_XLARGE("r6in.xlarge", "4 vCPU, 32 GB RAM", new AwsRegion[0]),
    R6IN_2XLARGE("r6in.2xlarge", "8 vCPU, 64 GB RAM", new AwsRegion[0]),
    R6IN_4XLARGE("r6in.4xlarge", "16 vCPU, 128 GB RAM", new AwsRegion[0]),
    R6IN_12XLARGE("r6in.12xlarge", "48 vCPU, 384 GB RAM", new AwsRegion[0]),
    R6IN_24XLARGE("r6in.24xlarge", "96 vCPU, 768 GB RAM", new AwsRegion[0]),
    R6IN_32XLARGE("r6in.32xlarge", "128 vCPU, 1024 GB RAM", new AwsRegion[0]),
    R5_LARGE("r5.large", "2 vCPU, 16 GB RAM", new AwsRegion[0]),
    R5_XLARGE("r5.xlarge", "4 vCPU, 32 GB RAM", new AwsRegion[0]),
    R5_2XLARGE("r5.2xlarge", "8 vCPU, 64 GB RAM", new AwsRegion[0]),
    R5_4XLARGE("r5.4xlarge", "16 vCPU, 128 GB RAM", new AwsRegion[0]),
    R5_8XLARGE("r5.8xlarge", "32 vCPU, 256 GB RAM", new AwsRegion[0]),
    R5_12XLARGE("r5.12xlarge", "48 vCPU, 384 GB RAM", new AwsRegion[0]),
    R5_16XLARGE("r5.16xlarge", "64 vCPU, 512 GB RAM", new AwsRegion[0]),
    R5_24XLARGE("r5.24xlarge", "96 vCPU, 768 GB RAM", new AwsRegion[0]),
    R4_LARGE("r4.large", "2 vCPU, 15.25 GB RAM", new AwsRegion[0]),
    R4_XLARGE("r4.xlarge", "4 vCPU, 30.5 GB RAM", new AwsRegion[0]),
    R4_2XLARGE("r4.2xlarge", "8 vCPU, 61 GB RAM", new AwsRegion[0]),
    R4_4XLARGE("r4.4xlarge", "16 vCPU, 122 GB RAM", new AwsRegion[0]),
    R4_8XLARGE("r4.8xlarge", "32 vCPU, 244 GB RAM", new AwsRegion[0]),
    R4_16XLARGE("r4.16xlarge", "64 vCPU, 488 GB RAM", new AwsRegion[0]),
    R3_LARGE("r3.large", "2 vCPU, 15 GB RAM", AwsRegion.CA_CENTRAL_1, AwsRegion.EU_WEST_2, AwsRegion.EU_WEST_3),
    R3_XLARGE("r3.xlarge", "4 vCPU, 30.5 GB RAM", AwsRegion.CA_CENTRAL_1, AwsRegion.EU_WEST_2, AwsRegion.EU_WEST_3),
    R3_2XLARGE("r3.2xlarge", "8 vCPU, 61 GB RAM", AwsRegion.CA_CENTRAL_1, AwsRegion.EU_WEST_2, AwsRegion.EU_WEST_3),
    R3_4XLARGE("r3.4xlarge", "16 vCPU, 122 GB RAM", AwsRegion.CA_CENTRAL_1, AwsRegion.EU_WEST_2, AwsRegion.EU_WEST_3),
    R3_8XLARGE("r3.8xlarge", "32 vCPU, 244 GB RAM", AwsRegion.CA_CENTRAL_1, AwsRegion.EU_WEST_2, AwsRegion.EU_WEST_3);

    private final String name;
    private final String description;
    private final Collection<AwsRegion> unavailableRegions;

    private AwsInstanceType(String name, String description, AwsRegion ... unavailableRegions) {
        this.name = name;
        this.description = description;
        this.unavailableRegions = Arrays.asList(unavailableRegions);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<AwsRegion> getUnavailableRegions() {
        return this.unavailableRegions;
    }

    public boolean isT2() {
        return this.name.startsWith("t2");
    }

    public static AwsInstanceType fromName(String name) {
        for (AwsInstanceType awsInstanceType : AwsInstanceType.values()) {
            if (!awsInstanceType.name.equals(name)) continue;
            return awsInstanceType;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (AwsInstanceType type : AwsInstanceType.values()) {
            names.add(type.getName());
        }
        throw new BoxfuseException("Invalid AWS instance type: " + name + " (Possible values: " + StringUtils.collectionToDelimitedString(names, ", ") + ")");
    }
}

