/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.enums;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;

public enum DbType {
    NONE("none", "No database", null, null, -1, -1, null, null, null),
    POSTGRESQL("postgresql", "PostgreSQL database", "postgres", Port.getUnrestrictedTcpPort(5432), 63, 100, "psql", "(org\\.postgresql\\.)?postgresql-.*\\.jar", "org.postgresql.Driver"),
    MYSQL("mysql", "MySQL database", "MySQL", Port.getUnrestrictedTcpPort(3306), 16, 41, "mysql", "(mysql\\.)?mysql-connector-java-.*\\.jar", "com.mysql.jdbc.Driver");

    private final String name;
    private final String description;
    private final String rdsEngine;
    private final Port port;
    private final int usernameLength;
    private final int passwordLength;
    private final String executable;
    private final String jdbcDriverJarRegex;
    private final String jdbcDriverClass;

    private DbType(String name, String description, String rdsEngine, Port port, int usernameLength, int passwordLength, String executable, String jdbcDriverJarRegex, String jdbcDriverClass) {
        this.name = name;
        this.description = description;
        this.rdsEngine = rdsEngine;
        this.port = port;
        this.usernameLength = usernameLength;
        this.passwordLength = passwordLength;
        this.executable = executable;
        this.jdbcDriverJarRegex = jdbcDriverJarRegex;
        this.jdbcDriverClass = jdbcDriverClass;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public static DbType of(String name) {
        if (name == null) {
            return null;
        }
        return DbType.fromName(name);
    }

    @JsonCreator
    public static DbType fromName(String name) {
        if (name == null) {
            return NONE;
        }
        for (DbType dbType : DbType.values()) {
            if (!dbType.name.equals(name)) continue;
            return dbType;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (DbType type : DbType.values()) {
            names.add(type.getName());
        }
        throw new BoxfuseException("Invalid DB type: " + name + " (Possible values: " + StringUtils.collectionToDelimitedString(names, ", ") + ")");
    }

    public String getRdsEngine() {
        return this.rdsEngine;
    }

    public Port getPort() {
        return this.port;
    }

    public int getUsernameLength() {
        return this.usernameLength;
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public String getExecutable() {
        return this.executable;
    }

    public String getJdbcDriverJarRegex() {
        return this.jdbcDriverJarRegex;
    }

    public String getJdbcDriverClass() {
        return this.jdbcDriverClass;
    }
}

