/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.logs.cloudwatchlogs;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum LogsFieldName {
    INSTANCE("instance"),
    IMAGE("image"),
    APP("app"),
    LEVEL("level"),
    EVENT("event"),
    LOGGER("logger"),
    THREAD("thread"),
    ACCOUNT("account"),
    ACTION("action"),
    USER("user"),
    SESSION("session"),
    REQUEST("request"),
    MESSAGE("message"),
    START("start"),
    END("end"),
    LIMIT("limit"),
    TIMESTAMP("timestamp");

    private static final List<LogsFieldName> NON_FILTER_NAMES;
    private static final List<LogsFieldName> NON_MESSAGE_KEY_NAMES;
    private static final List<LogsFieldName> NON_LAYOUT_FIELD_NAMES;
    private final String name;

    private LogsFieldName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static LogsFieldName fromFilterName(String name) {
        if (!StringUtils.hasLength(name)) {
            throw new BoxfuseException("Missing logs filter name => must be one of " + StringUtils.arrayToDelimitedString((Object[])LogsFieldName.values(), ","));
        }
        for (LogsFieldName logsFieldName : LogsFieldName.values()) {
            if (!logsFieldName.name.equals(name) || NON_FILTER_NAMES.contains((Object)logsFieldName)) continue;
            return logsFieldName;
        }
        ArrayList<LogsFieldName> possibleValues = new ArrayList<LogsFieldName>(Arrays.asList(LogsFieldName.values()));
        possibleValues.removeAll(NON_FILTER_NAMES);
        throw new BoxfuseException("Invalid log filter name: " + name + " => must be one of " + StringUtils.collectionToDelimitedString(possibleValues, ","));
    }

    public static LogsFieldName fromMessageKeyName(String name) {
        for (LogsFieldName logsFieldName : LogsFieldName.values()) {
            if (!logsFieldName.name.equals(name) || NON_MESSAGE_KEY_NAMES.contains((Object)logsFieldName)) continue;
            return logsFieldName;
        }
        return null;
    }

    public static LogsFieldName fromLayoutFieldName(String name) {
        for (LogsFieldName logsFieldName : LogsFieldName.values()) {
            if (!logsFieldName.name.equals(name) || NON_LAYOUT_FIELD_NAMES.contains((Object)logsFieldName)) continue;
            return logsFieldName;
        }
        ArrayList<LogsFieldName> possibleValues = new ArrayList<LogsFieldName>(Arrays.asList(LogsFieldName.values()));
        possibleValues.removeAll(NON_LAYOUT_FIELD_NAMES);
        throw new BoxfuseException("Invalid log layout field: " + name + " => must be one of " + StringUtils.collectionToDelimitedString(possibleValues, ","));
    }

    static {
        NON_FILTER_NAMES = Collections.singletonList(TIMESTAMP);
        NON_MESSAGE_KEY_NAMES = Arrays.asList(TIMESTAMP, APP, START, END, LIMIT);
        NON_LAYOUT_FIELD_NAMES = Arrays.asList(START, END, LIMIT);
    }
}

