/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.logs.cloudwatchlogs;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.logs.cloudwatchlogs.LogsFieldName;
import com.boxfuse.base.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogsLayout {
    public static final LogsLayout DEFAULT = new LogsLayout("timestamp app? image? instance? event? 40:logger? 10:thread? account? action? user? session? request? message?");
    private final String spec;
    private final List<LogsFieldLayout> fieldLayouts = new ArrayList<LogsFieldLayout>();

    @JsonCreator
    public static LogsLayout of(String spec) {
        if (spec == null) {
            return null;
        }
        return new LogsLayout(spec);
    }

    private LogsLayout(String spec) {
        this.spec = spec;
        for (String fieldSpec : StringUtils.delimitedStringToArray(StringUtils.collapseWhitespace(spec.trim()), " ")) {
            this.fieldLayouts.add(new LogsFieldLayout(fieldSpec));
        }
    }

    @JsonValue
    public String getSpec() {
        return this.spec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsLayout that = (LogsLayout)o;
        return this.spec.equals(that.spec);
    }

    public int hashCode() {
        return this.spec.hashCode();
    }

    public String toString() {
        return this.spec;
    }

    public String render(Map<LogsFieldName, String> logsFieldValues, Map<LogsFieldName, Object> filters) {
        ArrayList<LogsFieldName> exactFilterMatches = new ArrayList<LogsFieldName>();
        for (LogsFieldName name : filters.keySet()) {
            if (!LogsLayout.containsExactMatch(filters, name)) continue;
            exactFilterMatches.add(name);
        }
        StringBuilder msg = new StringBuilder();
        for (LogsFieldLayout logsFieldLayout : this.fieldLayouts) {
            boolean exactFilterMatch;
            String value;
            String render = logsFieldLayout.render(value = logsFieldValues.get((Object)logsFieldLayout.getName()), exactFilterMatch = exactFilterMatches.contains((Object)logsFieldLayout.getName()));
            if (render.isEmpty()) continue;
            msg.append(render).append(" ");
        }
        return msg.toString().trim();
    }

    static boolean containsExactMatch(Map<LogsFieldName, Object> filters, LogsFieldName filterName) {
        Object val = filters.get((Object)filterName);
        if (val == null) {
            return false;
        }
        String valStr = val.toString();
        return !valStr.startsWith("*") && !valStr.endsWith("*");
    }

    static class LogsFieldLayout {
        private static final Pattern REGEX = Pattern.compile("(([1-9]\\d{0,5}):)?([a-z]{3,9})(\\?)?(:([1-9]\\d{0,5}))?");
        private final LogsFieldName name;
        private final boolean optional;
        private final Integer trimPadLeft;
        private final Integer trimPadRight;

        LogsFieldLayout(String spec) {
            Matcher matcher = REGEX.matcher(spec);
            if (matcher.find()) {
                this.trimPadLeft = matcher.group(1) == null ? null : Integer.valueOf(Integer.parseInt(matcher.group(2)));
                this.name = LogsFieldName.fromLayoutFieldName(matcher.group(3));
                this.optional = matcher.group(4) != null;
                Integer n = this.trimPadRight = matcher.group(6) == null ? null : Integer.valueOf(Integer.parseInt(matcher.group(6)));
                if (this.trimPadLeft != null && this.trimPadRight != null) {
                    throw new BoxfuseException("Invalid log layout field: " + spec + " => ensure only left or right trim is specified, not both");
                }
            } else {
                throw new BoxfuseException("Invalid log layout field: " + spec);
            }
        }

        public LogsFieldName getName() {
            return this.name;
        }

        String render(String s, boolean exactFilterMatch) {
            if ((s == null || exactFilterMatch) && this.optional) {
                return "";
            }
            if (this.trimPadLeft != null) {
                return StringUtils.leftTrimOrLeftPad(s, this.trimPadLeft);
            }
            if (this.trimPadRight != null) {
                return StringUtils.trimOrPad(s, this.trimPadRight);
            }
            return s == null ? "" : s;
        }
    }
}

