/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.metadata;

import com.boxfuse.base.coordinates.AppName;
import com.boxfuse.base.coordinates.Owner;
import com.boxfuse.base.enums.AppType;
import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.LogsType;
import com.boxfuse.base.enums.PlatformType;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.port.Protocol;
import com.boxfuse.base.port.Restriction;
import com.boxfuse.base.types.ComponentId;
import com.boxfuse.base.types.HealthcheckTimeout;
import com.boxfuse.base.types.Path;
import com.boxfuse.base.types.TmpGB;
import com.boxfuse.base.types.Version;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

public class ImageMetadata {
    public String id;
    public Owner owner;
    public AppName name;
    public Version version;
    public GeneratedMetadata generated = new GeneratedMetadata();
    public List<PlatformType> platforms = new ArrayList<PlatformType>();
    public boolean live;
    public PayloadMetadata payload = new PayloadMetadata();
    public TlsMetadata tls = new TlsMetadata();
    public AppMetadata app = new AppMetadata();
    public DatabaseMetadata database = new DatabaseMetadata();
    public LogsMetadata logs = new LogsMetadata();
    public SortedMap<ComponentId, Version> components = new TreeMap<ComponentId, Version>();
    public Map<PortName, PortMetadata> ports = new TreeMap<PortName, PortMetadata>();
    public HealthcheckMetadata healthcheck = new HealthcheckMetadata();
    public NotificationMetadata notification = new NotificationMetadata();
    public DebugMetadata debug = new DebugMetadata();
    public StraceMetadata strace = new StraceMetadata();
    public LinuxMetadata linux = new LinuxMetadata();
    public JvmMetadata jvm = new JvmMetadata();
    public TmpGB tmp = TmpGB.of(0);
    public long size;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageMetadata that = (ImageMetadata)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.owner.equals(that.owner)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (!this.generated.equals(that.generated)) {
            return false;
        }
        if (!this.platforms.equals(that.platforms)) {
            return false;
        }
        if (!this.payload.equals(that.payload)) {
            return false;
        }
        if (!this.tls.equals(that.tls)) {
            return false;
        }
        if (!this.app.equals(that.app)) {
            return false;
        }
        if (!this.database.equals(that.database)) {
            return false;
        }
        if (!this.logs.equals(that.logs)) {
            return false;
        }
        if (!this.components.equals(that.components)) {
            return false;
        }
        if (!this.ports.equals(that.ports)) {
            return false;
        }
        if (!this.healthcheck.equals(that.healthcheck)) {
            return false;
        }
        if (!this.notification.equals(that.notification)) {
            return false;
        }
        if (!this.debug.equals(that.debug)) {
            return false;
        }
        if (!this.strace.equals(that.strace)) {
            return false;
        }
        if (!this.linux.equals(that.linux)) {
            return false;
        }
        if (!this.jvm.equals(that.jvm)) {
            return false;
        }
        if (this.live != that.live) {
            return false;
        }
        if (!this.tmp.equals(that.tmp)) {
            return false;
        }
        return this.size == that.size;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.owner.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + this.generated.hashCode();
        result = 31 * result + this.platforms.hashCode();
        result = 31 * result + (this.live ? 1 : 0);
        result = 31 * result + this.components.hashCode();
        result = 31 * result + this.payload.hashCode();
        result = 31 * result + this.tls.hashCode();
        result = 31 * result + this.app.hashCode();
        result = 31 * result + this.database.hashCode();
        result = 31 * result + this.logs.hashCode();
        result = 31 * result + this.ports.hashCode();
        result = 31 * result + this.healthcheck.hashCode();
        result = 31 * result + this.debug.hashCode();
        result = 31 * result + this.strace.hashCode();
        result = 31 * result + this.linux.hashCode();
        result = 31 * result + this.jvm.hashCode();
        result = 31 * result + this.tmp.hashCode();
        result = 31 * result + (int)this.size;
        return result;
    }

    public int fingerprint() {
        int result = this.owner.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.version != null && !this.version.getVersion().startsWith("0.0.0.") ? this.version.hashCode() : 0);
        result = 31 * result + this.generated.fingerprint();
        result = 31 * result + this.platforms.hashCode();
        result = 31 * result + (this.live ? 1 : 0);
        result = 31 * result + this.components.hashCode();
        result = 31 * result + this.payload.fingerprint();
        result = 31 * result + this.tls.hashCode();
        result = 31 * result + this.app.hashCode();
        result = 31 * result + this.database.hashCode();
        result = 31 * result + this.logs.hashCode();
        result = 31 * result + this.ports.hashCode();
        result = 31 * result + this.healthcheck.hashCode();
        result = 31 * result + this.debug.hashCode();
        result = 31 * result + this.strace.hashCode();
        result = 31 * result + this.linux.hashCode();
        result = 31 * result + this.jvm.hashCode();
        result = 31 * result + this.tmp.hashCode();
        return result;
    }

    public static class JmxMetadata {
        public boolean enabled;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JmxMetadata that = (JmxMetadata)o;
            return this.enabled == that.enabled;
        }

        public int hashCode() {
            return this.enabled ? 1 : 0;
        }
    }

    public static class JvmMetadata {
        public String args;
        public String mainClass;
        public String mainArgs;
        public JmxMetadata jmx = new JmxMetadata();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JvmMetadata that = (JvmMetadata)o;
            if (!this.jmx.equals(that.jmx)) {
                return false;
            }
            return !((this.args == null ? that.args != null : !this.args.equals(that.args)) || (this.mainArgs == null ? that.mainArgs != null : !this.mainArgs.equals(that.mainArgs)) || (this.mainClass == null ? that.mainClass != null : !this.mainClass.equals(that.mainClass)));
        }

        public int hashCode() {
            int result = this.args != null ? this.args.hashCode() : 0;
            result = 31 * result + (this.mainClass != null ? this.mainClass.hashCode() : 0);
            result = 31 * result + (this.mainArgs != null ? this.mainArgs.hashCode() : 0);
            result = 31 * result + this.jmx.hashCode();
            return result;
        }
    }

    public static class LinuxMetadata {
        public String args;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LinuxMetadata that = (LinuxMetadata)o;
            return this.args != null ? this.args.equals(that.args) : that.args == null;
        }

        public int hashCode() {
            return this.args != null ? this.args.hashCode() : 0;
        }
    }

    public static class StraceMetadata {
        public boolean enabled;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StraceMetadata that = (StraceMetadata)o;
            return this.enabled == that.enabled;
        }

        public int hashCode() {
            return this.enabled ? 1 : 0;
        }
    }

    public static class DebugMetadata {
        public boolean enabled;
        public boolean wait;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DebugMetadata that = (DebugMetadata)o;
            return this.enabled == that.enabled && this.wait == that.wait;
        }

        public int hashCode() {
            int result = this.enabled ? 1 : 0;
            result = 31 * result + (this.wait ? 1 : 0);
            return result;
        }
    }

    public static class NotificationMetadata {
        public boolean enabled;
        public String path;
        public PortName port;
        public int timeout;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NotificationMetadata that = (NotificationMetadata)o;
            return this.enabled == that.enabled && this.timeout == that.timeout && this.path.equals(that.path) && !(this.port == null ? that.port != null : !this.port.equals(that.port));
        }

        public int hashCode() {
            int result = this.enabled ? 1 : 0;
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + this.timeout;
            return result;
        }
    }

    public static class HealthcheckMetadata {
        public boolean enabled;
        public Path path;
        public PortName port;
        public HealthcheckTimeout timeout;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HealthcheckMetadata that = (HealthcheckMetadata)o;
            return this.enabled == that.enabled && Objects.equals(this.timeout, that.timeout) && this.path.equals(that.path) && !(this.port == null ? that.port != null : !this.port.equals(that.port));
        }

        public int hashCode() {
            int result = this.enabled ? 1 : 0;
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }

    public static class PortMetadata {
        public int number;
        public Protocol protocol;
        public Restriction restriction;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PortMetadata that = (PortMetadata)o;
            return this.number == that.number && !(this.protocol == null ? that.protocol != null : !this.protocol.equals((Object)that.protocol)) && !(this.restriction == null ? that.restriction != null : !this.restriction.equals(that.restriction));
        }

        public int hashCode() {
            int result = this.number;
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.restriction != null ? this.restriction.hashCode() : 0);
            return result;
        }
    }

    public static class LogsMetadata {
        public LogsType type = LogsType.NONE;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogsMetadata that = (LogsMetadata)o;
            return this.type != null ? this.type.equals((Object)that.type) : that.type == null;
        }

        public int hashCode() {
            return this.type != null ? this.type.hashCode() : 0;
        }
    }

    public static class DatabaseMetadata {
        public DbType type = DbType.NONE;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DatabaseMetadata that = (DatabaseMetadata)o;
            return this.type != null ? this.type.equals((Object)that.type) : that.type == null;
        }

        public int hashCode() {
            return this.type != null ? this.type.hashCode() : 0;
        }
    }

    public static class AppMetadata {
        public AppType type = AppType.SINGLE_INSTANCE;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AppMetadata that = (AppMetadata)o;
            return this.type != null ? this.type.equals((Object)that.type) : that.type == null;
        }

        public int hashCode() {
            return this.type != null ? this.type.hashCode() : 0;
        }
    }

    public static class TlsMetadata {
        public boolean enabled;
        public String certificate;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TlsMetadata that = (TlsMetadata)o;
            return this.enabled == that.enabled && (this.certificate != null ? this.certificate.equals(that.certificate) : that.certificate == null);
        }

        public int hashCode() {
            int result = this.enabled ? 1 : 0;
            result = 31 * result + (this.certificate != null ? this.certificate.hashCode() : 0);
            return result;
        }
    }

    public static class PayloadMetadata {
        public String name;
        public PayloadType type;
        public int checksum;
        public String file;
        public Path path;
        public PortName port;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PayloadMetadata that = (PayloadMetadata)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            if (!this.type.equals((Object)that.type)) {
                return false;
            }
            if (this.checksum != that.checksum) {
                return false;
            }
            if (this.file != null ? !this.file.equals(that.file) : that.file != null) {
                return false;
            }
            return this.path.equals(that.path) && !(this.port == null ? that.port != null : !this.port.equals(that.port));
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.checksum;
            result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            return result;
        }

        public int fingerprint() {
            int result = this.name.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.checksum;
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            return result;
        }
    }

    public static class GeneratedMetadata {
        public Version boxfuse;
        public Date utc;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GeneratedMetadata that = (GeneratedMetadata)o;
            return this.boxfuse.equals(that.boxfuse) && this.utc.equals(that.utc);
        }

        public int hashCode() {
            int result = this.boxfuse.hashCode();
            result = 31 * result + this.utc.hashCode();
            return result;
        }

        public int fingerprint() {
            return this.boxfuse.hashCode();
        }
    }
}

