/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.metadata;

import com.boxfuse.base.coordinates.ImageCoordinates;
import com.boxfuse.base.exception.BoxfuseBugException;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.metadata.ImageMetadata;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataReader.class);

    private MetadataReader() {
    }

    public static String toJson(ImageMetadata imageMetadata) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            return objectMapper.writeValueAsString((Object)imageMetadata);
        }
        catch (IOException e) {
            throw new BoxfuseBugException("Unable to create Image metadata", e);
        }
    }

    public static ImageMetadata toMetadata(String json) {
        try {
            return MetadataReader.convert(json);
        }
        catch (IOException e) {
            LOGGER.error("Undeserializable metadata: " + json);
            throw new BoxfuseException("Unable to read image metadata", e);
        }
    }

    public static ImageMetadata toMetadata(ImageCoordinates coordinates, String json) {
        try {
            return MetadataReader.convert(json);
        }
        catch (IOException e) {
            LOGGER.error("Undeserializable metadata: " + json);
            throw new BoxfuseException("Unable to read metadata of " + coordinates, e);
        }
    }

    private static ImageMetadata convert(String json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (ImageMetadata)objectMapper.readValue(json, ImageMetadata.class);
    }
}

