/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.util;

import com.boxfuse.base.util.EnvironmentUtils;
import com.boxfuse.base.util.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProgressBar {
    private static final int BAR_LENGTH = 40;
    private static final char DONE_CHAR = '#';
    private static final char TODO_CHAR = '-';
    private final long max;
    private int charsToClear;
    private long lastUpdate;
    private final Map<Object, Long> parts = new ConcurrentHashMap<Object, Long>();

    public ProgressBar(long max) {
        this.max = max;
    }

    public void update(long current) {
        this.update(current, this);
    }

    public void update(long current, Object part) {
        Object key = part == null ? this : part;
        this.parts.put(key, current);
        if (System.currentTimeMillis() - this.lastUpdate < 100L) {
            return;
        }
        this.lastUpdate = System.currentTimeMillis();
        long progress = 0L;
        for (Long partProgress : this.parts.values()) {
            progress += partProgress.longValue();
        }
        int doneLength = this.max >= 0L ? (int)Math.round((double)progress * 1.0 * 40.0 / (double)this.max) : 0;
        String barDone = StringUtils.trimOrPad("", doneLength, '#');
        String bar = "[" + StringUtils.trimOrPad(barDone, 40, '-') + "]";
        String total = this.max >= 0L ? "/" + this.max / 1024L : "";
        long currentInK = progress / 1024L;
        String output = "\r" + bar + " " + currentInK + total + " K\r";
        this.print(output);
        this.charsToClear = Math.max(this.charsToClear, output.length());
    }

    public void clear() {
        this.print("\r" + StringUtils.trimOrPad("", this.charsToClear) + "\r");
    }

    private void print(String bar) {
        if (!EnvironmentUtils.isRunningInCi() && !EnvironmentUtils.isOutputMachineReadable()) {
            System.out.print(bar);
        }
    }
}

