/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.fsimage.cpio;

import com.boxfuse.base.fsimage.FsFile;
import com.boxfuse.base.fsimage.FsFileMode;
import com.boxfuse.base.fsimage.FsFileType;
import com.boxfuse.base.fsimage.FsPath;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001BE\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000fJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0016J\u000f\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u0015J\u000f\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/boxfuse/base/fsimage/cpio/CpioFsFile;", "Lcom/boxfuse/base/fsimage/FsFile;", "path", "Lcom/boxfuse/base/fsimage/FsPath;", "type", "Lcom/boxfuse/base/fsimage/FsFileType;", "mode", "Lcom/boxfuse/base/fsimage/FsFileMode;", "size", "", "destination", "", "major", "", "minor", "(Lcom/boxfuse/base/fsimage/FsPath;Lcom/boxfuse/base/fsimage/FsFileType;Lcom/boxfuse/base/fsimage/FsFileMode;JLjava/lang/String;Ljava/lang/Byte;Ljava/lang/Byte;)V", "Ljava/lang/Byte;", "getData", "Ljava/io/InputStream;", "getDestination", "getMajor", "()Ljava/lang/Byte;", "getMinor", "getMode", "getPath", "getSize", "getType", "boxfuse-base-fsimage"})
public final class CpioFsFile
implements FsFile {
    @NotNull
    private final FsPath path;
    @NotNull
    private final FsFileType type;
    @NotNull
    private final FsFileMode mode;
    private final long size;
    @Nullable
    private final String destination;
    @Nullable
    private final Byte major;
    @Nullable
    private final Byte minor;

    public CpioFsFile(@NotNull FsPath path, @NotNull FsFileType type, @NotNull FsFileMode mode, long size, @Nullable String destination, @Nullable Byte major, @Nullable Byte minor) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        this.path = path;
        this.type = type;
        this.mode = mode;
        this.size = size;
        this.destination = destination;
        this.major = major;
        this.minor = minor;
        FsFileType[] fsFileTypeArray = new FsFileType[]{FsFileType.BLOCK_DEVICE, FsFileType.CHARACTER_DEVICE};
        boolean bl = !CollectionsKt.listOf((Object[])fsFileTypeArray).contains((Object)this.type) || this.major != null && this.minor != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Only device files must have major and minor number";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.type != FsFileType.SYMBOLIC_LINK || this.destination != null;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Only symbolic links must have a destination";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public FsPath getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public FsFileType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public FsFileMode getMode() {
        return this.mode;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    @Nullable
    public String getDestination() {
        return this.destination;
    }

    @Override
    @Nullable
    public Byte getMajor() {
        return this.major;
    }

    @Override
    @Nullable
    public Byte getMinor() {
        return this.minor;
    }

    @Override
    @Nullable
    public InputStream getData() {
        return null;
    }
}

