/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.jar.dropwizard;

import com.boxfuse.base.payload.PayloadEntry;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.util.ZipUtils;
import com.boxfuse.generator.builder.ramdisk.RamDisk;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.JarJarPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.dropwizard.DropwizardPayload;
import com.boxfuse.generator.payload.PayloadFormat;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class DropwizardJarPayload
extends JarJarPayload
implements DropwizardPayload {
    public static boolean supports(String name, PayloadFormat format, Map<String, PayloadEntry> entries, boolean live) {
        return name.endsWith(".jar") && PayloadFormat.ZIP == format && entries.keySet().contains("META-INF/services/io.dropwizard.server.ServerFactory") && !live;
    }

    public DropwizardJarPayload(File file, byte[] bytes, Map<String, PayloadEntry> entries) {
        super(file, bytes, entries);
    }

    @Override
    public PayloadType getType() {
        return PayloadType.DROPWIZARD;
    }

    @Override
    public void installInto(RamDisk ramDisk, String baseDir) throws IOException {
        super.installInto(ramDisk, baseDir);
        for (String entry : this.entries.keySet()) {
            if (entry.contains("/") || !entry.endsWith(".yml") && !entry.endsWith(".json") && !entry.endsWith(".jks") && !entry.endsWith(".keystore")) continue;
            byte[] entryBytes = ZipUtils.unzipSingleEntryToByteArray((byte[])this.bytes, (String)entry);
            ramDisk.createFile("app/" + entry, false, entryBytes);
        }
    }

    @Override
    public byte[] getBoxfuseYml() {
        return ZipUtils.unzipSingleEntryToByteArray((byte[])this.bytes, (String)"boxfuse.yml");
    }
}

