/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.play;

import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.TlsType;
import com.boxfuse.base.payload.PayloadEntry;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.types.Pair;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.generator.builder.ramdisk.RamDisk;
import com.boxfuse.generator.builder.ramdisk.jvm.NewRelicConfig;
import com.boxfuse.generator.builder.ramdisk.jvm.play.PlayConfig;
import com.boxfuse.generator.builder.ramdisk.jvm.play.PlayPayload;
import com.boxfuse.generator.payload.DirectoryPayload;
import com.boxfuse.generator.payload.PayloadFormat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayDirectoryPayload
extends DirectoryPayload
implements PlayPayload {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayDirectoryPayload.class);
    private static final String CONFIG_FILE = "/conf/application.conf";
    private static final String SYSCTL_CONF = "conf/sysctl.conf";
    private final boolean customJRE;

    public static boolean supports(PayloadFormat format, Map<String, PayloadEntry> entries) {
        return PayloadFormat.DIRECTORY == format && PlayDirectoryPayload.containsPlayJars(entries);
    }

    private static boolean containsPlayJars(Map<String, PayloadEntry> entries) {
        for (String entry : entries.keySet()) {
            if (!entry.startsWith("lib/play.play") && !entry.startsWith("lib/com.typesafe.play.play")) continue;
            return true;
        }
        return false;
    }

    public PlayDirectoryPayload(File file, long payloadSize, Map<String, PayloadEntry> entries, boolean live) {
        super(file, payloadSize, entries, live);
        this.customJRE = entries.keySet().contains("conf/jre/bin/java");
    }

    @Override
    public PayloadType getType() {
        return PayloadType.PLAY;
    }

    @Override
    public Collection<String> getJavaAgents() {
        String regex = "conf/javaagents/.+\\.jar";
        ArrayList<String> javaAgents = new ArrayList<String>();
        for (String entry : this.entries.keySet()) {
            if (!entry.matches(regex)) continue;
            javaAgents.add("/app/" + entry);
        }
        return javaAgents;
    }

    @Override
    public NewRelicConfig getNewRelicConfig() {
        String config = IOUtils.copyToString((File)new File(this.file.getAbsolutePath() + "/conf/newrelic.yml"));
        if (config == null) {
            return null;
        }
        return new NewRelicConfig(config);
    }

    @Override
    public boolean hasCustomJRE() {
        return this.customJRE;
    }

    @Override
    public byte[] getCACerts() {
        byte[] cacerts = IOUtils.copyToByteArray((File)new File(this.file.getAbsolutePath() + "/conf/cacerts"));
        if (cacerts == null && this.customJRE) {
            cacerts = IOUtils.copyToByteArray((File)new File(this.file.getAbsolutePath() + "/" + "conf/jre" + "/lib/security/cacerts"));
        }
        return cacerts;
    }

    @Override
    public byte[] getLocalPolicyJar() {
        return IOUtils.copyToByteArray((File)new File(this.file.getAbsolutePath() + "/conf/local_policy.jar"));
    }

    @Override
    public byte[] getUsExportPolicyJar() {
        return IOUtils.copyToByteArray((File)new File(this.file.getAbsolutePath() + "/conf/US_export_policy.jar"));
    }

    @Override
    public DbType detectDbType() {
        for (DbType dbType : DbType.values()) {
            if (DbType.NONE == dbType || StringUtils.findFirstMatching(this.entries.keySet(), (String)("lib/" + dbType.getJdbcDriverJarRegex())) == null) continue;
            return dbType;
        }
        return DbType.NONE;
    }

    @Override
    public Pair<String, byte[]> getSysCtlConf() {
        if (this.entries.keySet().contains(SYSCTL_CONF)) {
            return Pair.of((Object)SYSCTL_CONF, null);
        }
        return null;
    }

    @Override
    public void installInto(RamDisk ramDisk, String baseDir) throws IOException {
        ramDisk.installDirectory(this.file, baseDir, true, Pattern.quote("jmxremote.password"));
    }

    @Override
    public PlayConfig getApplicationConf(TlsType tlsType) {
        String conf = "";
        if (this.entries.keySet().contains(CONFIG_FILE)) {
            conf = IOUtils.copyToString((File)new File(this.file.getAbsolutePath() + CONFIG_FILE));
            LOGGER.debug("Found application.conf in zip file");
        } else {
            LOGGER.debug("Unable to find application.conf in zip file => using defaults");
        }
        return new PlayConfig(tlsType, conf);
    }

    @Override
    public String getDirPrefix() {
        return "";
    }
}

