/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.play;

import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.TlsType;
import com.boxfuse.base.env.EnvVarName;
import com.boxfuse.base.env.EnvVarValue;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.generator.builder.certificate.CertificateManager;
import com.boxfuse.generator.builder.ramdisk.jvm.JvmRamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.jvm.play.PlayConfig;
import com.boxfuse.generator.builder.ramdisk.jvm.play.PlayPayload;
import com.boxfuse.generator.image.ImageSpecImpl;
import com.boxfuse.generator.inventory.Component;
import com.boxfuse.generator.inventory.Inventory;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayRamDiskBuilder<P extends PlayPayload>
extends JvmRamDiskBuilder<P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayRamDiskBuilder.class);
    static final String CUSTOM_JRE_LOCATION = "conf/jre";
    private static final String NATIVE_LOCATION = "conf/native";
    private final int playVersion = this.detectPlayVersion();
    private String generatedConfig;

    public PlayRamDiskBuilder(CertificateManager certificateManager, Inventory inventory, ImageSpecImpl spec, Collection<Component> virtualDiskComponents) {
        super(certificateManager, inventory, spec, virtualDiskComponents);
    }

    private int detectPlayVersion() {
        for (String entry : ((PlayPayload)this.payload).getEntries().keySet()) {
            if (entry.contains("/lib/com.typesafe.play.play-exceptions-")) {
                if (entry.contains("-2.2")) {
                    LOGGER.debug("Detected Play 2.2.x");
                    return 22;
                }
                if (entry.contains("-2.3")) {
                    LOGGER.debug("Detected Play 2.3.x");
                    return 23;
                }
                if (entry.contains("-2.4")) {
                    LOGGER.debug("Detected Play 2.4.x");
                    return 24;
                }
                if (entry.contains("-2.5")) {
                    LOGGER.debug("Detected Play 2.5.x");
                    return 25;
                }
                LOGGER.debug("Detected Play 2.6.x or newer");
                return 26;
            }
            if (!entry.contains("/lib/org.playframework.play_")) continue;
            LOGGER.debug("Detected Play 3.0.x or newer");
            return 30;
        }
        LOGGER.debug("Detected Play 2.1.x");
        return 21;
    }

    @Override
    protected void installPayloadWithDependencies() throws IOException {
        ((PlayPayload)this.payload).installInto(this.ramDisk, "app");
        if (this.spec.getTlsType() == TlsType.ACM) {
            this.ramDisk.createFile("app-config/boxfuse-selfsigned.jks", false, IOUtils.copyToByteArray((String)"generator/selfsigned/boxfuse-selfsigned.jks"));
        }
        if (this.generatedConfig != null) {
            this.ramDisk.createFile("app-config/application.conf", false, this.generatedConfig);
        }
    }

    @Override
    protected String getStartDir() {
        return "/app" + ((PlayPayload)this.payload).getDirPrefix();
    }

    @Override
    protected void installCustomJRE() throws IOException {
        this.ramDisk.createSymLink("jre", this.getStartDir() + "/" + CUSTOM_JRE_LOCATION);
    }

    @Override
    protected void installNativeBinariesAndLibs() throws IOException {
        this.ramDisk.createSymLink("native", this.getStartDir() + "/" + NATIVE_LOCATION);
    }

    @Override
    protected String computeJvmExtraArgs() {
        String keyStoreArg;
        String dbArgs = "";
        if (this.spec.getDbType() != null && DbType.NONE != this.spec.getDbType()) {
            String jvmArgs = this.spec.getJvm().getJvmArgs();
            if (!StringUtils.contains((String)jvmArgs, (String)"-Ddb.default.driver=")) {
                dbArgs = dbArgs + " \"-Ddb.default.driver=" + this.spec.getDbType().getJdbcDriverClass() + "\"";
            }
            if (!StringUtils.contains((String)jvmArgs, (String)"-Ddb.default.url=")) {
                dbArgs = dbArgs + " \"-Ddb.default.url=$BOXFUSE_DATABASE_URL\"";
            }
            if (!StringUtils.contains((String)jvmArgs, (String)"-Ddb.default.password=")) {
                dbArgs = dbArgs + " \"-Ddb.default.password=$BOXFUSE_DATABASE_PASSWORD\" ";
            }
            if (this.playVersion >= 24) {
                if (!StringUtils.contains((String)jvmArgs, (String)"-Ddb.default.username=")) {
                    dbArgs = dbArgs + " \"-Ddb.default.username=$BOXFUSE_DATABASE_USER\"";
                }
                if (!StringUtils.contains((String)jvmArgs, (String)"-Dslick.dbs.default.db.user=")) {
                    dbArgs = dbArgs + " \"-Dslick.dbs.default.db.user=$BOXFUSE_DATABASE_USER\"";
                }
                if (!StringUtils.contains((String)jvmArgs, (String)"-Dslick.dbs.default.db.driver=")) {
                    dbArgs = dbArgs + " \"-Dslick.dbs.default.db.driver=" + this.spec.getDbType().getJdbcDriverClass() + "\"";
                }
                if (!StringUtils.contains((String)jvmArgs, (String)"-Dslick.dbs.default.db.url=")) {
                    dbArgs = dbArgs + " \"-Dslick.dbs.default.db.url=$BOXFUSE_DATABASE_URL\"";
                }
                if (!StringUtils.contains((String)jvmArgs, (String)"-Dslick.dbs.default.db.password=")) {
                    dbArgs = dbArgs + " \"-Dslick.dbs.default.db.password=$BOXFUSE_DATABASE_PASSWORD\"";
                }
                if (!StringUtils.contains((String)jvmArgs, (String)"-Dslick.dbs.default.driver=")) {
                    if (DbType.MYSQL == this.spec.getDbType()) {
                        dbArgs = dbArgs + " \"-Dslick.dbs.default.driver=slick.driver.MySQLDriver$\"";
                    } else if (DbType.POSTGRESQL == this.spec.getDbType()) {
                        dbArgs = dbArgs + " \"-Dslick.dbs.default.driver=slick.driver.PostgresDriver$\"";
                    }
                }
            } else if (!StringUtils.contains((String)jvmArgs, (String)"-Ddb.default.user=")) {
                dbArgs = dbArgs + " \"-Ddb.default.user=$BOXFUSE_DATABASE_USER\"";
            }
        }
        Map<PortName, Port> ports = this.spec.getPorts();
        Port httpPort = ports.get(PortName.HTTP);
        Port httpsPort = ports.get(PortName.HTTPS);
        String archiveDir = ((PlayPayload)this.payload).getDirPrefix();
        String classpath = " -cp \"/app" + archiveDir + "/conf:/app" + archiveDir + "/lib/*\"";
        String httpsPortArg = httpsPort == null ? "" : " -Dhttps.port=" + httpsPort.getNumber();
        String keyStorePath = archiveDir + "/conf/boxfuse.jks";
        if (((PlayPayload)this.payload).getEntries().keySet().contains(keyStorePath.substring(1))) {
            LOGGER.debug("Detected user-supplied KeyStore at " + keyStorePath);
            keyStoreArg = this.getKeyStoreArg("/app" + keyStorePath, "boxfuse");
        } else {
            keyStoreArg = this.spec.getTlsType() == TlsType.ACM ? this.getKeyStoreArg("/app-config/boxfuse-selfsigned.jks", "boxfuse-selfsigned") : "";
        }
        String httpPortArg = this.playVersion >= 22 ? "-Dhttp.port=" + (httpPort == null ? "disabled" : Integer.valueOf(httpPort.getNumber())) : (httpPort == null ? "" : "-Dhttp.port=" + httpPort.getNumber());
        return httpPortArg + httpsPortArg + keyStoreArg + classpath + dbArgs;
    }

    private String getKeyStoreArg(String keyStorePath, String keyStorePassword) {
        String keyStoreArg = this.playVersion >= 24 ? " \"-Dplay.server.https.keyStore.path=" + keyStorePath + "\" -Dplay.server.https.keyStore.password=" + keyStorePassword : " \"-Dhttps.keyStore=" + keyStorePath + "\" -Dhttps.keyStorePassword=" + keyStorePassword;
        return keyStoreArg;
    }

    @Override
    protected void adjustEnvVars(Map<EnvVarName, EnvVarValue> envVars) {
        if (this.playVersion >= 24) {
            this.putIfAbsent(envVars, EnvVarName.BOXFUSE_JVM_MAIN_CLASS, EnvVarValue.asIs((String)"play.core.server.ProdServerStart"));
        } else {
            this.putIfAbsent(envVars, EnvVarName.BOXFUSE_JVM_MAIN_CLASS, EnvVarValue.asIs((String)"play.core.server.NettyServer"));
        }
        if (this.generatedConfig != null) {
            String jvmArgs;
            EnvVarValue jvmArgsEnvVar = envVars.get(EnvVarName.BOXFUSE_JVM_ARGS);
            String string = jvmArgs = jvmArgsEnvVar == null ? "" : jvmArgsEnvVar.getValue();
            if (!jvmArgs.contains("-Dconfig.file=")) {
                jvmArgs = jvmArgs + " -Dconfig.file=/app-config/application.conf";
                envVars.put(EnvVarName.BOXFUSE_JVM_ARGS, EnvVarValue.flexi((String)jvmArgs));
            }
        }
    }

    @Override
    protected void doAdjustSpecBasedOnConfig() {
        PlayConfig playConfig = ((PlayPayload)this.payload).getApplicationConf(this.spec.getTlsType());
        if (playConfig.isEmpty() && this.playVersion >= 25) {
            LOGGER.debug("Found empty application.conf => using default configuration file");
            this.generatedConfig = "play.http.secret.key=\"" + StringUtils.randomString((int)64) + "\"\nplay.filters.hosts {\n  allowed = [\".\"]\n}";
            playConfig = new PlayConfig(this.spec.getTlsType(), this.generatedConfig);
        }
        this.autoConfigurePorts(playConfig.getPorts());
        if (this.spec.getPayloadPath() == null) {
            this.spec.setPayloadPath(playConfig.getPayloadPath());
            if (!this.messagesDisplayed) {
                LOGGER.debug("Auto-configured payload path to " + this.spec.getPayloadPath());
            }
        }
        if (this.spec.getHealthcheckPath() == null) {
            this.spec.setHealthcheckPath(playConfig.getPayloadPath());
            if (!this.messagesDisplayed) {
                LOGGER.debug("Auto-configured healthcheck path to " + this.spec.getHealthcheckPath());
            }
        }
        super.doAdjustSpecBasedOnConfig();
    }
}

