/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.tomcat;

import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.payload.PayloadEntry;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.types.Pair;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.generator.builder.ramdisk.RamDisk;
import com.boxfuse.generator.builder.ramdisk.jvm.NewRelicConfig;
import com.boxfuse.generator.builder.ramdisk.jvm.tomcat.TomcatPayload;
import com.boxfuse.generator.payload.DirectoryPayload;
import com.boxfuse.generator.payload.PayloadFormat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;

public class TomcatDirectoryPayload
extends DirectoryPayload
implements TomcatPayload {
    private final boolean customJRE;

    public static boolean supports(PayloadFormat format, Map<String, PayloadEntry> entries) {
        return TomcatDirectoryPayload.containsWebInfSubDirectory(entries) && PayloadFormat.DIRECTORY == format;
    }

    private static boolean containsWebInfSubDirectory(Map<String, PayloadEntry> entries) {
        for (String entry : entries.keySet()) {
            if (!entry.startsWith("WEB-INF/")) continue;
            return true;
        }
        return false;
    }

    public TomcatDirectoryPayload(File file, long payloadSize, Map<String, PayloadEntry> entries, boolean live) {
        super(file, payloadSize, entries, live);
        this.customJRE = new File(file.getAbsolutePath() + "/" + "WEB-INF/jre" + "/bin/java").isFile();
    }

    @Override
    public PayloadType getType() {
        return PayloadType.TOMCAT;
    }

    @Override
    public Collection<String> getJavaAgents() {
        File[] agents;
        ArrayList<String> javaAgents = new ArrayList<String>();
        File agentsDir = new File(this.file.getAbsolutePath() + "/WEB-INF/javaagents");
        if (agentsDir.isDirectory() && agentsDir.canRead() && (agents = agentsDir.listFiles((dir, name) -> name.endsWith(".jar"))) != null) {
            for (File agent : agents) {
                javaAgents.add("/tomcat/webapps/ROOT/WEB-INF/javaagents/" + agent.getName());
            }
        }
        return javaAgents;
    }

    @Override
    public NewRelicConfig getNewRelicConfig() {
        File configFile = new File(this.file.getAbsolutePath() + "/WEB-INF/newrelic.yml");
        if (configFile.isFile()) {
            return new NewRelicConfig(IOUtils.copyToString((File)configFile));
        }
        return null;
    }

    @Override
    public boolean hasCustomJRE() {
        return this.customJRE;
    }

    @Override
    public byte[] getCACerts() {
        byte[] cacerts = IOUtils.copyToByteArray((File)new File(this.file.getAbsolutePath() + "/WEB-INF/cacerts"));
        if (cacerts == null && this.customJRE) {
            cacerts = IOUtils.copyToByteArray((File)new File(this.file.getAbsolutePath() + "/" + "WEB-INF/jre" + "/lib/security/cacerts"));
        }
        return cacerts;
    }

    @Override
    public byte[] getLocalPolicyJar() {
        return IOUtils.copyToByteArray((File)new File(this.file.getAbsolutePath() + "/WEB-INF/local_policy.jar"));
    }

    @Override
    public byte[] getUsExportPolicyJar() {
        return IOUtils.copyToByteArray((File)new File(this.file.getAbsolutePath() + "/WEB-INF/US_export_policy.jar"));
    }

    @Override
    public byte[] getKeyStore() {
        return IOUtils.copyToByteArray((File)new File(this.file.getAbsolutePath() + "/" + "WEB-INF/keystore.jks"));
    }

    @Override
    public byte[] getServerXml() {
        return IOUtils.copyToByteArray((File)new File(this.file.getAbsolutePath() + "/" + "WEB-INF/server.xml"));
    }

    @Override
    public DbType detectDbType() {
        File libDir = new File(this.file.getAbsolutePath() + "/WEB-INF/lib");
        File[] files = libDir.listFiles();
        if (files != null) {
            for (DbType dbType : DbType.values()) {
                if (DbType.NONE == dbType) continue;
                for (File lib : files) {
                    if (!lib.isFile() || !lib.getName().matches(dbType.getJdbcDriverJarRegex())) continue;
                    return dbType;
                }
            }
        }
        return DbType.NONE;
    }

    @Override
    public Pair<String, byte[]> getSysCtlConf() {
        if (this.entries.containsKey("WEB-INF/sysctl.conf")) {
            return Pair.of(null, (Object)IOUtils.copyToByteArray((File)new File(this.file.getAbsolutePath() + "/" + "WEB-INF/sysctl.conf")));
        }
        return null;
    }

    @Override
    public void installInto(RamDisk ramDisk, String baseDir) throws IOException {
        if (this.live) {
            ramDisk.createSymLink(baseDir, "/live");
        } else {
            ramDisk.installDirectory(this.file, baseDir, true, Pattern.quote("jmxremote.password"));
        }
    }
}

