/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.nodejs;

import com.boxfuse.base.coordinates.AppName;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.types.Version;
import com.boxfuse.base.util.JsonUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeJsConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeJsConfig.class);
    private AppName name;
    private Version version;
    private Version nodeJsVersion;
    private String start;
    private String main;
    private final Set<String> dependencies = new HashSet<String>();

    public NodeJsConfig(String packageJson, String npmShrinkwrapJson) {
        Map npmShrinkwrapJsonMap;
        Map npmShrinkwrapJsonDependencies;
        if (packageJson != null) {
            Map packageJsonDependencies;
            String nodeJsVersionStr;
            Map engines;
            String versionStr;
            Map packageJsonMap = JsonUtils.jsonToMap((String)packageJson);
            Map packageJsonScripts = (Map)packageJsonMap.get("scripts");
            this.start = packageJsonScripts != null ? (String)packageJsonScripts.get("start") : null;
            this.main = (String)packageJsonMap.get("main");
            String nameStr = (String)packageJsonMap.get("name");
            if (nameStr != null) {
                if (AppName.validate((String)nameStr)) {
                    this.name = AppName.of((String)nameStr);
                } else {
                    LOGGER.debug("Ignoring invalid app name from package.json: " + this.name);
                }
            }
            if ((versionStr = (String)packageJsonMap.get("version")) != null) {
                try {
                    this.version = new Version(versionStr);
                }
                catch (BoxfuseException e) {
                    LOGGER.debug("Ignoring non-fixed module version: " + versionStr);
                    this.version = null;
                }
            }
            if ((engines = (Map)packageJsonMap.get("engines")) != null && (nodeJsVersionStr = (String)engines.get("node")) != null) {
                try {
                    this.nodeJsVersion = new Version(nodeJsVersionStr);
                }
                catch (BoxfuseException e) {
                    LOGGER.debug("Ignoring non-fixed Node.js engine version: " + nodeJsVersionStr);
                    this.nodeJsVersion = null;
                }
            }
            if ((packageJsonDependencies = (Map)packageJsonMap.get("dependencies")) != null) {
                this.dependencies.addAll(packageJsonDependencies.keySet());
            }
        }
        if (npmShrinkwrapJson != null && (npmShrinkwrapJsonDependencies = (Map)(npmShrinkwrapJsonMap = JsonUtils.jsonToMap((String)npmShrinkwrapJson)).get("dependencies")) != null) {
            this.dependencies.addAll(npmShrinkwrapJsonDependencies.keySet());
        }
    }

    public AppName getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public Version getNodeJsVersion() {
        return this.nodeJsVersion;
    }

    public String getStart() {
        return this.start;
    }

    public String getMain() {
        return this.main;
    }

    public boolean hasDependency(String dependency) {
        return this.dependencies.contains(dependency);
    }
}

