/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.aws;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;

public class AwsELBName
implements Comparable<AwsELBName> {
    public static final AwsELBName AUTO = new AwsELBName("auto");
    private static final int ELB_NAME_MAX_LENGTH = 32;
    private final String name;

    @JsonCreator
    public static AwsELBName of(String name) {
        if (name == null) {
            return null;
        }
        if (AwsELBName.AUTO.name.equals(name)) {
            return AUTO;
        }
        return new AwsELBName(name);
    }

    private AwsELBName(String name) {
        if (!StringUtils.hasLength(name)) {
            throw new BoxfuseException("ELB name may not be empty");
        }
        if (name.length() > 32) {
            throw new BoxfuseException("Invalid ELB name (" + name + ") => Ensure it has a maximum length of " + 32 + " characters");
        }
        this.name = name;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsELBName that = (AwsELBName)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static AwsELBName generateUnique(List<AwsELBName> loadBalancerNames, String baseName) {
        String loadBalancerName = baseName;
        if (loadBalancerName.length() > 32) {
            loadBalancerName = loadBalancerName.substring(0, 32);
        }
        while (loadBalancerName.endsWith("-")) {
            loadBalancerName = loadBalancerName.substring(0, loadBalancerName.length() - 1);
        }
        String originalName = loadBalancerName;
        AwsELBName awsELBName = new AwsELBName(loadBalancerName);
        int counter = 0;
        while (loadBalancerNames.contains(awsELBName)) {
            awsELBName = new AwsELBName(originalName.substring(0, originalName.length() - 4) + String.format("%04d", counter++));
        }
        return awsELBName;
    }

    @Override
    public int compareTo(AwsELBName o) {
        return this.name.compareTo(o.name);
    }
}

