/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.aws;

import com.boxfuse.base.coordinates.AppCoordinates;
import com.boxfuse.base.coordinates.AppName;
import com.boxfuse.base.coordinates.ImageCoordinates;
import com.boxfuse.base.coordinates.Owner;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.types.EnvName;
import com.boxfuse.base.types.Version;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public class AwsTagValue
implements Comparable<AwsTagValue> {
    private final String value;

    @JsonCreator
    public static AwsTagValue of(String value) {
        if (value == null) {
            return null;
        }
        return new AwsTagValue(value);
    }

    public static AwsTagValue forName(ImageCoordinates coordinates, EnvName env) {
        return new AwsTagValue("boxfuse " + coordinates + "@" + env);
    }

    public static AwsTagValue forEnv(EnvName value) {
        return new AwsTagValue(value.getName());
    }

    public static AwsTagValue forApp(AppCoordinates value) {
        return new AwsTagValue(value.toString());
    }

    public static AwsTagValue forApp(Owner owner, AppName app) {
        return AwsTagValue.forApp(new AppCoordinates(owner, app));
    }

    public static AwsTagValue forDb(Owner owner, AppName app) {
        return new AwsTagValue(new AppCoordinates(owner, app).toString());
    }

    public static AwsTagValue forImage(ImageCoordinates coordinates) {
        return new AwsTagValue(coordinates.toString());
    }

    public static AwsTagValue forImage(Owner owner, AppName app, Version version) {
        return AwsTagValue.forImage(new ImageCoordinates(owner, app, version));
    }

    private AwsTagValue(String value) {
        if (!value.matches("^[ a-zA-Z0-9_+\\-=.:/@()\\[\\]{}<>]{0,255}$")) {
            throw new BoxfuseException("Invalid tag value (may only contain a-z, A-Z, 0-9, _+-=.:/@ (max 255 chars)): " + value);
        }
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsTagValue awsTagValue = (AwsTagValue)o;
        return this.value.equals(awsTagValue.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(AwsTagValue o) {
        return this.value.compareTo(o.value);
    }

    public String toString() {
        return this.value;
    }
}

