/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.env;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.types.ComponentId;
import java.util.Locale;

public class EnvVarName
implements Comparable<EnvVarName> {
    public static final EnvVarName BOXFUSE_ACCOUNT = new EnvVarName("BOXFUSE_ACCOUNT");
    public static final EnvVarName BOXFUSE_APP = new EnvVarName("BOXFUSE_APP");
    public static final EnvVarName BOXFUSE_CLOUDWATCHLOGS_ENDPOINT = new EnvVarName("BOXFUSE_CLOUDWATCHLOGS_ENDPOINT");
    public static final EnvVarName BOXFUSE_DATABASE_HOST = new EnvVarName("BOXFUSE_DATABASE_HOST");
    public static final EnvVarName BOXFUSE_DATABASE_PORT = new EnvVarName("BOXFUSE_DATABASE_PORT");
    public static final EnvVarName BOXFUSE_DATABASE_NAME = new EnvVarName("BOXFUSE_DATABASE_NAME");
    public static final EnvVarName BOXFUSE_DATABASE_CA_CERT = new EnvVarName("BOXFUSE_DATABASE_CA_CERT");
    public static final EnvVarName BOXFUSE_DATABASE_URL = new EnvVarName("BOXFUSE_DATABASE_URL");
    public static final EnvVarName BOXFUSE_DATABASE_USER = new EnvVarName("BOXFUSE_DATABASE_USER");
    public static final EnvVarName BOXFUSE_DATABASE_PASSWORD = new EnvVarName("BOXFUSE_DATABASE_PASSWORD");
    public static final EnvVarName BOXFUSE_DEBUG = new EnvVarName("BOXFUSE_DEBUG");
    public static final EnvVarName BOXFUSE_DEBUG_WAIT = new EnvVarName("BOXFUSE_DEBUG_WAIT");
    public static final EnvVarName BOXFUSE_DEVAGENT = new EnvVarName("BOXFUSE_DEVAGENT");
    public static final EnvVarName BOXFUSE_ENV = new EnvVarName("BOXFUSE_ENV");
    public static final EnvVarName BOXFUSE_LIVE = new EnvVarName("BOXFUSE_LIVE");
    public static final EnvVarName BOXFUSE_HOST_IP = new EnvVarName("BOXFUSE_HOST_IP");
    public static final EnvVarName BOXFUSE_IMAGE_ID = new EnvVarName("BOXFUSE_IMAGE_ID");
    public static final EnvVarName BOXFUSE_IMAGE_COORDINATES = new EnvVarName("BOXFUSE_IMAGE_COORDINATES");
    public static final EnvVarName BOXFUSE_IMAGE_VERSION = new EnvVarName("BOXFUSE_IMAGE_VERSION");
    public static final EnvVarName BOXFUSE_INSTANCE_ID = new EnvVarName("BOXFUSE_INSTANCE_ID");
    public static final EnvVarName BOXFUSE_INSTANCE_IP = new EnvVarName("BOXFUSE_INSTANCE_IP");
    public static final EnvVarName BOXFUSE_PAYLOAD_NAME = new EnvVarName("BOXFUSE_PAYLOAD_NAME");
    public static final EnvVarName BOXFUSE_PORTS_HTTPS__REDIRECT = new EnvVarName("BOXFUSE_PORTS_HTTPS__REDIRECT");
    public static final EnvVarName BOXFUSE_PORTS_ADMIN_HTTPS__REDIRECT = new EnvVarName("BOXFUSE_PORTS_ADMIN_HTTPS__REDIRECT");
    public static final EnvVarName BOXFUSE_TMP = new EnvVarName("BOXFUSE_TMP");
    public static final EnvVarName BOXFUSE_VERSION = new EnvVarName("BOXFUSE_VERSION");
    public static final EnvVarName BOXFUSE_WINDOWS_PASSWORD = new EnvVarName("BOXFUSE_WINDOWS_PASSWORD");
    public static final EnvVarName BOXFUSE_WINDOWS_USER = new EnvVarName("BOXFUSE_WINDOWS_USER");
    public static final EnvVarName BOXFUSE_JVM_ARGS = new EnvVarName("BOXFUSE_JVM_ARGS");
    public static final EnvVarName BOXFUSE_JVM_MAIN_CLASS = new EnvVarName("BOXFUSE_JVM_MAIN_CLASS");
    public static final EnvVarName BOXFUSE_JVM_MAIN_ARGS = new EnvVarName("BOXFUSE_JVM_MAIN_ARGS");
    public static final EnvVarName BOXFUSE_JVM_JMX = new EnvVarName("BOXFUSE_JVM_JMX");
    public static final EnvVarName BOXFUSE_NODEJS_MAIN_MODULE = new EnvVarName("BOXFUSE_NODEJS_MAIN_MODULE");
    public static final EnvVarName BOXFUSE_NODEJS_MAIN_ARGS = new EnvVarName("BOXFUSE_NODEJS_MAIN_ARGS");
    private final String name;

    public String getName() {
        return this.name;
    }

    private EnvVarName(String name) {
        if (!name.matches("[a-zA-Z_][a-zA-Z0-9_]*")) {
            throw new BoxfuseException("Illegal environment variable name (may only contain a-z, A-Z, 0-9 and _, and not start with a digit): " + name);
        }
        this.name = name;
    }

    public static EnvVarName of(String name) {
        if (name.startsWith("BOXFUSE")) {
            throw new BoxfuseException("Environment variables starting with BOXFUSE are reserved for Boxfuse's own use: " + name);
        }
        return new EnvVarName(name);
    }

    public static EnvVarName of(PortName portName) {
        return new EnvVarName("BOXFUSE_PORTS_" + portName.getName().toUpperCase(Locale.ENGLISH).replace("-", "_"));
    }

    public static EnvVarName of(ComponentId componentId) {
        return new EnvVarName("BOXFUSE_COMPONENTS_" + componentId.getId().toUpperCase(Locale.ENGLISH).replace("-", "_"));
    }

    public String quote() {
        return "$" + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvVarName that = (EnvVarName)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(EnvVarName o) {
        return this.name.compareTo(o.name);
    }
}

