/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.payload;

import com.fasterxml.jackson.annotation.JsonCreator;

public enum PayloadType {
    JAR("Jar"),
    TOMCAT("Tomcat"),
    TOMEE("TomEE"),
    PLAY("Play"),
    GRAILS("Grails"),
    JHIPSTER("JHipster"),
    SPRINGBOOT("Spring Boot"),
    DROPWIZARD("Dropwizard"),
    NODEJS("Node.js"),
    REVEL("Revel"),
    LINUX_X64("Linux x64");

    private final String description;

    private PayloadType(String description) {
        this.description = description;
    }

    public String toString() {
        return this.description;
    }

    public String getDescription() {
        return this.description;
    }

    @JsonCreator
    public static PayloadType fromName(String name) {
        if ("WAR".equals(name) || "EXPLODED_WAR".equals(name)) {
            return TOMCAT;
        }
        if ("TOMEE_WEBPROFILE".equals(name) || "TOMEE_PLUS".equals(name)) {
            return TOMEE;
        }
        if ("EXPLODED_JAR".equals(name)) {
            return JAR;
        }
        if ("ELF64".equals(name)) {
            return LINUX_X64;
        }
        return PayloadType.valueOf(name);
    }
}

