/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.util;

import com.boxfuse.base.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <K, V> Map<V, List<K>> findDuplicateValues(Map<K, V> map) {
        HashMap result = new HashMap();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V value = entry.getValue();
            if (!result.containsKey(value)) {
                result.put(value, new ArrayList());
            }
            ((List)result.get(value)).add(entry.getKey());
        }
        Iterator iterator = result.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            if (((List)e.getValue()).size() != 1) continue;
            iterator.remove();
        }
        return result;
    }

    public static Map<String, String> flattenMap(Map<Object, Object> source) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        CollectionUtils.buildFlattenedMap(result, source, null);
        return result;
    }

    private static void buildFlattenedMap(Map<String, String> result, Map<Object, Object> source, String path) {
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            Object value;
            String key = entry.getKey().toString();
            if (StringUtils.hasLength(path)) {
                key = key.startsWith("[") ? path + key : path + "." + key;
            }
            if ((value = entry.getValue()) instanceof Map) {
                Map map = (Map)value;
                CollectionUtils.buildFlattenedMap(result, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int count = 0;
                for (Object object : collection) {
                    CollectionUtils.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), key);
                }
                continue;
            }
            result.put(key, value != null ? value.toString() : "");
        }
    }

    public static <T> List<List<T>> chunkList(List<T> largeList, int chunkSize) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("Invalid chunk size: " + chunkSize);
        }
        ArrayList<List<T>> chunkList = new ArrayList<List<T>>(largeList.size() / chunkSize);
        for (int i = 0; i < largeList.size(); i += chunkSize) {
            chunkList.add(largeList.subList(i, i + chunkSize >= largeList.size() ? largeList.size() : i + chunkSize));
        }
        return chunkList;
    }
}

