/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.aws;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collection;

public class AwsTargetGroupName
implements Comparable<AwsTargetGroupName> {
    private static final int NAME_MAX_LENGTH = 32;
    public static final AwsTargetGroupName AUTO = new AwsTargetGroupName("auto");
    private final String name;

    @JsonCreator
    public static AwsTargetGroupName of(String name) {
        if (name == null) {
            return null;
        }
        if (AwsTargetGroupName.AUTO.name.equals(name)) {
            return AUTO;
        }
        return new AwsTargetGroupName(name);
    }

    private AwsTargetGroupName(String name) {
        if (!StringUtils.hasLength(name)) {
            throw new BoxfuseException("Target Group name may not be empty");
        }
        if (name.length() > 32) {
            throw new BoxfuseException("Invalid Target Group name (" + name + ") => Ensure it has a maximum length of " + 32 + " characters");
        }
        if (!name.matches("[A-Za-z0-9-]{1,32}") || name.startsWith("-") || name.endsWith("-") || name.contains("--")) {
            throw new BoxfuseException("Invalid Target Group name (" + name + ") => Ensure it only contains alphanumeric characters or hyphens, and does not begin or end with a hyphen");
        }
        this.name = name;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsTargetGroupName that = (AwsTargetGroupName)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static AwsTargetGroupName generateUnique(Collection<AwsTargetGroupName> existingNames, String baseName) {
        String targetGroupName = baseName;
        if (targetGroupName.length() > 32) {
            targetGroupName = targetGroupName.substring(0, 32);
        }
        while (targetGroupName.endsWith("-")) {
            targetGroupName = targetGroupName.substring(0, targetGroupName.length() - 1);
        }
        String originalName = targetGroupName;
        AwsTargetGroupName awsTargetGroupName = new AwsTargetGroupName(targetGroupName);
        int counter = 0;
        while (existingNames.contains(awsTargetGroupName)) {
            awsTargetGroupName = new AwsTargetGroupName(originalName.substring(0, originalName.length() - 4) + String.format("%04d", counter++));
        }
        return awsTargetGroupName;
    }

    @Override
    public int compareTo(AwsTargetGroupName o) {
        return this.name.compareTo(o.name);
    }
}

