/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.bootable;

import com.boxfuse.base.exception.BoxfuseBugException;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.Template;
import de.waldheinz.fs.BlockDevice;
import de.waldheinz.fs.fat.FatFile;
import de.waldheinz.fs.fat.FatFileSystem;
import de.waldheinz.fs.fat.FatLfnDirectory;
import de.waldheinz.fs.fat.FatLfnDirectoryEntry;
import de.waldheinz.fs.fat.FatType;
import de.waldheinz.fs.fat.SuperFloppyFormatter;
import de.waldheinz.fs.util.FileDisk;
import de.waldheinz.fs.util.RamDisk;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006J\u0016\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006J \u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/boxfuse/base/bootable/BootableDiskImageBuilder;", "", "linuxArgs", "", "(Ljava/lang/String;)V", "<set-?>", "", "diskSize", "getDiskSize", "()J", "syslinuxCfgBytes", "", "build", "", "output", "Ljava/io/File;", "ramDisk", "Ljava/io/InputStream;", "ramDiskSize", "createFileSystem", "virtualDisk", "Lde/waldheinz/fs/BlockDevice;", "findLdlinux", "", "virtualDiskBytes", "patchSyslinux", "toDiskSize", "syslinuxCfgSize", "Companion", "boxfuse-base-bootable"})
public final class BootableDiskImageBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String linuxArgs;
    private long diskSize;
    @NotNull
    private final byte[] syslinuxCfgBytes;
    private static final int SECTOR_SIZE = 512;
    private static final int LDLINUX_MAGIC = 1051853566;
    public static final int CHECKSUM_OFFSET = 40;
    @NotNull
    private static final byte[] KERNEL_BYTES = IOUtils.copyToByteArray("linux/bzImage");
    @NotNull
    private static final byte[] KERNEL_LICENSE_BYTES = IOUtils.copyToByteArray("linux/LICENSE");
    @NotNull
    private static final byte[] BS_BYTES = IOUtils.copyToByteArray("syslinux/bs.bin");
    @NotNull
    private static final byte[] MENU_LST_BYTES = IOUtils.copyToByteArray("syslinux/menu.lst");
    @NotNull
    private static final byte[] SYSLINUX_TXT_BYTES = IOUtils.copyToByteArray("syslinux/syslinux.txt");
    @NotNull
    private static final byte[] LDLINUX_BYTES = IOUtils.copyToByteArray("syslinux/ldlinux.sys");
    @NotNull
    public static final String INITRD_GZ = "initrd.gz";
    @NotNull
    public static final String BOOTX64_EFI = "BOOTX64.EFI";

    public BootableDiskImageBuilder(@NotNull String linuxArgs) {
        Intrinsics.checkNotNullParameter(linuxArgs, "linuxArgs");
        this.linuxArgs = linuxArgs;
        Object object = new Object[]{this.linuxArgs};
        String string = Template.process("syslinux/syslinux.cfg.template", object);
        Intrinsics.checkNotNullExpressionValue(string, "process(\"syslinux/syslinux.cfg.template\", linuxArgs)");
        object = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes((Charset)object);
        Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
        this.syslinuxCfgBytes = byArray;
    }

    public final long getDiskSize() {
        return this.diskSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] build(@NotNull InputStream ramDisk, long ramDiskSize) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(ramDisk, "ramDisk");
        try {
            byte[] syslinuxCfgBytes = this.syslinuxCfgBytes;
            this.diskSize = this.toDiskSize(ramDiskSize, syslinuxCfgBytes.length);
            BlockDevice virtualDisk = (BlockDevice)new RamDisk((int)this.diskSize);
            this.createFileSystem(virtualDisk, syslinuxCfgBytes, ramDisk);
            byte[] virtualDiskBytes = new byte[(int)virtualDisk.getSize()];
            virtualDisk.read(0L, ByteBuffer.wrap(virtualDiskBytes));
            virtualDisk.close();
            this.patchSyslinux(virtualDiskBytes);
            byArray = virtualDiskBytes;
        }
        catch (IOException e) {
            throw new BoxfuseBugException("Unable to fuse disk image", e);
        }
        finally {
            IOUtils.close(ramDisk);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void build(@NotNull File output, @NotNull InputStream ramDisk, long ramDiskSize) {
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(ramDisk, "ramDisk");
        RandomAccessFile file = null;
        try {
            byte[] syslinuxCfgBytes = this.syslinuxCfgBytes;
            this.diskSize = this.toDiskSize(ramDiskSize, syslinuxCfgBytes.length);
            FileDisk fileDisk = FileDisk.create((File)output, (long)this.diskSize);
            Intrinsics.checkNotNullExpressionValue(fileDisk, "create(output, diskSize)");
            BlockDevice virtualDisk = (BlockDevice)fileDisk;
            this.createFileSystem(virtualDisk, syslinuxCfgBytes, ramDisk);
            virtualDisk.close();
            file = new RandomAccessFile(output, "rw");
            byte[] first5MB = new byte[0x500000];
            file.read(first5MB);
            this.patchSyslinux(first5MB);
            file.seek(0L);
            file.write(first5MB);
        }
        catch (IOException e) {
            throw new BoxfuseBugException("Unable to fuse disk image", e);
        }
        finally {
            IOUtils.close(file);
            IOUtils.close(ramDisk);
        }
    }

    private final void createFileSystem(BlockDevice virtualDisk, byte[] syslinuxCfgBytes, InputStream ramDisk) throws IOException {
        FatFileSystem fatFileSystem = SuperFloppyFormatter.get((BlockDevice)virtualDisk).setFatType(FatType.FAT16).setOemName("SYSLINUX").setVolumeLabel("BOXFUSE").format();
        Intrinsics.checkNotNullExpressionValue(fatFileSystem, "get(virtualDisk)\n            .setFatType(FatType.FAT16).setOemName(\"SYSLINUX\").setVolumeLabel(\"BOXFUSE\").format()");
        FatFileSystem fileSystem = fatFileSystem;
        FatLfnDirectory fatLfnDirectory = fileSystem.getRoot();
        Intrinsics.checkNotNullExpressionValue(fatLfnDirectory, "fileSystem.root");
        FatLfnDirectory root = fatLfnDirectory;
        root.addFile("LDLINUX.SYS").getFile().write(0L, ByteBuffer.wrap(LDLINUX_BYTES));
        root.addFile("SYSLINUX.CFG").getFile().write(0L, ByteBuffer.wrap(syslinuxCfgBytes));
        root.addFile("SYSLINUX.TXT").getFile().write(0L, ByteBuffer.wrap(SYSLINUX_TXT_BYTES));
        FatLfnDirectory fatLfnDirectory2 = root.addDirectory("EFI").getDirectory().addDirectory("BOOT").getDirectory();
        Intrinsics.checkNotNullExpressionValue(fatLfnDirectory2, "root.addDirectory(\"EFI\").directory.addDirectory(\"BOOT\").directory");
        FatLfnDirectory kernelDir = fatLfnDirectory2;
        FatLfnDirectoryEntry fatLfnDirectoryEntry = kernelDir.addFile(BOOTX64_EFI);
        Intrinsics.checkNotNullExpressionValue(fatLfnDirectoryEntry, "kernelDir.addFile(BOOTX64_EFI)");
        FatLfnDirectoryEntry kernelEntry = fatLfnDirectoryEntry;
        kernelEntry.getFile().write(0L, ByteBuffer.wrap(KERNEL_BYTES));
        FatLfnDirectoryEntry fatLfnDirectoryEntry2 = kernelDir.addFile("LICENSE");
        Intrinsics.checkNotNullExpressionValue(fatLfnDirectoryEntry2, "kernelDir.addFile(\"LICENSE\")");
        FatLfnDirectoryEntry kernelLicenseEntry = fatLfnDirectoryEntry2;
        kernelLicenseEntry.getFile().write(0L, ByteBuffer.wrap(KERNEL_LICENSE_BYTES));
        FatLfnDirectoryEntry fatLfnDirectoryEntry3 = root.addDirectory("boot").getDirectory().addDirectory("grub").getDirectory().addFile("menu.lst");
        Intrinsics.checkNotNullExpressionValue(fatLfnDirectoryEntry3, "root.addDirectory(\"boot\").directory.addDirectory(\"grub\").directory.addFile(\"menu.lst\")");
        FatLfnDirectoryEntry grubEntry = fatLfnDirectoryEntry3;
        grubEntry.getFile().write(0L, ByteBuffer.wrap(MENU_LST_BYTES));
        fatLfnDirectoryEntry3 = root.addFile(INITRD_GZ).getFile();
        Intrinsics.checkNotNullExpressionValue(fatLfnDirectoryEntry3, "root.addFile(INITRD_GZ).file");
        BootableDiskImageBuilder.Companion.copyNoClose(ramDisk, (FatFile)fatLfnDirectoryEntry3);
        fileSystem.close();
    }

    private final void patchSyslinux(byte[] virtualDiskBytes) {
        virtualDiskBytes[1] = 88;
        System.arraycopy(BS_BYTES, 0, virtualDiskBytes, 90, BS_BYTES.length);
        int ldlinuxBase = this.findLdlinux(virtualDiskBytes);
        int ldlinuxBaseSector = ldlinuxBase / 512;
        virtualDiskBytes[282] = (byte)(ldlinuxBaseSector & 0xFF);
        virtualDiskBytes[283] = (byte)(ldlinuxBaseSector >> 8);
        virtualDiskBytes[ldlinuxBase + 40] = 0;
        virtualDiskBytes[ldlinuxBase + 40 + 1] = 0;
        virtualDiskBytes[ldlinuxBase + 40 + 2] = 0;
        virtualDiskBytes[ldlinuxBase + 40 + 3] = 0;
        virtualDiskBytes[ldlinuxBase + 482] = (byte)(ldlinuxBaseSector + 1 & 0xFF);
        virtualDiskBytes[ldlinuxBase + 483] = (byte)(ldlinuxBaseSector + 1 >> 8);
        virtualDiskBytes[ldlinuxBase + 14176] = (byte)(ldlinuxBaseSector + 62 & 0xFF);
        virtualDiskBytes[ldlinuxBase + 14177] = (byte)(ldlinuxBaseSector + 62 >> 8);
        virtualDiskBytes[ldlinuxBase + 14184] = (byte)(ldlinuxBaseSector + 63 & 0xFF);
        virtualDiskBytes[ldlinuxBase + 14185] = (byte)(ldlinuxBaseSector + 63 >> 8);
        byte[] byArray = virtualDiskBytes;
        int n = ldlinuxBase + LDLINUX_BYTES.length;
        boolean bl = false;
        byte[] ldlinuxPatchedBytes = ArraysKt.copyOfRange(byArray, ldlinuxBase, n);
        long ldlinuxChecksum = Companion.calculateChecksum$boxfuse_base_bootable(ldlinuxPatchedBytes);
        virtualDiskBytes[ldlinuxBase + 40] = (byte)(ldlinuxChecksum & 0xFFL);
        virtualDiskBytes[ldlinuxBase + 40 + 1] = (byte)(ldlinuxChecksum >> 8 & 0xFFL);
        virtualDiskBytes[ldlinuxBase + 40 + 2] = (byte)(ldlinuxChecksum >> 16 & 0xFFL);
        virtualDiskBytes[ldlinuxBase + 40 + 3] = (byte)(ldlinuxChecksum >> 24 & 0xFFL);
    }

    private final int findLdlinux(byte[] virtualDiskBytes) {
        Object object = LDLINUX_BYTES;
        int n = 28;
        int n2 = 0;
        byte[] byArray = Arrays.copyOf((byte[])object, n);
        Intrinsics.checkNotNullExpressionValue(byArray, "java.util.Arrays.copyOf(this, newSize)");
        byte[] target = byArray;
        object = RangesKt.step(RangesKt.until(512, virtualDiskBytes.length), 512);
        n = ((IntProgression)object).getFirst();
        n2 = ((IntProgression)object).getLast();
        int n3 = ((IntProgression)object).getStep();
        if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
            int i2;
            do {
                i2 = n;
                n += n3;
                byte[] byArray2 = target;
                byte[] byArray3 = virtualDiskBytes;
                int n4 = i2 + target.length;
                boolean bl = false;
                byArray3 = ArraysKt.copyOfRange(byArray3, i2, n4);
                n4 = 0;
                if (!Arrays.equals(byArray2, byArray3)) continue;
                return i2;
            } while (i2 != n2);
        }
        throw new BoxfuseBugException("Unable to install boot loader");
    }

    private final long toDiskSize(long syslinuxCfgSize, long ramDiskSize) {
        return Companion.computeVirtualDiskSizeInBytes$boxfuse_base_bootable((long)LDLINUX_BYTES.length + syslinuxCfgSize + (long)SYSLINUX_TXT_BYTES.length + (long)KERNEL_BYTES.length + (long)KERNEL_LICENSE_BYTES.length + (long)MENU_LST_BYTES.length + ramDiskSize);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0019J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/boxfuse/base/bootable/BootableDiskImageBuilder$Companion;", "", "()V", "BOOTX64_EFI", "", "BS_BYTES", "", "CHECKSUM_OFFSET", "", "INITRD_GZ", "KERNEL_BYTES", "KERNEL_LICENSE_BYTES", "LDLINUX_BYTES", "getLDLINUX_BYTES$boxfuse_base_bootable", "()[B", "LDLINUX_MAGIC", "MENU_LST_BYTES", "SECTOR_SIZE", "SYSLINUX_TXT_BYTES", "calculateChecksum", "ldlinuxPatchedBytes", "calculateChecksum$boxfuse_base_bootable", "computeVirtualDiskSizeInBytes", "", "stagingDirSizeInBytes", "computeVirtualDiskSizeInBytes$boxfuse_base_bootable", "copyNoClose", "in", "Ljava/io/InputStream;", "out", "Lde/waldheinz/fs/fat/FatFile;", "boxfuse-base-bootable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getLDLINUX_BYTES$boxfuse_base_bootable() {
            return LDLINUX_BYTES;
        }

        private final int copyNoClose(InputStream in, FatFile out) {
            int byteCount = 0;
            byte[] buffer = new byte[0x400000];
            int bytesRead = 0;
            while (true) {
                int n = in.read(buffer);
                boolean bl = false;
                boolean bl2 = false;
                int it = n;
                boolean bl3 = false;
                bytesRead = it;
                if (n == -1) break;
                out.write((long)byteCount, ByteBuffer.wrap(buffer, 0, bytesRead));
                byteCount += bytesRead;
            }
            out.flush();
            return byteCount;
        }

        public final int calculateChecksum$boxfuse_base_bootable(@NotNull byte[] ldlinuxPatchedBytes) {
            Intrinsics.checkNotNullParameter(ldlinuxPatchedBytes, "ldlinuxPatchedBytes");
            int checksum = 1051853566;
            IntProgression intProgression = RangesKt.step(RangesKt.until(0, 31744), 4);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
                int i2;
                do {
                    i2 = n;
                    n += n3;
                    int n4 = ldlinuxPatchedBytes[i2];
                    int n5 = 0;
                    n4 = UByte.constructor-impl((byte)n4);
                    n5 = -1;
                    int n6 = 0;
                    int n7 = n4;
                    int n8 = n5;
                    int n9 = 0;
                    n4 = UByte.constructor-impl((byte)(n7 & n8));
                    n5 = 0;
                    n4 = UInt.constructor-impl(n4 & 0xFF);
                    n5 = ldlinuxPatchedBytes[i2 + 1];
                    n6 = 0;
                    n5 = UByte.constructor-impl((byte)n5);
                    n6 = -1;
                    n7 = 0;
                    n8 = n5;
                    n9 = n6;
                    boolean bl = false;
                    n5 = UByte.constructor-impl((byte)(n8 & n9));
                    n6 = 0;
                    n5 = UInt.constructor-impl(n5 & 0xFF);
                    n6 = 8;
                    n7 = 0;
                    n5 = UInt.constructor-impl(n5 << n6);
                    n6 = 0;
                    n4 = UInt.constructor-impl(n4 | n5);
                    n5 = ldlinuxPatchedBytes[i2 + 2];
                    n6 = 0;
                    n5 = UByte.constructor-impl((byte)n5);
                    n6 = -1;
                    n7 = 0;
                    n8 = n5;
                    n9 = n6;
                    bl = false;
                    n5 = UByte.constructor-impl((byte)(n8 & n9));
                    n6 = 0;
                    n5 = UInt.constructor-impl(n5 & 0xFF);
                    n6 = 16;
                    n7 = 0;
                    n5 = UInt.constructor-impl(n5 << n6);
                    n6 = 0;
                    n4 = UInt.constructor-impl(n4 | n5);
                    n5 = ldlinuxPatchedBytes[i2 + 3];
                    n6 = 0;
                    n5 = UByte.constructor-impl((byte)n5);
                    n6 = -1;
                    n7 = 0;
                    n8 = n5;
                    n9 = n6;
                    bl = false;
                    n5 = UByte.constructor-impl((byte)(n8 & n9));
                    n6 = 0;
                    n5 = UInt.constructor-impl(n5 & 0xFF);
                    n6 = 24;
                    n7 = 0;
                    n5 = UInt.constructor-impl(n5 << n6);
                    n6 = 0;
                    n4 = UInt.constructor-impl(n4 | n5);
                    n5 = 0;
                    int dword = n4;
                    checksum -= dword;
                } while (i2 != n2);
            }
            return checksum;
        }

        public final long computeVirtualDiskSizeInBytes$boxfuse_base_bootable(long stagingDirSizeInBytes) {
            double d = (double)stagingDirSizeInBytes / 1048576.0;
            boolean bl = false;
            long virtualDiskSizeInMB = (long)Math.ceil(d);
            return (virtualDiskSizeInMB += (long)2) * (long)0x100000;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

