/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.fsimage.tar;

import com.boxfuse.base.fsimage.FsFile;
import com.boxfuse.base.fsimage.FsFileMode;
import com.boxfuse.base.fsimage.FsFileType;
import com.boxfuse.base.fsimage.FsImage;
import com.boxfuse.base.fsimage.FsPath;
import com.boxfuse.base.fsimage.tar.TarFsFile;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J0\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J0\u0010\u0012\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0013\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0014\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J0\u0010\u0015\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u001a\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u001b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u001f\u001a\u00020\u0002H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/boxfuse/base/fsimage/tar/ReadOnlyTarFsImage;", "Lcom/boxfuse/base/fsimage/FsImage;", "Lcom/boxfuse/base/fsimage/tar/TarFsFile;", "byteArray", "", "([B)V", "files", "", "Lcom/boxfuse/base/fsimage/FsPath;", "createBlockDevice", "directory", "name", "", "major", "", "minor", "mode", "Lcom/boxfuse/base/fsimage/FsFileMode;", "createCharacterDevice", "createDirectory", "createFifo", "createRegularFile", "size", "", "data", "Ljava/io/InputStream;", "createSocket", "createSymbolicLink", "destination", "getFile", "path", "getRootDirectory", "listDirectory", "", "boxfuse-base-fsimage"})
public final class ReadOnlyTarFsImage
implements FsImage<TarFsFile> {
    @NotNull
    private final Map<FsPath, TarFsFile> files;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadOnlyTarFsImage(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter(byteArray, "byteArray");
        boolean bl = false;
        this.files = new LinkedHashMap();
        Object object = byteArray;
        boolean bl2 = false;
        object = new TarArchiveInputStream((InputStream)new ByteArrayInputStream((byte[])object), StandardCharsets.UTF_8.name());
        bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            TarArchiveInputStream tar = (TarArchiveInputStream)object;
            boolean bl4 = false;
            TarArchiveEntry entry = tar.getNextTarEntry();
            while (entry != null) {
                Object object2 = entry;
                TarFsFile tarFsFile = new TarFsFile((TarArchiveEntry)object2, entry.isFile() && !entry.isSymbolicLink() ? ByteStreamsKt.readBytes(tar) : null);
                object2 = this.files;
                FsPath fsPath = tarFsFile.getPath();
                boolean bl5 = false;
                object2.put(fsPath, tarFsFile);
                entry = tar.getNextTarEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
    }

    @Override
    @NotNull
    public TarFsFile getRootDirectory() {
        return new TarFsFile(new FsPath("/"), FsFileType.DIRECTORY, FsFileMode.Companion.getRX(), 0L, null, null, null, null);
    }

    @Override
    @NotNull
    public TarFsFile getFile(@NotNull FsPath path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Map<FsPath, TarFsFile> map = this.files;
        boolean bl = false;
        TarFsFile tarFsFile = map.get(path);
        if (tarFsFile == null) {
            boolean bl2 = false;
            throw new IllegalArgumentException(Intrinsics.stringPlus("Unknown file: ", path));
        }
        return tarFsFile;
    }

    @Override
    @NotNull
    public TarFsFile getFile(@NotNull TarFsFile directory, @NotNull String name) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(name, "name");
        boolean bl = directory.getType() == FsFileType.DIRECTORY;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = directory.getPath() + " is not a directory";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.getFile(directory.getPath().getChild(name));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<TarFsFile> listDirectory(@NotNull TarFsFile directory) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(directory, "directory");
        boolean bl = directory.getType() == FsFileType.DIRECTORY;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = directory.getPath() + " is not a directory";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Map<FsPath, TarFsFile> $this$filter$iv = this.files;
        boolean $i$f$filter = false;
        Map<FsPath, TarFsFile> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var7_11 = $this$filterTo$iv$iv;
        boolean bl5 = false;
        Iterator iterator2 = var7_11.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl6 = false;
            if (!(!Intrinsics.areEqual(it.getKey(), directory.getPath()) && Intrinsics.areEqual(((FsPath)it.getKey()).getParent(), directory.getPath()))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList(destination$iv$iv.values());
    }

    @Override
    @NotNull
    public TarFsFile createRegularFile(@NotNull TarFsFile directory, @NotNull String name, long size, @NotNull InputStream data, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(mode, "mode");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public TarFsFile createDirectory(@NotNull TarFsFile directory, @NotNull String name, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(mode, "mode");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public TarFsFile createSymbolicLink(@NotNull TarFsFile directory, @NotNull String name, @NotNull String destination, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(mode, "mode");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public TarFsFile createBlockDevice(@NotNull TarFsFile directory, @NotNull String name, byte major, byte minor, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(mode, "mode");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public TarFsFile createCharacterDevice(@NotNull TarFsFile directory, @NotNull String name, byte major, byte minor, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(mode, "mode");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public TarFsFile createFifo(@NotNull TarFsFile directory, @NotNull String name, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(mode, "mode");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public TarFsFile createSocket(@NotNull TarFsFile directory, @NotNull String name, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(mode, "mode");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    public <T extends FsFile> void copyTo(@NotNull FsImage<T> target, @NotNull FsPath path) {
        FsImage.DefaultImpls.copyTo(this, target, path);
    }

    @Override
    @NotNull
    public TarFsFile createFile(@NotNull FsFile file) {
        return FsImage.DefaultImpls.createFile(this, file);
    }

    @Override
    @NotNull
    public TarFsFile createFile(@NotNull FsPath prefix, @NotNull FsFile file) {
        return (TarFsFile)((Object)FsImage.DefaultImpls.createFile(this, prefix, file));
    }

    @Override
    @NotNull
    public TarFsFile createRegularFile(@NotNull TarFsFile directory, @NotNull String name, @NotNull byte[] data, @NotNull FsFileMode mode) {
        return (TarFsFile)FsImage.DefaultImpls.createRegularFile(this, (FsFile)directory, name, data, mode);
    }

    @Override
    @NotNull
    public TarFsFile createRegularFile(@NotNull TarFsFile directory, @NotNull String name, @NotNull String data, @NotNull FsFileMode mode) {
        return (TarFsFile)FsImage.DefaultImpls.createRegularFile(this, (FsFile)directory, name, data, mode);
    }

    @Override
    @NotNull
    public TarFsFile createRegularFile(@NotNull FsFile regularFile, @NotNull InputStream data) {
        return FsImage.DefaultImpls.createRegularFile(this, regularFile, data);
    }

    @Override
    @NotNull
    public TarFsFile createSymbolicLink(@NotNull TarFsFile directory, @NotNull String name, @NotNull TarFsFile destination, @NotNull FsFileMode mode) {
        return (TarFsFile)FsImage.DefaultImpls.createSymbolicLink(this, (FsFile)directory, name, (FsFile)destination, mode);
    }

    @Override
    @NotNull
    public List<TarFsFile> listAllFiles() {
        return FsImage.DefaultImpls.listAllFiles(this);
    }
}

