/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.fsimage.tar;

import com.boxfuse.base.fsimage.FsFile;
import com.boxfuse.base.fsimage.FsFileMode;
import com.boxfuse.base.fsimage.FsFileType;
import com.boxfuse.base.fsimage.FsImage;
import com.boxfuse.base.fsimage.FsPath;
import com.boxfuse.base.fsimage.tar.TarFsFile;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 -2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001-B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J0\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016Jg\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010$J0\u0010%\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010&\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010'\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u000bH\u0016J\u0018\u0010(\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010*\u001a\u00020\u0002H\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020,2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/boxfuse/base/fsimage/tar/WriteOnlyTarFsImage;", "Lcom/boxfuse/base/fsimage/FsImage;", "Lcom/boxfuse/base/fsimage/tar/TarFsFile;", "Ljava/lang/AutoCloseable;", "outputStream", "Ljava/io/OutputStream;", "createTime", "Ljava/time/Instant;", "(Ljava/io/OutputStream;Ljava/time/Instant;)V", "files", "", "Lcom/boxfuse/base/fsimage/FsPath;", "tar", "Lorg/apache/commons/compress/archivers/tar/TarArchiveOutputStream;", "close", "", "createBlockDevice", "directory", "name", "", "major", "", "minor", "mode", "Lcom/boxfuse/base/fsimage/FsFileMode;", "createCharacterDevice", "createDirectory", "createFifo", "createFile", "type", "Lcom/boxfuse/base/fsimage/FsFileType;", "size", "", "data", "Ljava/io/InputStream;", "destination", "(Lcom/boxfuse/base/fsimage/tar/TarFsFile;Ljava/lang/String;Lcom/boxfuse/base/fsimage/FsFileType;Lcom/boxfuse/base/fsimage/FsFileMode;JLjava/io/InputStream;Ljava/lang/String;Ljava/lang/Byte;Ljava/lang/Byte;)Lcom/boxfuse/base/fsimage/tar/TarFsFile;", "createRegularFile", "createSocket", "createSymbolicLink", "getFile", "path", "getRootDirectory", "listDirectory", "", "Companion", "boxfuse-base-fsimage"})
public final class WriteOnlyTarFsImage
implements FsImage<TarFsFile>,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Instant createTime;
    @NotNull
    private final TarArchiveOutputStream tar;
    @NotNull
    private final Map<FsPath, TarFsFile> files;
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteOnlyTarFsImage.class);

    public WriteOnlyTarFsImage(@NotNull OutputStream outputStream, @NotNull Instant createTime) {
        Intrinsics.checkNotNullParameter(outputStream, "outputStream");
        Intrinsics.checkNotNullParameter(createTime, "createTime");
        this.createTime = createTime;
        this.tar = new TarArchiveOutputStream(outputStream, StandardCharsets.UTF_8.name());
        boolean bl = false;
        this.files = new LinkedHashMap();
    }

    public /* synthetic */ WriteOnlyTarFsImage(OutputStream outputStream, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue(instant2, "now()");
            instant = instant2;
        }
        this(outputStream, instant);
    }

    @Override
    @NotNull
    public TarFsFile getRootDirectory() {
        return new TarFsFile(FsPath.Companion.getROOT(), FsFileType.DIRECTORY, FsFileMode.Companion.getRX(), 0L, null, null, null, null);
    }

    @Override
    @NotNull
    public TarFsFile getFile(@NotNull FsPath path) {
        Intrinsics.checkNotNullParameter(path, "path");
        if (Intrinsics.areEqual(path, FsPath.Companion.getROOT())) {
            return this.getRootDirectory();
        }
        Map<FsPath, TarFsFile> map = this.files;
        boolean bl = false;
        TarFsFile tarFsFile = map.get(path);
        if (tarFsFile == null) {
            boolean bl2 = false;
            throw new IllegalArgumentException(Intrinsics.stringPlus("Unknown file: ", path));
        }
        return tarFsFile;
    }

    @Override
    @NotNull
    public TarFsFile getFile(@NotNull TarFsFile directory, @NotNull String name) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(name, "name");
        boolean bl = directory.getType() == FsFileType.DIRECTORY;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = directory.getPath() + " is not a directory";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.getFile(directory.getPath().getChild(name));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<TarFsFile> listDirectory(@NotNull TarFsFile directory) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(directory, "directory");
        boolean bl = directory.getType() == FsFileType.DIRECTORY;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = directory.getPath() + " is not a directory";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Map<FsPath, TarFsFile> $this$filter$iv = this.files;
        boolean $i$f$filter = false;
        Map<FsPath, TarFsFile> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var7_11 = $this$filterTo$iv$iv;
        boolean bl5 = false;
        Iterator iterator2 = var7_11.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl6 = false;
            if (!Intrinsics.areEqual(((FsPath)it.getKey()).getParent(), directory.getPath())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList(destination$iv$iv.values());
    }

    @Override
    @NotNull
    public TarFsFile createRegularFile(@NotNull TarFsFile directory, @NotNull String name, long size, @NotNull InputStream data, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(mode, "mode");
        boolean bl = size >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return WriteOnlyTarFsImage.createFile$default(this, directory, name, FsFileType.REGULAR_FILE, mode, size, data, null, null, null, 448, null);
    }

    @Override
    @NotNull
    public TarFsFile createDirectory(@NotNull TarFsFile directory, @NotNull String name, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(mode, "mode");
        return WriteOnlyTarFsImage.createFile$default(this, directory, name, FsFileType.DIRECTORY, mode, 0L, null, null, null, null, 496, null);
    }

    @Override
    @NotNull
    public TarFsFile createSymbolicLink(@NotNull TarFsFile directory, @NotNull String name, @NotNull String destination, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(mode, "mode");
        CharSequence charSequence = destination;
        boolean bl = false;
        boolean bl2 = !StringsKt.isBlank(charSequence);
        bl = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return WriteOnlyTarFsImage.createFile$default(this, directory, name, FsFileType.SYMBOLIC_LINK, mode, 0L, null, destination, null, null, 416, null);
    }

    @Override
    @NotNull
    public TarFsFile createBlockDevice(@NotNull TarFsFile directory, @NotNull String name, byte major, byte minor, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(mode, "mode");
        return WriteOnlyTarFsImage.createFile$default(this, directory, name, FsFileType.BLOCK_DEVICE, mode, 0L, null, null, major, minor, 112, null);
    }

    @Override
    @NotNull
    public TarFsFile createCharacterDevice(@NotNull TarFsFile directory, @NotNull String name, byte major, byte minor, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(mode, "mode");
        return WriteOnlyTarFsImage.createFile$default(this, directory, name, FsFileType.CHARACTER_DEVICE, mode, 0L, null, null, major, minor, 112, null);
    }

    @Override
    @NotNull
    public TarFsFile createFifo(@NotNull TarFsFile directory, @NotNull String name, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(mode, "mode");
        return WriteOnlyTarFsImage.createFile$default(this, directory, name, FsFileType.FIFO, mode, 0L, null, null, null, null, 496, null);
    }

    @Override
    @NotNull
    public TarFsFile createSocket(@NotNull TarFsFile directory, @NotNull String name, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(mode, "mode");
        return WriteOnlyTarFsImage.createFile$default(this, directory, name, FsFileType.SOCKET, mode, 0L, null, null, null, null, 496, null);
    }

    @Override
    public void close() {
        this.tar.close();
    }

    private final TarFsFile createFile(TarFsFile directory, String name, FsFileType type, FsFileMode mode, long size, InputStream data, String destination, Byte major, Byte minor) {
        byte by;
        boolean bl = directory.getType() == FsFileType.DIRECTORY;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = directory.getPath() + " is not a directory";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        FsPath path = directory.getPath().getChild(name);
        String string = Companion.toTarPath$boxfuse_base_fsimage(path);
        FsFileType fsFileType = type;
        int n = WhenMappings.$EnumSwitchMapping$0[fsFileType.ordinal()];
        switch (n) {
            case 1: {
                by = 48;
                break;
            }
            case 2: {
                by = 53;
                break;
            }
            case 3: {
                by = 50;
                break;
            }
            case 4: {
                by = 52;
                break;
            }
            case 5: {
                by = 51;
                break;
            }
            case 6: {
                by = 54;
                break;
            }
            case 7: {
                LOGGER.warn("Ignoring " + path + " as sockets aren't supported by tar");
                by = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        TarArchiveEntry entry = new TarArchiveEntry(string, by);
        entry.setMode(TarFsFile.Companion.toTarMode$boxfuse_base_fsimage(mode));
        entry.setSize(size);
        entry.setModTime(new Date(this.createTime.toEpochMilli()));
        if (destination != null) {
            entry.setLinkName(destination);
        }
        if (major != null) {
            entry.setDevMajor(major.byteValue());
        }
        if (minor != null) {
            entry.setDevMinor(minor.byteValue());
        }
        this.tar.putArchiveEntry(entry);
        if (data != null) {
            long consumed = 0L;
            byte[] copyBuffer = new byte[4096];
            int read = 0;
            do {
                if ((read = data.read(copyBuffer)) < 0) continue;
                this.tar.write(copyBuffer, 0, read);
                consumed += (long)read;
            } while (read >= 0 && consumed < size);
        }
        this.tar.closeArchiveEntry();
        TarFsFile file = new TarFsFile(path, type, mode, size, destination, major, minor, null);
        Map<FsPath, TarFsFile> map = this.files;
        boolean bl5 = false;
        map.put(path, file);
        return file;
    }

    static /* synthetic */ TarFsFile createFile$default(WriteOnlyTarFsImage writeOnlyTarFsImage, TarFsFile tarFsFile, String string, FsFileType fsFileType, FsFileMode fsFileMode, long l, InputStream inputStream, String string2, Byte by, Byte by2, int n, Object object) {
        if ((n & 0x10) != 0) {
            l = 0L;
        }
        if ((n & 0x20) != 0) {
            inputStream = null;
        }
        if ((n & 0x40) != 0) {
            string2 = null;
        }
        if ((n & 0x80) != 0) {
            by = null;
        }
        if ((n & 0x100) != 0) {
            by2 = null;
        }
        return writeOnlyTarFsImage.createFile(tarFsFile, string, fsFileType, fsFileMode, l, inputStream, string2, by, by2);
    }

    @Override
    public <T extends FsFile> void copyTo(@NotNull FsImage<T> target, @NotNull FsPath path) {
        FsImage.DefaultImpls.copyTo(this, target, path);
    }

    @Override
    @NotNull
    public TarFsFile createFile(@NotNull FsFile file) {
        return FsImage.DefaultImpls.createFile(this, file);
    }

    @Override
    @NotNull
    public TarFsFile createFile(@NotNull FsPath prefix, @NotNull FsFile file) {
        return (TarFsFile)((Object)FsImage.DefaultImpls.createFile(this, prefix, file));
    }

    @Override
    @NotNull
    public TarFsFile createRegularFile(@NotNull TarFsFile directory, @NotNull String name, @NotNull byte[] data, @NotNull FsFileMode mode) {
        return (TarFsFile)FsImage.DefaultImpls.createRegularFile(this, (FsFile)directory, name, data, mode);
    }

    @Override
    @NotNull
    public TarFsFile createRegularFile(@NotNull TarFsFile directory, @NotNull String name, @NotNull String data, @NotNull FsFileMode mode) {
        return (TarFsFile)FsImage.DefaultImpls.createRegularFile(this, (FsFile)directory, name, data, mode);
    }

    @Override
    @NotNull
    public TarFsFile createRegularFile(@NotNull FsFile regularFile, @NotNull InputStream data) {
        return FsImage.DefaultImpls.createRegularFile(this, regularFile, data);
    }

    @Override
    @NotNull
    public TarFsFile createSymbolicLink(@NotNull TarFsFile directory, @NotNull String name, @NotNull TarFsFile destination, @NotNull FsFileMode mode) {
        return (TarFsFile)FsImage.DefaultImpls.createSymbolicLink(this, (FsFile)directory, name, (FsFile)destination, mode);
    }

    @Override
    @NotNull
    public List<TarFsFile> listAllFiles() {
        return FsImage.DefaultImpls.listAllFiles(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/boxfuse/base/fsimage/tar/WriteOnlyTarFsImage$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "toTarPath", "", "path", "Lcom/boxfuse/base/fsimage/FsPath;", "toTarPath$boxfuse_base_fsimage", "boxfuse-base-fsimage"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String toTarPath$boxfuse_base_fsimage(@NotNull FsPath path) {
            Intrinsics.checkNotNullParameter(path, "path");
            String string = path.getAbsolutePath();
            int n = 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).substring(startIndex)");
            return string3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FsFileType.values().length];
            nArray[FsFileType.REGULAR_FILE.ordinal()] = 1;
            nArray[FsFileType.DIRECTORY.ordinal()] = 2;
            nArray[FsFileType.SYMBOLIC_LINK.ordinal()] = 3;
            nArray[FsFileType.BLOCK_DEVICE.ordinal()] = 4;
            nArray[FsFileType.CHARACTER_DEVICE.ordinal()] = 5;
            nArray[FsFileType.FIFO.ordinal()] = 6;
            nArray[FsFileType.SOCKET.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

