/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.port;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.port.Protocol;
import com.boxfuse.base.port.Restriction;
import com.boxfuse.base.types.IpAddress;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.OSUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001%B#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0000H\u0096\u0002J\u0014\u0010\u0017\u001a\u00020\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u0019J\u0013\u0010\u001a\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"J\b\u0010#\u001a\u00020 H\u0007J\b\u0010$\u001a\u00020 H\u0016R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\r\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006&"}, d2={"Lcom/boxfuse/base/port/Port;", "", "number", "", "protocol", "Lcom/boxfuse/base/port/Protocol;", "restriction", "Lcom/boxfuse/base/port/Restriction;", "(ILcom/boxfuse/base/port/Protocol;Lcom/boxfuse/base/port/Restriction;)V", "isAvailable", "", "()Z", "isAvailableMac", "isAvailableUdp", "isAvailableWindowsLinux", "getNumber", "()I", "getProtocol", "()Lcom/boxfuse/base/port/Protocol;", "getRestriction", "()Lcom/boxfuse/base/port/Restriction;", "compareTo", "other", "conflictsWith", "assignedPorts", "", "equals", "", "hashCode", "listen", "Ljava/io/Closeable;", "toPrettyString", "", "ownIp", "Lcom/boxfuse/base/types/IpAddress;", "toSpec", "toString", "Companion", "boxfuse-base-core"})
public final class Port
implements Comparable<Port> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int number;
    @NotNull
    private final Protocol protocol;
    @NotNull
    private final Restriction restriction;
    private static final Logger LOGGER = LoggerFactory.getLogger(Port.class);
    @JvmField
    @NotNull
    public static final Port HTTP = new Port(80, Protocol.HTTP, null);
    @JvmField
    @NotNull
    public static final Port HTTPS = new Port(443, Protocol.HTTPS, null);
    @NotNull
    private static final Port[] namedPorts;

    private Port(int number, Protocol protocol, Restriction restriction) {
        if (number < 0 || number > 65535) {
            throw new BoxfuseException(Intrinsics.stringPlus("Invalid port (should be between 0 and 65535): ", number));
        }
        this.number = number;
        if (protocol == null) {
            int n = number;
            switch (n) {
                case 80: {
                    this.protocol = Protocol.HTTP;
                    break;
                }
                case 443: {
                    this.protocol = Protocol.HTTPS;
                    break;
                }
                default: {
                    this.protocol = Protocol.TCP;
                    break;
                }
            }
        } else {
            this.protocol = protocol;
        }
        if (restriction == null) {
            Restriction restriction2 = Restriction.UNRESTRICTED;
            Intrinsics.checkNotNullExpressionValue(restriction2, "UNRESTRICTED");
            this.restriction = restriction2;
        } else {
            this.restriction = restriction;
        }
    }

    public final int getNumber() {
        return this.number;
    }

    @NotNull
    public final Protocol getProtocol() {
        return this.protocol;
    }

    @NotNull
    public final Restriction getRestriction() {
        return this.restriction;
    }

    public final boolean conflictsWith(@NotNull Collection<Port> assignedPorts) {
        Intrinsics.checkNotNullParameter(assignedPorts, "assignedPorts");
        for (Port assignedPort : assignedPorts) {
            if (this.number != assignedPort.number || this.protocol.isTcp() != assignedPort.protocol.isTcp()) continue;
            return true;
        }
        return false;
    }

    public final boolean isAvailable() {
        if (!this.protocol.isTcp()) {
            return this.isAvailableUdp();
        }
        return OSUtils.INSTANCE.runningOnMac() ? this.isAvailableMac() : this.isAvailableWindowsLinux();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isAvailableWindowsLinux() {
        boolean bl;
        Closeable serverSocket = null;
        try {
            serverSocket = this.listen();
            bl = true;
        }
        catch (IOException e) {
            bl = false;
        }
        finally {
            IOUtils.close(serverSocket);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isAvailableMac() {
        boolean bl;
        Closeable socket = null;
        try {
            socket = new Socket("localhost", this.number);
            bl = false;
        }
        catch (IOException e) {
            try {
                bl = true;
            }
            catch (Throwable throwable) {
                IOUtils.close(socket);
                throw throwable;
            }
            IOUtils.close(socket);
        }
        IOUtils.close(socket);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isAvailableUdp() {
        boolean bl;
        Closeable socket = null;
        try {
            socket = new DatagramSocket(this.number, InetAddress.getLocalHost());
            bl = true;
        }
        catch (IOException e) {
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtils.close(socket);
                throw throwable;
            }
            IOUtils.close(socket);
        }
        IOUtils.close(socket);
        return bl;
    }

    @NotNull
    public final Closeable listen() throws IOException {
        return this.protocol.isTcp() ? (Closeable)new ServerSocket(this.number, 100) : (Closeable)new DatagramSocket(this.number, InetAddress.getLocalHost());
    }

    @NotNull
    public String toString() {
        return "" + this.number + (this.protocol.isTcp() ? "" : "/udp") + (Intrinsics.areEqual(Restriction.UNRESTRICTED, this.restriction) ? "" : Intrinsics.stringPlus(":", this.restriction));
    }

    @NotNull
    public final String toPrettyString(@Nullable IpAddress ownIp) {
        return "" + this.number + (this.protocol.isTcp() ? "" : "/udp") + (Intrinsics.areEqual(Restriction.UNRESTRICTED, this.restriction) ? "" : " (restricted to " + this.restriction.toAdjustedString(ownIp) + ')');
    }

    @JsonValue
    @NotNull
    public final String toSpec() {
        return "" + this.number + '/' + this.protocol.getName() + (Intrinsics.areEqual(Restriction.UNRESTRICTED, this.restriction) ? "" : Intrinsics.stringPlus(":", this.restriction));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        Port port = (Port)other;
        return this.number == port.number && this.protocol == port.protocol && Intrinsics.areEqual(this.restriction, port.restriction);
    }

    public int hashCode() {
        int result = this.number;
        result = 31 * result + this.protocol.hashCode();
        result = 31 * result + this.restriction.hashCode();
        return result;
    }

    @Override
    public int compareTo(@NotNull Port other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.number - other.number;
    }

    @JsonCreator
    @JvmStatic
    @Nullable
    public static final Port of(@Nullable String portSpec) {
        return Companion.of(portSpec);
    }

    @JvmStatic
    @Nullable
    public static final Port of(@Nullable String portSpec, @Nullable Protocol defaultProtocol) {
        return Companion.of(portSpec, defaultProtocol);
    }

    @JvmStatic
    @NotNull
    public static final Port getUnrestrictedTcpPort(int number) {
        return Companion.getUnrestrictedTcpPort(number);
    }

    @JvmStatic
    @NotNull
    public static final Port findFreePort(int desiredPortNumber, @NotNull Protocol desiredProtocol, @NotNull Collection<Port> assignedPorts) {
        return Companion.findFreePort(desiredPortNumber, desiredProtocol, assignedPorts);
    }

    @JvmStatic
    @NotNull
    public static final Port of(int number, @Nullable Protocol protocol, @Nullable Restriction restriction) {
        return Companion.of(number, protocol, restriction);
    }

    public /* synthetic */ Port(int number, Protocol protocol, Restriction restriction, DefaultConstructorMarker $constructor_marker) {
        this(number, protocol, restriction);
    }

    static {
        Port[] portArray = new Port[]{HTTP, HTTPS};
        namedPorts = portArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000eH\u0007J$\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0010H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/boxfuse/base/port/Port$Companion;", "", "()V", "HTTP", "Lcom/boxfuse/base/port/Port;", "HTTPS", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "namedPorts", "", "[Lcom/boxfuse/base/port/Port;", "findFreePort", "desiredPortNumber", "", "desiredProtocol", "Lcom/boxfuse/base/port/Protocol;", "assignedPorts", "", "getUnrestrictedTcpPort", "number", "of", "protocol", "restriction", "Lcom/boxfuse/base/port/Restriction;", "portSpec", "", "defaultProtocol", "boxfuse-base-core"})
    public static final class Companion {
        private Companion() {
        }

        @JsonCreator
        @JvmStatic
        @Nullable
        public final Port of(@Nullable String portSpec) {
            return this.of(portSpec, null);
        }

        @JvmStatic
        @Nullable
        public final Port of(@Nullable String portSpec, @Nullable Protocol defaultProtocol) {
            int n;
            String nameOrNumber;
            String string;
            int n2;
            Protocol protocol;
            Protocol protocol2;
            String nameOrNumberPart;
            String string2;
            int n3;
            int n4;
            Restriction restriction;
            Restriction restriction2;
            int n5;
            if (portSpec == null) {
                return null;
            }
            if (StringsKt.contains$default((CharSequence)portSpec, ":", false, 2, null)) {
                String string3 = portSpec;
                int n6 = StringsKt.indexOf$default((CharSequence)portSpec, ":", 0, false, 6, null) + 1;
                n5 = 0;
                String string4 = string3.substring(n6);
                Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).substring(startIndex)");
                restriction2 = Restriction.of(string4);
            } else {
                restriction2 = restriction = null;
            }
            if (StringsKt.contains$default((CharSequence)portSpec, ":", false, 2, null)) {
                String string5 = portSpec;
                n5 = 0;
                n4 = StringsKt.indexOf$default((CharSequence)portSpec, ":", 0, false, 6, null);
                n3 = 0;
                String string6 = string5.substring(n5, n4);
                string2 = string6;
                Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string2 = nameOrNumberPart = portSpec;
            }
            if (StringsKt.contains$default((CharSequence)nameOrNumberPart, "/", false, 2, null)) {
                String string7 = nameOrNumberPart;
                n4 = StringsKt.indexOf$default((CharSequence)nameOrNumberPart, "/", 0, false, 6, null) + 1;
                n3 = 0;
                String string8 = string7;
                if (string8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.substring(n4);
                Intrinsics.checkNotNullExpressionValue(string9, "(this as java.lang.String).substring(startIndex)");
                protocol2 = Protocol.of(string9);
            } else {
                protocol2 = protocol = defaultProtocol;
            }
            if (StringsKt.contains$default((CharSequence)nameOrNumberPart, "/", false, 2, null)) {
                String string10 = nameOrNumberPart;
                n3 = 0;
                n2 = StringsKt.indexOf$default((CharSequence)nameOrNumberPart, "/", 0, false, 6, null);
                boolean bl = false;
                String string11 = string10;
                if (string11 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string12 = string11.substring(n3, n2);
                string = string12;
                Intrinsics.checkNotNullExpressionValue(string12, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string = nameOrNumber = nameOrNumberPart;
            }
            if (StringsKt.equals("http", nameOrNumber, true) && restriction == null) {
                return HTTP;
            }
            if (StringsKt.equals("https", nameOrNumber, true) && restriction == null) {
                return HTTPS;
            }
            try {
                String string13 = nameOrNumber;
                n2 = 0;
                n = Integer.parseInt(string13);
            }
            catch (NumberFormatException e) {
                throw new BoxfuseException(Intrinsics.stringPlus("Invalid port number (should be between 0 and 65535): ", nameOrNumber));
            }
            int number = n;
            return new Port(number, protocol, restriction, null);
        }

        @JvmStatic
        @NotNull
        public final Port getUnrestrictedTcpPort(int number) {
            for (Port port : namedPorts) {
                if (number != port.getNumber()) continue;
                return port;
            }
            return new Port(number, null, null, null);
        }

        @JvmStatic
        @NotNull
        public final Port findFreePort(int desiredPortNumber, @NotNull Protocol desiredProtocol, @NotNull Collection<Port> assignedPorts) {
            Intrinsics.checkNotNullParameter((Object)desiredProtocol, "desiredProtocol");
            Intrinsics.checkNotNullParameter(assignedPorts, "assignedPorts");
            int portNumberToTry = desiredPortNumber;
            Port port = null;
            while ((port = new Port(portNumberToTry, desiredProtocol, null, null)).conflictsWith(assignedPorts) || !port.isAvailable()) {
                int n = portNumberToTry;
                if ((portNumberToTry = n + 1) <= 65535) continue;
                throw new BoxfuseException("Unable to find a free port your the entire system!");
            }
            if (port.getNumber() != desiredPortNumber) {
                LOGGER.warn("Port " + desiredPortNumber + '/' + (Object)((Object)desiredProtocol) + " is occupied. Using alternative port: " + port + '/' + (Object)((Object)desiredProtocol));
            }
            return port;
        }

        @JvmStatic
        @NotNull
        public final Port of(int number, @Nullable Protocol protocol, @Nullable Restriction restriction) {
            return new Port(number, protocol, restriction, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

