/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.port;

import com.boxfuse.base.exception.BoxfuseException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum Protocol {
    HTTPS("https", true),
    HTTP("http", true),
    TCP("tcp", true),
    UDP("udp", false);

    private final String name;
    private final boolean tcp;

    private Protocol(String name, boolean tcp) {
        this.name = name;
        this.tcp = tcp;
    }

    @JsonCreator
    public static Protocol of(String name) {
        if (name == null) {
            return TCP;
        }
        for (Protocol protocol : Protocol.values()) {
            if (!name.equalsIgnoreCase(protocol.name)) continue;
            return protocol;
        }
        throw new BoxfuseException("Unknown protocol: " + name + " => use either tcp or udp");
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public boolean isTcp() {
        return this.tcp;
    }

    public String toString() {
        return this.name;
    }
}

