/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.util;

import com.boxfuse.base.exception.BoxfuseBugException;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.types.Proxy;
import com.boxfuse.base.util.ByteArrayUtils;
import com.boxfuse.base.util.ExceptionUtils;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.OSUtils;
import com.boxfuse.base.util.ProgressBar;
import com.boxfuse.base.util.ThreadUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.utils.CountingInputStream;
import org.apache.commons.compress.utils.CountingOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtils.class);

    private HttpUtils() {
    }

    public static CloseableHttpClient createHttpClient(Proxy proxy, boolean insecure, boolean automaticRetry) {
        return HttpUtils.createHttpClient(proxy, insecure, automaticRetry, null, null);
    }

    public static CloseableHttpClient createHttpClient(Proxy proxy, boolean insecure, boolean automaticRetry, String basicAuthUser, String basicAuthPassword) {
        HttpClientBuilder httpclient = HttpClientBuilder.create();
        if (basicAuthUser != null) {
            HttpUtils.configureBasicAuth(httpclient, basicAuthUser, basicAuthPassword);
        }
        if (!automaticRetry) {
            httpclient.disableAutomaticRetries();
        }
        if (insecure) {
            HttpUtils.configureInsecure(httpclient);
        }
        if (proxy != null) {
            HttpUtils.configureProxy(httpclient, proxy);
        } else {
            httpclient.useSystemProperties();
        }
        return httpclient.build();
    }

    private static void configureBasicAuth(HttpClientBuilder httpclient, String basicAuthUser, String basicAuthPassword) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(basicAuthUser, basicAuthPassword));
        httpclient.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    private static void configureProxy(HttpClientBuilder httpclient, Proxy proxy) {
        httpclient.setProxy(new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getProtocol()));
        if (proxy.getUser() != null) {
            SystemDefaultCredentialsProvider credsProvider = new SystemDefaultCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort()), (Credentials)new UsernamePasswordCredentials(proxy.getUser(), proxy.getPassword()));
            if (OSUtils.runningOnWindows()) {
                credsProvider.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort(), AuthScope.ANY_REALM, "NTLM"), (Credentials)new NTCredentials(proxy.getUser(), proxy.getPassword(), System.getenv("COMPUTERNAME"), System.getenv("USERDOMAIN")));
            }
            httpclient.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy()).setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
    }

    private static void configureInsecure(HttpClientBuilder httpclient) {
        SSLContext sslContext;
        httpclient.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new BoxfuseBugException("Invalid security config", e);
        }
        httpclient.setSSLContext(sslContext);
    }

    public static RequestConfig.Builder createRequestConfigBuilder(Proxy proxy) {
        RequestConfig.Builder builder = RequestConfig.custom();
        if (proxy != null) {
            builder.setProxy(new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getProtocol()));
        }
        return builder;
    }

    public static byte[] downloadWithProgress(String url, Proxy proxy, boolean insecure) {
        int retries = 0;
        int maxRetries = 7;
        while (retries++ < maxRetries) {
            try {
                byte[] actualMd5;
                HttpGet request = new HttpGet(url);
                request.setConfig(HttpUtils.createRequestConfigBuilder(proxy).build());
                CloseableHttpResponse response = HttpUtils.createHttpClient(proxy, insecure, true).execute((HttpUriRequest)request);
                if (response.getStatusLine().getStatusCode() != 200) {
                    ThreadUtils.sleep(1000 * (1 << retries));
                    continue;
                }
                String eTag = response.getFirstHeader("ETag").getValue();
                ProgressEntityWrapper wrapper = new ProgressEntityWrapper(response.getEntity());
                byte[] result = IOUtils.copyToByteArray(wrapper.getContent());
                if (eTag.contains("-")) {
                    return result;
                }
                byte[] expectedMd5 = ByteArrayUtils.fromHex(eTag.replace("\"", ""));
                if (Arrays.equals(expectedMd5, actualMd5 = DigestUtils.getMd5Digest().digest(result))) {
                    return result;
                }
                LOGGER.debug("Checksum error for download of " + url + ": " + ByteArrayUtils.toHex(expectedMd5) + " <-> " + ByteArrayUtils.toHex(actualMd5) + " Retrying download ...");
                ThreadUtils.sleep(1000 * (1 << retries));
            }
            catch (IOException e) {
                Throwable rootCause = ExceptionUtils.getRootCause(e);
                if (retries < maxRetries) {
                    int delay = 1 << retries;
                    LOGGER.info("Download failed (" + rootCause.getMessage() + ") => Retrying in " + delay + " secs ...");
                    ThreadUtils.sleep(1000 * delay);
                    continue;
                }
                throw new BoxfuseException("Download failed (" + rootCause.getMessage() + ") => check your network connection and retry", e);
            }
        }
        throw new BoxfuseException("Unable to download " + url);
    }

    public static String putWithProgress(ProgressBar progressBar, Object partToken, String url, byte[] data, String md5, Proxy proxy, boolean insecure) {
        int retries = 0;
        int maxRetries = 7;
        while (retries++ < maxRetries) {
            try {
                HttpPut put = new HttpPut(url);
                put.setConfig(HttpUtils.createRequestConfigBuilder(proxy).build());
                if (md5 != null) {
                    put.setHeader("Content-MD5", Base64.encodeBase64String((byte[])ByteArrayUtils.fromHex(md5)));
                }
                put.setEntity((HttpEntity)new ProgressEntityWrapper((HttpEntity)new RepeatableByteArrayInputStreamEntity(data), progressBar, partToken));
                CloseableHttpResponse response = HttpUtils.createHttpClient(proxy, insecure, false).execute((HttpUriRequest)put);
                if (response.containsHeader("ETag")) {
                    return response.getLastHeader("ETag").getValue();
                }
                return null;
            }
            catch (IOException e) {
                Throwable rootCause = ExceptionUtils.getRootCause(e);
                if (retries < maxRetries) {
                    int delay = 1 << retries;
                    LOGGER.info("Push failed (" + rootCause.getMessage() + ") => Retrying in " + delay + " secs ...");
                    ThreadUtils.sleep(1000 * delay);
                    continue;
                }
                throw new BoxfuseException("Push failed (" + rootCause.getMessage() + ") => check your network connection and retry", e);
            }
        }
        return null;
    }

    public static void putWithProgress(String url, byte[] data, Proxy proxy, boolean insecure) {
        int retries = 0;
        int maxRetries = 7;
        while (retries++ < maxRetries) {
            try {
                HttpPut put = new HttpPut(url);
                put.setConfig(HttpUtils.createRequestConfigBuilder(proxy).build());
                put.setEntity((HttpEntity)new ProgressEntityWrapper((HttpEntity)new RepeatableByteArrayInputStreamEntity(data)));
                HttpUtils.createHttpClient(proxy, insecure, false).execute((HttpUriRequest)put);
                return;
            }
            catch (IOException e) {
                Throwable rootCause = ExceptionUtils.getRootCause(e);
                if (retries < maxRetries) {
                    int delay = 1 << retries;
                    LOGGER.info("Push failed (" + rootCause.getMessage() + ") => Retrying in " + delay + " secs ...");
                    ThreadUtils.sleep(1000 * delay);
                    continue;
                }
                throw new BoxfuseException("Push failed (" + rootCause.getMessage() + ") => check your network connection and retry", e);
            }
        }
    }

    private static class ProgressOutputStream
    extends CountingOutputStream {
        private final ProgressBar progressBar;
        private final Object partToken;

        public ProgressOutputStream(ProgressBar progressBar, Object partToken, OutputStream out, long length) {
            super(out);
            this.progressBar = progressBar == null ? new ProgressBar(length) : progressBar;
            this.partToken = partToken;
        }

        @Override
        protected void count(long written) {
            super.count(written);
            this.progressBar.update(this.getBytesWritten(), this.partToken);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.progressBar.clear();
            if (this.partToken == null) {
                this.progressBar.clear();
            }
        }
    }

    private static class ProgressInputStream
    extends CountingInputStream {
        private final ProgressBar progressBar;
        private final Object partToken;

        public ProgressInputStream(ProgressBar progressBar, Object partToken, InputStream wrapped, long length) {
            super(wrapped);
            this.progressBar = progressBar == null ? new ProgressBar(length) : progressBar;
            this.partToken = partToken;
        }

        @Override
        public int read() throws IOException {
            this.progressBar.update(this.getBytesRead(), this.partToken);
            return super.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.progressBar.update(this.getBytesRead(), this.partToken);
            return super.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.progressBar.update(this.getBytesRead(), this.partToken);
            return super.read(b);
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.partToken == null) {
                this.progressBar.clear();
            }
        }
    }

    private static class ProgressEntityWrapper
    extends HttpEntityWrapper {
        private final ProgressBar progressBar;
        private final Object partToken;

        public ProgressEntityWrapper(HttpEntity entity) {
            super(entity);
            this.progressBar = null;
            this.partToken = null;
        }

        public ProgressEntityWrapper(HttpEntity entity, ProgressBar progressBar, Object partToken) {
            super(entity);
            this.progressBar = progressBar;
            this.partToken = partToken;
        }

        public InputStream getContent() throws IOException {
            return new ProgressInputStream(this.progressBar, this.partToken, this.wrappedEntity.getContent(), this.wrappedEntity.getContentLength());
        }

        public void writeTo(OutputStream outstream) throws IOException {
            ProgressOutputStream stream = new ProgressOutputStream(this.progressBar, this.partToken, outstream, this.wrappedEntity.getContentLength());
            super.writeTo((OutputStream)stream);
            stream.close();
        }
    }

    private static class RepeatableByteArrayInputStreamEntity
    extends InputStreamEntity {
        private final byte[] source;

        public RepeatableByteArrayInputStreamEntity(byte[] source) {
            super((InputStream)new ByteArrayInputStream(source), (long)source.length);
            this.source = source;
        }

        public boolean isRepeatable() {
            return true;
        }

        public InputStream getContent() throws IOException {
            return new ByteArrayInputStream(this.source);
        }
    }
}

