/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.util;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\n\u001a\u00020\u0004H\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\b\u0010\f\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/boxfuse/base/util/OSUtils;", "", "()V", "linux", "", "macOS", "osName", "", "osNameRaw", "windows", "runningOnLinux", "runningOnMac", "runningOnWindows", "boxfuse-base-core"})
public final class OSUtils {
    @NotNull
    public static final OSUtils INSTANCE = new OSUtils();
    @NotNull
    private static final String osNameRaw;
    private static final boolean windows;
    private static final boolean macOS;
    private static final boolean linux;
    @NotNull
    private static final String osName;

    private OSUtils() {
    }

    @JvmStatic
    public static final boolean runningOnWindows() {
        return windows;
    }

    @JvmStatic
    public static final boolean runningOnMac() {
        return macOS;
    }

    @JvmStatic
    public static final boolean runningOnLinux() {
        return linux;
    }

    @JvmStatic
    @NotNull
    public static final String osName() {
        return osName;
    }

    static {
        String string = System.getProperty("os.name", "generic");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(\"os.name\", \"generic\")");
        boolean bl = false;
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        osNameRaw = string2;
        windows = StringsKt.startsWith$default(osNameRaw, "windows", false, 2, null);
        macOS = StringsKt.startsWith$default(osNameRaw, "mac", false, 2, null);
        linux = StringsKt.startsWith$default(osNameRaw, "linux", false, 2, null);
        osName = windows ? "Windows" : (macOS ? "macOS" : (linux ? "Linux" : "Unknown OS"));
    }
}

