/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.util;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class ParallelGZIPOutputStream
extends FilterOutputStream {
    private static final int GZIP_MAGIC = 35615;
    private final ExecutorService executor;
    private final int nthreads;
    private final CRC32 crc = new CRC32();
    private final BlockingQueue<Future<byte[]>> emitQueue;
    private Block block = new Block();
    private int bytesWritten = 0;

    private static Deflater newDeflater() {
        return new Deflater(-1, true);
    }

    private static DeflaterOutputStream newDeflaterOutputStream(OutputStream out, Deflater deflater) {
        return new DeflaterOutputStream(out, deflater, 512, true);
    }

    public ParallelGZIPOutputStream(OutputStream out, ExecutorService executor, int nthreads) throws IOException {
        super(out);
        this.executor = executor;
        this.nthreads = nthreads;
        this.emitQueue = new ArrayBlockingQueue<Future<byte[]>>(nthreads);
        this.writeHeader();
    }

    public ParallelGZIPOutputStream(OutputStream out, int nthreads) throws IOException {
        this(out, Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread2 = new Thread(r);
                thread2.setDaemon(true);
                return thread2;
            }
        }), nthreads);
    }

    public ParallelGZIPOutputStream(OutputStream out) throws IOException {
        this(out, Runtime.getRuntime().availableProcessors());
    }

    private void writeHeader() throws IOException {
        this.out.write(new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 3});
    }

    @Override
    public void write(int b) throws IOException {
        byte[] single = new byte[]{(byte)(b & 0xFF)};
        this.write(single);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.crc.update(b, off, len);
        this.bytesWritten += len;
        while (len > 0) {
            Block block;
            int capacity = this.block.in.length - this.block.in_length;
            if (len >= capacity) {
                System.arraycopy(b, off, this.block.in, this.block.in_length, capacity);
                block = this.block;
                block.in_length = block.in_length + capacity;
                off += capacity;
                len -= capacity;
                this.submit();
                continue;
            }
            System.arraycopy(b, off, this.block.in, this.block.in_length, len);
            block = this.block;
            block.in_length = block.in_length + len;
            break;
        }
    }

    private void submit() throws IOException {
        this.emitUntil(this.nthreads - 1);
        this.emitQueue.add(this.executor.submit(this.block));
        this.block = new Block();
    }

    private void tryEmit() throws IOException, InterruptedException, ExecutionException {
        Future future;
        while ((future = (Future)this.emitQueue.peek()) != null) {
            if (!future.isDone()) {
                return;
            }
            this.emitQueue.remove();
            this.out.write((byte[])future.get());
        }
        return;
    }

    private void emitUntil(int taskCountAllowed) throws IOException {
        try {
            while (this.emitQueue.size() > taskCountAllowed) {
                Future future = (Future)this.emitQueue.remove();
                this.out.write((byte[])future.get());
            }
            this.tryEmit();
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.block.in_length > 0) {
            this.submit();
        }
        this.emitUntil(0);
        super.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.bytesWritten >= 0) {
            this.flush();
            ParallelGZIPOutputStream.newDeflaterOutputStream(this.out, ParallelGZIPOutputStream.newDeflater()).finish();
            ByteBuffer buf = ByteBuffer.allocate(8);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            buf.putInt((int)this.crc.getValue());
            buf.putInt(this.bytesWritten);
            this.out.write(buf.array());
            this.out.flush();
            this.out.close();
            this.bytesWritten = Integer.MIN_VALUE;
        }
        this.executor.shutdown();
    }

    static /* synthetic */ Deflater access$000() {
        return ParallelGZIPOutputStream.newDeflater();
    }

    static /* synthetic */ DeflaterOutputStream access$100(OutputStream x0, Deflater x1) {
        return ParallelGZIPOutputStream.newDeflaterOutputStream(x0, x1);
    }

    private static class Block
    implements Callable<byte[]> {
        private static final ThreadLocal<State> STATE = new ThreadLocal<State>(){

            @Override
            protected State initialValue() {
                return new State();
            }
        };
        static final int SIZE = 0x100000;
        private final byte[] in = new byte[0x100000];
        private int in_length = 0;

        private Block() {
        }

        @Override
        public byte[] call() throws Exception {
            State state = STATE.get();
            state.def.reset();
            state.buf.reset();
            state.str.write(this.in, 0, this.in_length);
            state.str.flush();
            return state.buf.toByteArray();
        }

        public String toString() {
            return "Block(" + this.in_length + "/" + this.in.length + " bytes)";
        }

        private static class State {
            private final Deflater def = ParallelGZIPOutputStream.access$000();
            private final ByteArrayOutputStream buf = new ByteArrayOutputStream(0x100000);
            private final DeflaterOutputStream str = ParallelGZIPOutputStream.access$100(this.buf, this.def);

            private State() {
            }
        }
    }
}

