/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.util;

import com.boxfuse.base.exception.BoxfuseBugException;
import com.boxfuse.base.types.IpAddress;
import com.boxfuse.base.types.MacAddress;
import com.boxfuse.base.util.ExceptionUtils;
import com.boxfuse.base.util.OSUtils;
import com.boxfuse.base.util.ShellUtils;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.base.util.ThreadUtils;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerUtils.class);

    private ServerUtils() {
    }

    public static int checkHttpCode(String url, long timeOut, int expectedCode) {
        int previousResponseCode = -1;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeOut * 1000L) {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
                connection.setConnectTimeout(1000);
                connection.setReadTimeout(10000);
                if (url.startsWith("https")) {
                    HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                    TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }

                        @Override
                        public void checkClientTrusted(X509Certificate[] certs, String authType) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] certs, String authType) {
                        }
                    }};
                    SSLContext sslContext = SSLContext.getInstance("SSL");
                    sslContext.init(null, trustAllCerts, new SecureRandom());
                    httpsConnection.setSSLSocketFactory(sslContext.getSocketFactory());
                    httpsConnection.setHostnameVerifier(new HostnameVerifier(){

                        @Override
                        public boolean verify(String hostname, SSLSession sslSession) {
                            return true;
                        }
                    });
                }
                connection.connect();
                int responseCode = connection.getResponseCode();
                LOGGER.debug("Connected to " + url + " -> HTTP " + responseCode);
                if (responseCode == expectedCode) {
                    return responseCode;
                }
                if (responseCode == previousResponseCode) {
                    LOGGER.debug("Retrying in 1 second ...");
                } else {
                    previousResponseCode = responseCode;
                    LOGGER.warn("Healthcheck (" + url + ") returned " + responseCode + " instead of " + expectedCode + ". Retrying ...");
                }
            }
            catch (Exception e) {
                LOGGER.debug("Failed to connect to " + url + " (" + ExceptionUtils.getRootCause(e).getMessage() + "). Retrying in 1 sec ...");
            }
            ThreadUtils.sleep(1000L);
        }
        return previousResponseCode;
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return ServerUtils.getHostIp();
        }
    }

    public static MacAddress getMacAddress() {
        try {
            Integer boxfuseHyperVNicIndex = ServerUtils.getBoxfuseHyperVNicIndex();
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface nic = networkInterfaces.nextElement();
                if (!nic.isUp() || !ServerUtils.isFirstChoice(nic, boxfuseHyperVNicIndex) || nic.getHardwareAddress() == null) continue;
                return MacAddress.of(nic.getHardwareAddress());
            }
            NetworkInterface localHost = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            if (localHost != null && localHost.getHardwareAddress() != null) {
                return MacAddress.of(localHost.getHardwareAddress());
            }
            NetworkInterface nic = NetworkInterface.getByInetAddress(InetAddress.getByName(ServerUtils.getHostIp()));
            if (nic != null && nic.getHardwareAddress() != null) {
                return MacAddress.of(nic.getHardwareAddress());
            }
            LOGGER.debug("Unable to obtain MAC address for localhost");
        }
        catch (Exception e) {
            LOGGER.debug("Unable to obtain MAC address for localhost: " + e.getMessage());
        }
        return MacAddress.of(new byte[6]);
    }

    public static IpAddress getHostIpAddress() {
        return IpAddress.of(ServerUtils.getHostIp());
    }

    private static String getHostIp() {
        Integer boxfuseHyperVNicIndex = ServerUtils.getBoxfuseHyperVNicIndex();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            String backupCandidate = null;
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface nic = networkInterfaces.nextElement();
                if (!nic.isUp()) continue;
                Enumeration<InetAddress> inetAddresses = nic.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
                    if (ServerUtils.isFirstChoice(nic, boxfuseHyperVNicIndex)) {
                        return inetAddress.getHostAddress();
                    }
                    backupCandidate = inetAddress.getHostAddress();
                }
            }
            if (backupCandidate != null) {
                return backupCandidate;
            }
            throw new BoxfuseBugException("Unable to determine host ip address");
        }
        catch (SocketException e) {
            throw new BoxfuseBugException("Unable to determine host ip address", e);
        }
    }

    private static Integer getBoxfuseHyperVNicIndex() {
        if (!OSUtils.runningOnWindows()) {
            return null;
        }
        try {
            String out = ShellUtils.execCommand("netsh", "interface", "ipv4", "show", "interface");
            return ServerUtils.extractBoxfuseHyperVNicIndex(out);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static Integer extractBoxfuseHyperVNicIndex(String out) {
        for (String line : StringUtils.splitIntoLines(out)) {
            if (!line.contains("Boxfuse")) continue;
            String trim = line.trim();
            return Integer.valueOf(trim.substring(0, trim.indexOf(" ")));
        }
        return null;
    }

    private static boolean isFirstChoice(NetworkInterface nic, Integer boxfuseHyperVNicIndex) throws SocketException {
        return boxfuseHyperVNicIndex != null && boxfuseHyperVNicIndex.intValue() == nic.getIndex() || !nic.isLoopback() && !nic.isVirtual() && !nic.getName().contains("vboxnet") && !nic.getName().contains("vmnet") && (nic.getDisplayName() == null || !nic.getDisplayName().contains("VirtualBox") && !nic.getDisplayName().contains("VMware") && !nic.getDisplayName().contains("Teredo Tunneling") && !nic.getDisplayName().contains("Hyper-V"));
    }
}

