/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.cloudwatchlogs;

import com.boxfuse.base.coordinates.AppCoordinates;
import com.boxfuse.base.coordinates.Owner;
import com.boxfuse.base.logs.cloudwatchlogs.LogsFieldName;
import com.boxfuse.base.logs.cloudwatchlogs.LogsLayout;
import com.boxfuse.base.types.EnvName;
import com.boxfuse.base.util.HttpUtils;
import com.boxfuse.base.util.JsonUtils;
import com.boxfuse.client.core.internal.cloudwatchlogs.CloudwatchLogsHttpLogs;
import com.boxfuse.client.core.internal.dev.DevAgent;
import com.boxfuse.generator.config.LogsFilters;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;

public class CloudwatchLogsMockLogs
extends CloudwatchLogsHttpLogs {
    private final DevAgent devAgent;

    public CloudwatchLogsMockLogs(Owner owner, DevAgent devAgent, EnvName env, LogsFilters filters, LogsLayout layout) {
        super(owner, env, filters, layout, null, false);
        this.devAgent = devAgent;
    }

    @Override
    protected HttpPost createRequest(Map<String, Object> data) {
        AppCoordinates appCoordinates = (AppCoordinates)this.filters.get((Object)LogsFieldName.APP);
        if (appCoordinates != null) {
            data.put("logStreamNames", Collections.singletonList(appCoordinates.toString()));
        }
        HttpPost post = new HttpPost("http://localhost:" + this.devAgent.getPort().getNumber() + "/cloudwatchlogs");
        post.setConfig(HttpUtils.createRequestConfigBuilder(null).setConnectTimeout(1000).setSocketTimeout(5000).build());
        post.addHeader((Header)new BasicHeader("X-Amz-Target", "Logs_20140328.FilterLogEvents"));
        post.setEntity((HttpEntity)new ByteArrayEntity(JsonUtils.mapToJson(data).getBytes(StandardCharsets.UTF_8), ContentType.create((String)"application/x-amz-json-1.1")));
        return post;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CloudwatchLogsMockLogs that = (CloudwatchLogsMockLogs)o;
        return this.devAgent.equals(that.devAgent);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.devAgent.hashCode();
        return result;
    }
}

