/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.diskimage;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.Template;
import com.boxfuse.client.core.internal.diskimage.DiskImage;
import com.boxfuse.generator.image.Image;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

public class Vmdk
extends DiskImage {
    public Vmdk(Image image, File directory) {
        super(image, directory);
    }

    @Override
    public void save() {
        File diskImageFile = new File(this.directory, this.image.getId() + "-flat.vmdk");
        try {
            IOUtils.copy(this.image.getDiskImage(), diskImageFile);
        }
        catch (IOException e) {
            throw new BoxfuseException("Unable to extract disk image for " + this.image.getCoordinates() + " (" + e.getMessage() + ")", e);
        }
        String diskDescriptor = Template.process("vmdk/vmdk.template", diskImageFile.length() / 512L, diskImageFile.getName(), UUID.randomUUID().toString());
        IOUtils.copy(diskDescriptor, this.getMainFile());
    }

    @Override
    public File getMainFile() {
        return new File(this.directory, this.image.getId() + ".vmdk");
    }
}

