/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.platform;

import com.boxfuse.base.enums.AppType;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.logs.Logs;
import com.boxfuse.base.logs.LogsListener;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.port.Protocol;
import com.boxfuse.base.types.HealthcheckTimeout;
import com.boxfuse.base.types.Path;
import com.boxfuse.base.util.OSUtils;
import com.boxfuse.base.util.ServerUtils;
import com.boxfuse.base.util.StopWatch;
import com.boxfuse.base.util.TimeFormat;
import com.boxfuse.client.core.internal.diskimage.DiskImage;
import com.boxfuse.client.core.internal.platform.AbstractPlatform;
import com.boxfuse.client.core.internal.platform.BootLogsListener;
import com.boxfuse.client.core.internal.platform.Instance;
import com.boxfuse.client.core.internal.platform.LaunchSettings;
import com.boxfuse.client.core.internal.platform.Platform;
import com.boxfuse.client.core.internal.platform.local.NoOpLogs;
import com.boxfuse.generator.config.CpuCount;
import com.boxfuse.generator.config.InstanceId;
import com.boxfuse.generator.config.RamMB;
import com.boxfuse.generator.image.Image;
import java.io.File;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInstance<H extends AbstractPlatform>
implements Instance {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractInstance.class);
    protected final H platform;
    protected final Image image;
    protected final DiskImage diskImage;
    protected final InstanceId id;
    private final String type;
    private final Date launchTime;
    private final Logs bootLogs;
    private final Logs appLogs;
    protected final File workDir;
    private final Map<PortName, Port> ports;
    private final Path payloadPath;

    public AbstractInstance(H platform, Image image, DiskImage diskImage, InstanceId id, CpuCount cpus, RamMB ram, Date launchTime, Logs bootLogs, Logs appLogs, File workDir, Map<PortName, Port> ports, Path payloadPath) {
        this.platform = platform;
        this.image = image;
        this.diskImage = diskImage;
        this.id = id;
        this.type = cpus + " CPU / " + ram + " MB RAM";
        this.launchTime = launchTime;
        this.bootLogs = bootLogs;
        this.appLogs = appLogs;
        this.workDir = workDir;
        this.ports = ports;
        this.payloadPath = payloadPath;
    }

    protected Map<PortName, Port> getPorts() {
        return this.ports;
    }

    @Override
    public InstanceId getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Date getLaunchTime() {
        return this.launchTime;
    }

    @Override
    public Logs bootLogs() {
        return this.bootLogs;
    }

    private String getBaseUrl() {
        Port port = this.getPorts().get(PortName.HTTPS);
        if (port != null) {
            return this.getUrl(PortName.HTTPS, port);
        }
        port = this.getPorts().get(PortName.HTTP);
        if (port != null) {
            return this.getUrl(PortName.HTTP, port);
        }
        return null;
    }

    private String getUrl(PortName portName, Port port) {
        Protocol protocol = portName.getProtocol();
        boolean isOnDefaultPort = new Integer(port.getNumber()).equals(portName.getDefaultPortNumber());
        return (Object)((Object)protocol) + "://" + this.getIpAddress() + (isOnDefaultPort ? "" : ":" + port.getNumber());
    }

    private String getDebugUrl() {
        return "tcp://" + this.getIpAddress() + ":" + this.getPorts().get(PortName.DEBUG).getNumber();
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    void waitForPayloadToStart(AppType appType, LaunchSettings launchSettings) {
        boolean jmx;
        boolean debugWait;
        if (Boolean.FALSE == launchSettings.getHealthcheck() || !this.image.isHealthcheck()) {
            return;
        }
        boolean debug = launchSettings.getDebug() == null ? this.image.isDebug() : launchSettings.getDebug().booleanValue();
        boolean bl = debugWait = launchSettings.getDebugWait() == null ? this.image.isDebugWait() : launchSettings.getDebugWait().booleanValue();
        if (debug && debugWait) {
            LOGGER.info("Payload waiting for remote debugger: " + this.getDebugUrl());
            return;
        }
        if (this.image.getPorts().isEmpty()) {
            LOGGER.warn("Skipping healthcheck for " + this.image.getCoordinates() + " as it has no ports");
            return;
        }
        PortName effectivePort = launchSettings.getHealthcheckPort() != null ? launchSettings.getHealthcheckPort() : this.image.getHealthcheckPort();
        String baseUrl = effectivePort == null ? this.getBaseUrl() : this.getUrl(effectivePort, this.getPorts().get(effectivePort));
        Path effectivePath = launchSettings.getHealthcheckPath() != null ? launchSettings.getHealthcheckPath() : this.image.getHealthcheckPath();
        HealthcheckTimeout effectiveTimeout = launchSettings.getHealthcheckTimeout() != null ? launchSettings.getHealthcheckTimeout() : this.image.getHealthcheckTimeout();
        LOGGER.info("Waiting for payload to start on " + this + ":" + this.image.getPorts().get(effectivePort) + " (expecting HTTP 200 at " + effectivePath + " within " + effectiveTimeout + "s) ...");
        if (launchSettings.isLogsAuto()) {
            this.bootLogs.start(true, new BootLogsListener(this.id));
            this.appLogs.start(true, new LogsListener(){

                @Override
                public void onTraceLine(String line) {
                    LOGGER.trace(AbstractInstance.this.getId() + " => " + line);
                }

                @Override
                public void onDebugLine(String line) {
                    LOGGER.debug(AbstractInstance.this.getId() + " => " + line);
                }

                @Override
                public void onInfoLine(String line) {
                    LOGGER.info(AbstractInstance.this.getId() + " => " + line);
                }

                @Override
                public void onWarnLine(String line) {
                    LOGGER.warn(AbstractInstance.this.getId() + " => " + line);
                }

                @Override
                public void onErrorLine(String line) {
                    LOGGER.error(AbstractInstance.this.getId() + " => " + line);
                }

                @Override
                public void onException(Exception e) {
                    LOGGER.debug(AbstractInstance.this.getId() + " ERROR => " + e.getMessage());
                }
            });
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String checkUrl = baseUrl + effectivePath;
        int httpCode = ServerUtils.checkHttpCode(checkUrl, effectiveTimeout.getValue(), 200);
        String resolutions = "\n check the app logs for " + this.id;
        if (NoOpLogs.INSTANCE == this.bootLogs) {
            resolutions = resolutions + "\n=> set logs.boot to true and check the boot logs for " + this.id;
        }
        resolutions = resolutions + "\n=> ensure " + checkUrl + " returns HTTP 200\n=> ensure healthcheck.path, healthcheck.port and healthcheck.timeout are configured correctly";
        if (-1 == httpCode) {
            if (!((AbstractPlatform)this.platform).isPlatformOK()) {
                resolutions = resolutions + "\n=> ensure VirtualBox is working correctly\n=> ensure hardware virtualization (VT-x or AMD-V) is enabled on your machine";
                if (OSUtils.runningOnWindows()) {
                    resolutions = resolutions + "\n=> ensure Hyper-V is disabled";
                }
            }
            throw new BoxfuseException("Time out: Payload of Instance " + this + " failed to come up within " + effectiveTimeout + " seconds at " + checkUrl + resolutions);
        }
        if (200 != httpCode) {
            throw new BoxfuseException("Payload of Instance " + this + " came up at " + checkUrl + " with HTTP " + httpCode + " (expected 200)" + resolutions);
        }
        stopWatch.stop();
        if (launchSettings.isLogsAuto() && !launchSettings.isLogsTail()) {
            this.bootLogs.stop();
            this.appLogs.stop();
        }
        if (debug) {
            LOGGER.info("Ready to accept remote debugger connections -> " + this.getDebugUrl());
        }
        boolean bl2 = jmx = launchSettings.getJvmJmx() == null ? this.image.getJvm().isJmx() : launchSettings.getJvmJmx().booleanValue();
        if (jmx) {
            LOGGER.info("Ready to accept JMX connections -> " + this.getIpAddress() + ":" + this.getPorts().get(PortName.JMX).getNumber() + " (user: boxfuse / password: boxfuse)");
        }
        String msg = "Successfully started payload in " + TimeFormat.format(stopWatch.getTotalTimeMillis());
        if (appType == AppType.SINGLE_INSTANCE || appType == AppType.LOAD_BALANCED) {
            msg = msg + " -> " + this.getPayloadUrl();
        }
        LOGGER.info(msg);
    }

    @Override
    public String getPayloadUrl() {
        String base = this.getBaseUrl();
        if (this.payloadPath == null || Path.of("/").equals(this.payloadPath)) {
            return base;
        }
        return base + this.payloadPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractInstance that = (AbstractInstance)o;
        if (!((AbstractPlatform)this.platform).equals(that.platform)) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.image.equals(that.image)) {
            return false;
        }
        return !(this.workDir == null ? that.workDir != null : !this.workDir.equals(that.workDir));
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id.getId();
    }

    @Override
    public int compareTo(Instance o) {
        return this.launchTime.compareTo(o.getLaunchTime());
    }
}

