/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.platform.local;

import com.boxfuse.base.coordinates.AppCoordinates;
import com.boxfuse.base.coordinates.ImageCoordinates;
import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.LogsType;
import com.boxfuse.base.enums.PlatformType;
import com.boxfuse.base.env.EnvVarName;
import com.boxfuse.base.env.EnvVarValue;
import com.boxfuse.base.env.EnvironmentScript;
import com.boxfuse.base.exception.BoxfuseBugException;
import com.boxfuse.base.logs.Logs;
import com.boxfuse.base.logs.cloudwatchlogs.LogsFieldName;
import com.boxfuse.base.logs.cloudwatchlogs.LogsLayout;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.port.Protocol;
import com.boxfuse.base.port.Restriction;
import com.boxfuse.base.types.EnvName;
import com.boxfuse.base.util.ServerUtils;
import com.boxfuse.base.util.ShellUtils;
import com.boxfuse.client.core.internal.cloudwatchlogs.CloudwatchLogsMockLogs;
import com.boxfuse.client.core.internal.dev.DevAgent;
import com.boxfuse.client.core.internal.diskimage.DiskImage;
import com.boxfuse.client.core.internal.platform.AbstractInstance;
import com.boxfuse.client.core.internal.platform.AbstractPlatform;
import com.boxfuse.client.core.internal.platform.DevVM;
import com.boxfuse.client.core.internal.platform.Instance;
import com.boxfuse.client.core.internal.platform.InstanceMetadata;
import com.boxfuse.client.core.internal.platform.LaunchSettings;
import com.boxfuse.client.core.internal.platform.local.NoOpLogs;
import com.boxfuse.generator.config.InstanceId;
import com.boxfuse.generator.config.LogsFilters;
import com.boxfuse.generator.image.Image;
import com.boxfuse.generator.repository.Repository;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.stephenc.javaisotools.iso9660.ConfigException;
import com.github.stephenc.javaisotools.iso9660.ISO9660File;
import com.github.stephenc.javaisotools.iso9660.ISO9660RootDirectory;
import com.github.stephenc.javaisotools.iso9660.impl.CreateISO;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Config;
import com.github.stephenc.javaisotools.iso9660.impl.ISOImageFileHandler;
import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import com.github.stephenc.javaisotools.sabre.impl.ByteArrayDataReference;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.DatatypeConverter;
import org.ini4j.Wini;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocalPlatform<I extends AbstractInstance>
extends AbstractPlatform<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalPlatform.class);
    protected static final String TAG_KEY = "boxfuse";
    private static final EnvVarName ENVVAR_AWS_ACCESS_KEY_ID = EnvVarName.of("AWS_ACCESS_KEY_ID");
    private static final EnvVarName ENVVAR_AWS_SECRET_ACCESS_KEY = EnvVarName.of("AWS_SECRET_ACCESS_KEY");
    protected final LogsLayout logsLayout;

    protected LocalPlatform(PlatformType type, File workDir, Repository repository, DevAgent devAgent, LogsLayout logsLayout, boolean platformOK) {
        super(type, workDir, repository, devAgent, platformOK);
        this.logsLayout = logsLayout;
    }

    @Override
    public List<Instance> findInstances(ImageCoordinates coordinates) {
        ArrayList<Instance> result = new ArrayList<Instance>();
        for (Instance instance : this.runningInstances()) {
            if (!instance.getImage().getCoordinates().equals(coordinates)) continue;
            result.add(instance);
        }
        return result;
    }

    @Override
    public List<Instance> findInstances(AppCoordinates coordinates) {
        ArrayList<Instance> result = new ArrayList<Instance>();
        for (Instance instance : this.runningInstances()) {
            if (!instance.getImage().getCoordinates().getAppCoordinates().equals(coordinates)) continue;
            result.add(instance);
        }
        return result;
    }

    @Override
    protected final I doLaunchInstance(Image image, LaunchSettings launchSettings, DevVM devVM, Port devAgentPort, LogsFilters logFilters) {
        Port port;
        InstanceId instanceId = this.generateInstanceId();
        File instanceDir = this.getInstanceDir(instanceId);
        ShellUtils.mkdir(instanceDir);
        TreeMap<EnvVarName, EnvVarValue> envVars = new TreeMap<EnvVarName, EnvVarValue>(launchSettings.getEnvVars());
        envVars.put(EnvVarName.BOXFUSE_ENV, EnvVarValue.asIs("dev"));
        envVars.put(EnvVarName.BOXFUSE_INSTANCE_ID, EnvVarValue.asIs(instanceId.getId()));
        envVars.put(EnvVarName.BOXFUSE_HOST_IP, EnvVarValue.asIs(ServerUtils.getHostIpAddress().toString()));
        envVars.put(EnvVarName.BOXFUSE_INSTANCE_IP, EnvVarValue.asIs(ServerUtils.getHostIpAddress().toString()));
        DiskImage diskImage = this.createOrGetDiskImage(image, instanceDir);
        diskImage.save();
        TreeMap<PortName, Port> ports = new TreeMap<PortName, Port>(image.getPorts());
        ports.putAll(launchSettings.getPorts());
        for (Map.Entry port2 : ports.entrySet()) {
            envVars.put(EnvVarName.of((PortName)port2.getKey()), EnvVarValue.asIs("" + ((Port)port2.getValue()).getNumber()));
        }
        if (!ports.containsKey(PortName.DEBUG) && Boolean.TRUE.equals(launchSettings.getDebug())) {
            port = Port.of(5005, Protocol.TCP, Restriction.OWN_IP);
            ports.put(PortName.DEBUG, port);
            envVars.put(EnvVarName.of(PortName.DEBUG), EnvVarValue.asIs("" + port.getNumber()));
        }
        if (!ports.containsKey(PortName.JMX) && Boolean.TRUE.equals(launchSettings.getJvmJmx())) {
            port = Port.of(1099, Protocol.TCP, Restriction.OWN_IP);
            ports.put(PortName.JMX, port);
            envVars.put(EnvVarName.of(PortName.JMX), EnvVarValue.asIs("" + port.getNumber()));
        }
        if (launchSettings.getDebug() != null) {
            envVars.put(EnvVarName.BOXFUSE_DEBUG, EnvVarValue.asIs(launchSettings.getDebug().toString()));
        }
        if (launchSettings.getDebugWait() != null) {
            envVars.put(EnvVarName.BOXFUSE_DEBUG_WAIT, EnvVarValue.asIs(launchSettings.getDebugWait().toString()));
        }
        if (launchSettings.getTmp() != null) {
            envVars.put(EnvVarName.BOXFUSE_TMP, EnvVarValue.asIs(launchSettings.getTmp().toString()));
        }
        if (launchSettings.getJvmArgs() != null) {
            envVars.put(EnvVarName.BOXFUSE_JVM_ARGS, EnvVarValue.flexi(launchSettings.getJvmArgs()));
        }
        if (launchSettings.getJvmMainClass() != null) {
            envVars.put(EnvVarName.BOXFUSE_JVM_MAIN_CLASS, EnvVarValue.flexi(launchSettings.getJvmMainClass()));
        }
        if (launchSettings.getJvmMainArgs() != null) {
            envVars.put(EnvVarName.BOXFUSE_JVM_MAIN_ARGS, EnvVarValue.flexi(launchSettings.getJvmMainArgs()));
        }
        if (launchSettings.getJvmJmx() != null) {
            envVars.put(EnvVarName.BOXFUSE_JVM_JMX, EnvVarValue.asIs(launchSettings.getJvmJmx().toString()));
        }
        this.addAwsCredentialsEnvVars(envVars);
        if (DbType.POSTGRESQL == image.getDbType()) {
            if (PayloadType.NODEJS == image.getPayload().getType()) {
                envVars.put(EnvVarName.BOXFUSE_DATABASE_HOST, EnvVarValue.asIs("" + devVM.getInstanceAccessibleIpAddress()));
                envVars.put(EnvVarName.BOXFUSE_DATABASE_PORT, EnvVarValue.asIs("" + devVM.getInstancePort(DbType.POSTGRESQL)));
                envVars.put(EnvVarName.BOXFUSE_DATABASE_NAME, EnvVarValue.asIs("boxfuse-dev-db"));
                envVars.put(EnvVarName.BOXFUSE_DATABASE_USER, EnvVarValue.asIs("boxfuse-dev-db"));
                envVars.put(EnvVarName.BOXFUSE_DATABASE_PASSWORD, EnvVarValue.asIs("boxfuse-dev-db"));
            } else {
                envVars.put(EnvVarName.BOXFUSE_DATABASE_URL, EnvVarValue.asIs("jdbc:postgresql://" + devVM.getInstanceAccessibleIpAddress() + ":" + devVM.getInstancePort(DbType.POSTGRESQL) + "/boxfuse-dev-db?ssl=true&sslfactory=org.postgresql.ssl.NonValidatingFactory"));
                envVars.put(EnvVarName.BOXFUSE_DATABASE_USER, EnvVarValue.asIs("boxfuse-dev-db"));
                envVars.put(EnvVarName.BOXFUSE_DATABASE_PASSWORD, EnvVarValue.asIs("boxfuse-dev-db"));
            }
        } else if (DbType.MYSQL == image.getDbType()) {
            if (PayloadType.NODEJS == image.getPayload().getType()) {
                envVars.put(EnvVarName.BOXFUSE_DATABASE_HOST, EnvVarValue.asIs("" + devVM.getInstanceAccessibleIpAddress()));
                envVars.put(EnvVarName.BOXFUSE_DATABASE_PORT, EnvVarValue.asIs("" + devVM.getInstancePort(DbType.MYSQL)));
                envVars.put(EnvVarName.BOXFUSE_DATABASE_NAME, EnvVarValue.asIs("boxfuse-dev-db"));
                envVars.put(EnvVarName.BOXFUSE_DATABASE_USER, EnvVarValue.asIs("boxfuse-dev-db"));
                envVars.put(EnvVarName.BOXFUSE_DATABASE_PASSWORD, EnvVarValue.asIs("boxfuse-dev-db"));
            } else {
                envVars.put(EnvVarName.BOXFUSE_DATABASE_URL, EnvVarValue.asIs("jdbc:mysql://" + devVM.getInstanceAccessibleIpAddress() + ":" + devVM.getInstancePort(DbType.MYSQL) + "/boxfuse-dev-db"));
                envVars.put(EnvVarName.BOXFUSE_DATABASE_USER, EnvVarValue.asIs("boxfuse-dev-db"));
                envVars.put(EnvVarName.BOXFUSE_DATABASE_PASSWORD, EnvVarValue.asIs("boxfuse-dev-db"));
            }
        }
        String devAgentUrl = "http://" + ServerUtils.getHostIpAddress().toString() + ":" + (devAgentPort == null ? 8000 : devAgentPort.getNumber());
        if (this.needsDevAgent()) {
            envVars.put(EnvVarName.BOXFUSE_DEVAGENT, EnvVarValue.asIs(devAgentUrl));
        }
        if (LogsType.CLOUDWATCH_LOGS == image.getLogsType()) {
            envVars.put(EnvVarName.BOXFUSE_CLOUDWATCHLOGS_ENDPOINT, EnvVarValue.asIs(devAgentUrl + "/cloudwatchlogs"));
            logFilters.getFilters().put(LogsFieldName.APP, image.getCoordinates().getAppCoordinates());
            logFilters.getFilters().put(LogsFieldName.IMAGE, image.getCoordinates());
            logFilters.getFilters().put(LogsFieldName.INSTANCE, instanceId);
        }
        Logs appLogs = this.getAppLogs(image, logFilters);
        Date launchTime = new Date();
        return this.startAndTagInstance(instanceId, instanceDir, image, diskImage, launchSettings, ports, envVars, appLogs, launchTime);
    }

    protected Logs getAppLogs(Image image, LogsFilters logFilters) {
        Logs appLogs = LogsType.CLOUDWATCH_LOGS == image.getLogsType() ? new CloudwatchLogsMockLogs(this.repository.getOwner(), this.devAgent, EnvName.DEV, logFilters, this.logsLayout) : NoOpLogs.INSTANCE;
        return appLogs;
    }

    protected abstract DiskImage createOrGetDiskImage(Image var1, File var2);

    private void addAwsCredentialsEnvVars(Map<EnvVarName, EnvVarValue> envVars) {
        File awsCredentialsFile;
        if (envVars.containsKey(ENVVAR_AWS_ACCESS_KEY_ID) && envVars.containsKey(ENVVAR_AWS_SECRET_ACCESS_KEY)) {
            return;
        }
        Wini awsCredentialsIni = null;
        String awsCredentialsFileName = System.getenv("AWS_CREDENTIAL_PROFILES_FILE");
        if (awsCredentialsFileName == null) {
            awsCredentialsFileName = System.getProperty("user.home") + "/.aws/credentials";
        }
        if (!(awsCredentialsFile = new File(awsCredentialsFileName)).canRead() || !awsCredentialsFile.isFile()) {
            LOGGER.debug("Unable to read AWS credential file: " + awsCredentialsFileName);
        } else {
            try {
                awsCredentialsIni = new Wini(awsCredentialsFile);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to load default AWS credentials from " + awsCredentialsFileName + ": " + e.getMessage());
            }
        }
        Wini awsConfigIni = null;
        String awsConfigFileName = System.getProperty("user.home") + "/.aws/config";
        File awsConfigFile = new File(awsConfigFileName);
        if (!awsConfigFile.canRead() || !awsConfigFile.isFile()) {
            LOGGER.debug("Unable to read AWS config file: " + awsConfigFileName);
        } else {
            try {
                awsConfigIni = new Wini(awsConfigFile);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to load default AWS config from " + awsConfigFileName + ": " + e.getMessage());
            }
        }
        if (!envVars.containsKey(ENVVAR_AWS_ACCESS_KEY_ID)) {
            String accessKey = this.getIniValueForSectionAndKey(awsCredentialsIni, TAG_KEY, "aws_access_key_id");
            if (accessKey == null && (accessKey = this.getIniValueForSectionAndKey(awsCredentialsIni, "default", "aws_access_key_id")) == null) {
                accessKey = this.getIniValueForSectionAndKey(awsConfigIni, "default", "aws_access_key_id");
            }
            if (accessKey != null) {
                envVars.put(ENVVAR_AWS_ACCESS_KEY_ID, EnvVarValue.asIs(accessKey));
            }
        }
        if (!envVars.containsKey(ENVVAR_AWS_SECRET_ACCESS_KEY)) {
            String secretKey = this.getIniValueForSectionAndKey(awsCredentialsIni, TAG_KEY, "aws_secret_access_key");
            if (secretKey == null && (secretKey = this.getIniValueForSectionAndKey(awsCredentialsIni, "default", "aws_secret_access_key")) == null) {
                secretKey = this.getIniValueForSectionAndKey(awsConfigIni, "default", "aws_secret_access_key");
            }
            if (secretKey != null) {
                envVars.put(ENVVAR_AWS_SECRET_ACCESS_KEY, EnvVarValue.asIs(secretKey));
            }
        }
    }

    private String getIniValueForSectionAndKey(Wini wini, String section, String key) {
        if (wini == null) {
            return null;
        }
        return wini.get((Object)section, key);
    }

    protected abstract File getTmpDiskFile(File var1);

    protected abstract I startAndTagInstance(InstanceId var1, File var2, Image var3, DiskImage var4, LaunchSettings var5, Map<PortName, Port> var6, Map<EnvVarName, EnvVarValue> var7, Logs var8, Date var9);

    protected File createEnvironmentIso(File instanceDir, EnvironmentScript environmentScript) {
        try {
            ISO9660File iso9660File = new ISO9660File((DataReference)new ByteArrayDataReference(environmentScript.getScriptAsBytes()), "initenv.sh", new Date().getTime());
            ISO9660RootDirectory iso9660RootDirectory = new ISO9660RootDirectory();
            iso9660RootDirectory.addFile(iso9660File);
            ISO9660Config iso9660Config = new ISO9660Config();
            iso9660Config.setVolumeID("boxfuse Instance Environment");
            File environmentIsoFile = this.getEnvironmentIsoFile(instanceDir);
            CreateISO iso = new CreateISO((StreamHandler)new ISOImageFileHandler(environmentIsoFile), iso9660RootDirectory);
            iso.process(iso9660Config, null, null, null);
            return environmentIsoFile;
        }
        catch (ConfigException | HandlerException | FileNotFoundException e) {
            throw new BoxfuseBugException("Unable to create Environment ISO", e);
        }
    }

    public File getEnvironmentIsoFile(File instanceDir) {
        return new File(instanceDir.getAbsolutePath(), "environment.iso");
    }

    protected abstract InstanceId generateInstanceId();

    public abstract boolean isHealthy();

    protected final File getInstanceDir(InstanceId instanceId) {
        return new File(this.workDir, instanceId.getId());
    }

    @Override
    protected void doDestroyInstances(List<Instance> instances) {
        for (Instance instance : instances) {
            instance.destroy();
        }
    }

    protected static String encodeMetadata(InstanceMetadata tags) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            String json = objectMapper.writeValueAsString(tags);
            return DatatypeConverter.printBase64Binary((byte[])json.getBytes(Charset.forName("UTF-8")));
        }
        catch (JsonProcessingException e) {
            throw new BoxfuseBugException("Unable to encode tags: " + tags, e);
        }
    }

    protected static InstanceMetadata decodeMetadata(String encodedTags) {
        try {
            String json = new String(DatatypeConverter.parseBase64Binary((String)encodedTags), Charset.forName("UTF-8"));
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return objectMapper.readValue(json, InstanceMetadata.class);
        }
        catch (Exception e) {
            LOGGER.debug("Unable to decode metadata: " + encodedTags, (Throwable)e);
            return null;
        }
    }

    public abstract void ensureHealthy();

    public abstract boolean needsDevAgent();

    protected abstract boolean vmExists(String var1);

    public void deleteVmDir(String vmName) {
        File vmDir = new File(this.workDir, vmName);
        if (vmDir.exists()) {
            ShellUtils.deleteDir(vmDir);
        }
    }
}

