/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.platform.local.hyperv;

import com.boxfuse.base.logs.Logs;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.types.IpAddress;
import com.boxfuse.base.types.Path;
import com.boxfuse.base.util.ShellUtils;
import com.boxfuse.client.core.internal.diskimage.DiskImage;
import com.boxfuse.client.core.internal.platform.AbstractInstance;
import com.boxfuse.client.core.internal.platform.local.hyperv.HyperVPlatform;
import com.boxfuse.generator.config.CpuCount;
import com.boxfuse.generator.config.InstanceId;
import com.boxfuse.generator.config.RamMB;
import com.boxfuse.generator.image.Image;
import java.io.File;
import java.util.Date;
import java.util.Map;

public class HyperVInstance
extends AbstractInstance<HyperVPlatform> {
    private final IpAddress ip;

    HyperVInstance(HyperVPlatform platform, Image image, DiskImage diskImage, InstanceId id, CpuCount cpus, RamMB ram, Date launchTime, IpAddress ip, Logs bootLogs, Logs appLogs, File workDir, Map<PortName, Port> ports, Path payloadPath) {
        super(platform, image, diskImage, id, cpus, ram, launchTime, bootLogs, appLogs, workDir, ports, payloadPath);
        this.ip = ip;
    }

    @Override
    public IpAddress getIpAddress() {
        return this.ip;
    }

    @Override
    public void destroy() {
        HyperVPlatform.execHyperVPowerShellCommand("Stop-VM -Name " + this.id + " -TurnOff");
        HyperVPlatform.execHyperVPowerShellCommand("Remove-VM -Name " + this.id + " -Force");
        ShellUtils.deleteFile(((HyperVPlatform)this.platform).getEnvironmentIsoFile(this.workDir));
        ShellUtils.deleteFile(((HyperVPlatform)this.platform).getTmpDiskFile(this.workDir));
        ShellUtils.deleteFile(this.diskImage.getMainFile());
    }
}

