/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.platform.local.virtualbox;

import com.boxfuse.base.coordinates.AppCoordinates;
import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.Protocol;
import com.boxfuse.base.types.IpAddress;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.ThreadUtils;
import com.boxfuse.client.core.internal.platform.DevVM;
import com.boxfuse.client.core.internal.platform.Platform;
import com.boxfuse.client.core.internal.platform.local.virtualbox.VirtualBoxPlatform;
import com.boxfuse.client.core.internal.platform.local.virtualbox.VirtualBoxVmInfo;
import com.boxfuse.generator.config.CpuCount;
import com.boxfuse.generator.config.RamMB;
import com.boxfuse.generator.inventory.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualBoxDevVM
implements DevVM {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualBoxDevVM.class);
    private final VirtualBoxPlatform platform;
    private final Component devHddComponent;
    private final AppCoordinates appCoordinates;
    private final DbType dbType;
    private final String vmName;
    private IpAddress ip;
    private Map<DbType, Port> services = new HashMap<DbType, Port>();

    VirtualBoxDevVM(VirtualBoxPlatform platform, Component devHddComponent, AppCoordinates appCoordinates, DbType dbType) {
        this.platform = platform;
        this.devHddComponent = devHddComponent;
        this.appCoordinates = appCoordinates;
        this.dbType = dbType;
        this.vmName = (Object)((Object)this.devHddComponent.getId()) + "-" + this.devHddComponent.getVersion() + "_" + this.appCoordinates.getOwner() + "-" + this.appCoordinates.getName();
    }

    @Override
    public IpAddress getInstanceAccessibleIpAddress() {
        if (this.platform.isNatNetwork()) {
            return this.ip;
        }
        return IpAddress.of("10.0.2.2");
    }

    @Override
    public Port getLocalPort(DbType dbType) {
        return this.services.get((Object)dbType);
    }

    @Override
    public Port getInstancePort(DbType dbType) {
        if (this.platform.isNatNetwork()) {
            return dbType.getPort();
        }
        return this.services.get((Object)dbType);
    }

    @Override
    public void createOrStart() {
        if (this.platform.vmExists(this.vmName)) {
            VirtualBoxVmInfo vmInfo = this.platform.getVMInfo(this.vmName);
            if (!new File(vmInfo.getCfgFile()).canRead() || !new File(vmInfo.getDiskFile()).canRead()) {
                this.destroy();
                this.create();
            }
        } else {
            this.create();
        }
        Port dbPort = null;
        VirtualBoxVmInfo vmInfo = this.platform.getVMInfo(this.vmName);
        if (!this.isRunning()) {
            if (this.platform.isNatNetwork()) {
                this.platform.discardObsoleteNatNetworkPortForwardingRules();
            } else {
                for (String service : vmInfo.forwardedServices()) {
                    this.platform.clearNatForwardedPort(this.vmName, service);
                }
            }
            LOGGER.info("Starting Boxfuse Dev VM for " + this.appCoordinates + " ...");
            if (!new File(vmInfo.getDiskFile()).setWritable(true)) {
                LOGGER.warn("Unable to make Dev VM HDD writable");
            }
            this.platform.startVM(this.vmName, false);
            while (this.ip == null) {
                try {
                    this.ip = this.platform.getVmIpUsingGuestProperty(this.vmName);
                }
                catch (Exception e) {
                    ThreadUtils.sleep(500L);
                }
            }
        } else {
            this.ip = this.platform.getVmIpUsingGuestProperty(this.vmName);
            dbPort = this.platform.isNatNetwork() ? this.platform.getNatNetworkForwardedPort(this.ip, this.dbType.getPort()) : vmInfo.getNatForwardedPort(this.dbType.getName());
        }
        if (dbPort == null) {
            dbPort = this.forwardDbPort(this.vmName, this.ip, this.dbType);
        }
        this.services.put(this.dbType, dbPort);
    }

    private Port forwardDbPort(String vmName, IpAddress ip, DbType dbType) {
        Collection<Port> assignedPorts = this.platform.isNatNetwork() ? this.platform.getUnusableLocalPorts() : new ArrayList();
        Port localPort = Port.findFreePort(dbType.getPort().getNumber(), Protocol.TCP, assignedPorts);
        LOGGER.info("Exposing Dev VM " + dbType.getDescription() + " port on localhost:" + localPort.getNumber());
        if (this.platform.isNatNetwork()) {
            this.platform.forwardNatNetworkPort("boxfuse-devvm-" + this.appCoordinates.getName(), dbType.getName(), ip, dbType.getPort(), localPort);
        } else {
            this.platform.forwardNatPort(vmName, dbType.getName(), dbType.getPort(), localPort);
        }
        return localPort;
    }

    private void create() {
        LOGGER.info("Creating Boxfuse Dev VM for " + this.appCoordinates + " ...");
        String vmDescription = "Boxfuse Dev VM (" + this.devHddComponent.getVersion() + ") for " + this.appCoordinates;
        this.platform.deleteVmDir(this.vmName);
        this.platform.createVM(this.vmName, vmDescription, CpuCount.of(2), RamMB.of(1024), false);
        String storageCtlName = this.platform.computeStorageCtlName(this.vmName);
        this.platform.createStorageController(this.vmName, 1);
        File medium = this.platform.computeHddFile(this.vmName);
        IOUtils.copy(new File(this.devHddComponent.getFile().getAbsolutePath().replace(".xz", "")), medium);
        this.platform.updateHddUuid(medium);
        this.platform.attachHdd(this.vmName, storageCtlName, medium, 0);
    }

    @Override
    public void stop() {
        List<String> runningVMs = this.platform.getRunningVMs();
        if (runningVMs.contains(this.vmName)) {
            LOGGER.info("Shutting down Boxfuse Dev VM for " + this.appCoordinates + " ...");
            this.platform.killVM(this.vmName);
        }
        if (this.platform.isNatNetwork()) {
            this.platform.discardObsoleteNatNetworkPortForwardingRules();
        }
    }

    @Override
    public boolean isRunning() {
        return this.platform.getRunningVMs().contains(this.vmName);
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public void destroy() {
        this.stop();
        if (this.platform.vmExists(this.vmName)) {
            LOGGER.info("Destroying Boxfuse Dev VM for " + this.appCoordinates + " ...");
            String storageCtlName = this.platform.computeStorageCtlName(this.vmName);
            this.platform.closeAndDeleteHdd(this.vmName, storageCtlName, this.platform.computeHddFile(this.vmName), 0);
            this.platform.destroyVM(this.vmName);
        }
        if (this.platform.isNatNetwork()) {
            this.platform.discardObsoleteNatNetworkPortForwardingRules();
        }
    }
}

