/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.platform.local.virtualbox;

import com.boxfuse.base.exception.BoxfuseBugException;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public class VirtualBoxVmInfo {
    private final Properties props = new Properties();
    private final String info;

    public VirtualBoxVmInfo(String info) {
        this.info = info;
        try {
            String infoCleaned = info.replace("\\", "/").replace("//", "/").replace("\r", "");
            for (String property : StringUtils.tokenizeToStringArray(infoCleaned, "\n")) {
                int cut = property.indexOf("=");
                if (cut <= 0) continue;
                this.props.put(property.substring(0, cut), property.substring(cut + 1));
            }
        }
        catch (Exception e) {
            throw new BoxfuseBugException("Unable to read VirtualBox VM info: " + info, e);
        }
    }

    public Collection<String> forwardedServices() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
            if (!((String)entry.getKey()).startsWith("Forwarding(")) continue;
            result.add(this.toService(StringUtils.tokenizeToStringArray((String)entry.getValue(), ",")[0]));
        }
        return result;
    }

    public Port getNatForwardedPort(String service) {
        for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
            String[] tokens;
            if (!((String)entry.getKey()).startsWith("Forwarding(") || !service.equals(this.toService((tokens = StringUtils.tokenizeToStringArray((String)entry.getValue(), ","))[0]))) continue;
            return Port.of(tokens[3]);
        }
        return null;
    }

    private String toService(String forwardingRule) {
        String service = forwardingRule;
        if (service.startsWith("\"")) {
            service = service.substring(1);
        }
        return service;
    }

    public String getCfgFile() {
        return this.getValue("CfgFile");
    }

    private String getValue(String key) {
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new BoxfuseException("Invalid VirtualBox VM info (missing " + key + "): " + this.info);
        }
        return this.stripQuotes(value);
    }

    public String getDiskFile() {
        String storageControllerName = this.getValue("storagecontrollername0");
        return this.getValue("\"" + storageControllerName + "-0-0\"");
    }

    private String stripQuotes(String str) {
        if (str.startsWith("\"")) {
            str = str.substring(1);
        }
        if (str.endsWith("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

