/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.privateuse.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class ClassUtils {
    private ClassUtils() {
    }

    public static synchronized <T> T instantiate(String className) throws Exception {
        return (T)Class.forName(className, true, ClassUtils.getClassLoader()).newInstance();
    }

    private static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static boolean isPresent(String className) {
        try {
            ClassUtils.getClassLoader().loadClass(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static String getShortName(Class<?> aClass) {
        String name = aClass.getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public static String getLocationOnDisk(Class<?> aClass) {
        try {
            String url = aClass.getProtectionDomain().getCodeSource().getLocation().getPath();
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

