/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.app;

import com.boxfuse.base.coordinates.AppCoordinates;
import com.boxfuse.base.enums.AppType;
import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.LogsType;
import com.boxfuse.base.enums.TlsType;
import com.boxfuse.base.types.Version;
import java.util.SortedMap;

public class App {
    private final AppCoordinates coordinates;
    private final AppType appType;
    private final DbType dbType;
    private final LogsType logsType;
    private final TlsType tlsType;
    private final SortedMap<Version, Integer> images;

    public App(AppCoordinates coordinates, AppType appType, DbType dbType, LogsType logsType, TlsType tlsType, SortedMap<Version, Integer> vaultImages) {
        this.coordinates = coordinates;
        this.appType = appType;
        this.dbType = dbType;
        this.logsType = logsType;
        this.tlsType = tlsType;
        this.images = vaultImages;
    }

    public AppCoordinates getCoordinates() {
        return this.coordinates;
    }

    public AppType getAppType() {
        return this.appType;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public LogsType getLogsType() {
        return this.logsType;
    }

    public TlsType getTlsType() {
        return this.tlsType;
    }

    public SortedMap<Version, Integer> getImages() {
        return this.images;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        App app = (App)o;
        if (!this.coordinates.equals(app.coordinates)) {
            return false;
        }
        if (this.appType != app.appType) {
            return false;
        }
        if (this.dbType != app.dbType) {
            return false;
        }
        if (this.logsType != app.logsType) {
            return false;
        }
        if (this.tlsType != app.tlsType) {
            return false;
        }
        return this.images.equals(app.images);
    }

    public int hashCode() {
        int result = this.coordinates.hashCode();
        result = 31 * result + this.appType.hashCode();
        result = 31 * result + this.dbType.hashCode();
        result = 31 * result + this.logsType.hashCode();
        result = 31 * result + this.tlsType.hashCode();
        result = 31 * result + this.images.hashCode();
        return result;
    }
}

