/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ImageBuilder {
    public void build(String id, byte[] metadata, InputStream virtualDisk, long compressedSize, long crc32, byte[] signature, OutputStream output) {
        ZipOutputStream zOut = null;
        try {
            zOut = new ZipOutputStream(output);
            zOut.setMethod(8);
            ZipEntry entry = new ZipEntry(id + ".manifest");
            entry.setSize(metadata.length);
            zOut.putNextEntry(entry);
            IOUtils.copyNoClose(new ByteArrayInputStream(metadata), (OutputStream)zOut);
            zOut.closeEntry();
            ZipEntry entry1 = new ZipEntry(id + ".disk.gz");
            entry1.setSize(compressedSize);
            entry1.setCompressedSize(compressedSize);
            entry1.setCrc(crc32);
            entry1.setMethod(0);
            zOut.putNextEntry(entry1);
            IOUtils.copyNoClose(virtualDisk, zOut, 8092);
            zOut.closeEntry();
            ZipEntry entry2 = new ZipEntry(id + ".sig");
            entry2.setSize(signature.length);
            zOut.putNextEntry(entry2);
            IOUtils.copyNoClose(new ByteArrayInputStream(signature), (OutputStream)zOut);
            zOut.closeEntry();
        }
        catch (IOException e) {
            throw new BoxfuseException("Unable to fuse Image: " + e.getMessage());
        }
        finally {
            IOUtils.close(virtualDisk);
            IOUtils.close(zOut);
        }
    }
}

