/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk;

import com.boxfuse.base.enums.AppType;
import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.LogsType;
import com.boxfuse.base.env.EnvVarName;
import com.boxfuse.base.env.EnvVarValue;
import com.boxfuse.base.env.EnvironmentScript;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.port.Protocol;
import com.boxfuse.base.types.ComponentId;
import com.boxfuse.base.types.Pair;
import com.boxfuse.base.types.Path;
import com.boxfuse.base.types.Version;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.base.util.Template;
import com.boxfuse.generator.builder.certificate.CertificateManager;
import com.boxfuse.generator.builder.ramdisk.RamDisk;
import com.boxfuse.generator.builder.ramdisk.RamDiskPayload;
import com.boxfuse.generator.config.BoxfuseConfig;
import com.boxfuse.generator.image.ImageSpecImpl;
import com.boxfuse.generator.image.spec.ImageSpecValidator;
import com.boxfuse.generator.inventory.Component;
import com.boxfuse.generator.inventory.Inventory;
import com.boxfuse.generator.payload.Payload;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RamDiskBuilder<P extends RamDiskPayload> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RamDiskBuilder.class);
    private static final String ETC_SYSCTL_CONF = "etc/sysctl.conf";
    private static final List<PortName> PREFERRED_PAYLOAD_PORT_NAMES = Arrays.asList(PortName.HTTPS, PortName.HTTP);
    private static final List<PortName> PREFERRED_HEALTHCHECK_PORT_NAMES = Arrays.asList(PortName.ADMIN_HTTPS, PortName.ADMIN_HTTP, PortName.HTTPS, PortName.HTTP);
    private String id;
    protected final ImageSpecImpl spec;
    protected RamDisk ramDisk;
    private final Component glibc;
    private final Component libgcc;
    private final Component busybox;
    private final Component cacerts;
    private final Component strace;
    private final Component vboxsf;
    private Component newrelic_sysmond;
    protected final Collection<Component> components = new ArrayList<Component>();
    protected final CertificateManager certificateManager;
    protected final Inventory inventory;
    protected final P payload;
    protected boolean messagesDisplayed;

    public RamDiskBuilder(CertificateManager certificateManager, Inventory inventory, ImageSpecImpl spec, Collection<Component> virtualDiskComponents) {
        this.certificateManager = certificateManager;
        this.inventory = inventory;
        this.spec = spec;
        this.payload = (RamDiskPayload)spec.getPayload();
        this.components.addAll(virtualDiskComponents);
        this.glibc = this.getComponent(ComponentId.GLIBC);
        this.libgcc = this.getComponent(ComponentId.LIBGCC);
        this.busybox = this.getComponent(ComponentId.BUSYBOX);
        this.cacerts = this.getComponent(ComponentId.CACERTS);
        this.vboxsf = this.getComponent(ComponentId.VBOXSF);
        this.components.addAll(Arrays.asList(this.glibc, this.libgcc, this.busybox, this.cacerts, this.vboxsf));
        if (spec.isStrace()) {
            this.strace = this.getComponent(ComponentId.STRACE);
            this.components.add(this.strace);
        } else {
            this.strace = null;
        }
    }

    protected final Component getComponent(ComponentId componentId) {
        if (this.spec.getComponents().containsKey((Object)componentId)) {
            return this.inventory.get(componentId, this.spec.getComponents().get((Object)componentId));
        }
        for (Map.Entry<ComponentId, Version> entry : this.spec.getComponents().entrySet()) {
            if (!entry.getKey().getOverridenComponents().contains((Object)componentId)) continue;
            return this.inventory.get(entry.getKey(), entry.getValue());
        }
        return this.inventory.get(componentId, null);
    }

    public final String getId() {
        return this.id;
    }

    public final Collection<Component> getComponents() {
        return this.components;
    }

    public final void adjustSpecBasedOnConfig() {
        PortName healthcheckPort;
        PortName payloadPort;
        this.doAdjustSpecBasedOnConfig();
        if (this.spec.getDbType() == null) {
            DbType dbType = this.detectDbType();
            this.spec.setDbType(dbType);
            if (DbType.NONE != dbType && !this.messagesDisplayed) {
                LOGGER.debug("Auto-configured database to " + dbType.getName());
            }
        }
        Map<PortName, Port> ports = this.spec.getPorts();
        if (this.spec.getPayloadPort() == null && (payloadPort = this.detectPayloadPort(ports)) != null) {
            this.spec.setPayloadPort(payloadPort);
            if (!this.messagesDisplayed) {
                LOGGER.debug("Auto-configured payload port to " + payloadPort);
            }
        }
        if (this.spec.getPayloadPort() != null && !ports.containsKey(this.spec.getPayloadPort())) {
            throw new BoxfuseException("Unknown payload port: " + this.spec.getPayloadPort() + " (Should be one of: " + StringUtils.collectionToDelimitedString(ports.keySet(), ", ") + ")");
        }
        if (this.spec.getPayloadPath() == null) {
            this.spec.setPayloadPath(Path.of("/"));
        }
        if (this.spec.getHealthcheckPort() == null && (healthcheckPort = this.detectHealthcheckPort(ports)) != null) {
            this.spec.setHealthcheckPort(healthcheckPort);
            if (!this.messagesDisplayed) {
                LOGGER.debug("Auto-configured healthcheck port to " + healthcheckPort);
            }
        }
        if ((healthcheckPort = this.spec.getHealthcheckPort()) != null) {
            new ImageSpecValidator(this.spec).validateHealthcheckPort(healthcheckPort);
        } else if (this.spec.isHealthcheck()) {
            LOGGER.warn("Disabling healthcheck as no suitable healthcheck port was found");
            this.spec.setHealthcheck(false);
        }
        if (this.spec.getHealthcheckPath() == null) {
            this.spec.setHealthcheckPath(Path.of("/"));
        }
        if (this.spec.getNewRelicLicenseKey() != null) {
            this.newrelic_sysmond = this.getComponent(ComponentId.NEWRELIC_SYSMOND);
            this.components.add(this.newrelic_sysmond);
        }
        this.messagesDisplayed = true;
    }

    private PortName detectPayloadPort(Map<PortName, Port> ports) {
        for (PortName portName : PREFERRED_PAYLOAD_PORT_NAMES) {
            if (!ports.containsKey(portName)) continue;
            return portName;
        }
        for (Map.Entry entry : ports.entrySet()) {
            if (!((Port)entry.getValue()).getProtocol().equals((Object)Protocol.HTTPS)) continue;
            return (PortName)entry.getKey();
        }
        for (Map.Entry entry : ports.entrySet()) {
            if (!((Port)entry.getValue()).getProtocol().equals((Object)Protocol.HTTP)) continue;
            return (PortName)entry.getKey();
        }
        return null;
    }

    private PortName detectHealthcheckPort(Map<PortName, Port> ports) {
        for (PortName portName : PREFERRED_HEALTHCHECK_PORT_NAMES) {
            if (!ports.containsKey(portName)) continue;
            return portName;
        }
        for (Map.Entry entry : ports.entrySet()) {
            if (!((Port)entry.getValue()).getProtocol().equals((Object)Protocol.HTTPS)) continue;
            return (PortName)entry.getKey();
        }
        for (Map.Entry entry : ports.entrySet()) {
            if (!((Port)entry.getValue()).getProtocol().equals((Object)Protocol.HTTP)) continue;
            return (PortName)entry.getKey();
        }
        return null;
    }

    public final void build(String id, Date generationTime, OutputStream output) {
        this.id = id;
        try (OutputStream outputStream = output;){
            this.ramDisk = new RamDisk(outputStream, generationTime);
            this.installMountPoints();
            this.installDevices();
            this.installConfig();
            this.ramDisk.installTarGzArchive(this.glibc.getBytes(), "");
            this.ramDisk.installTarGzArchive(this.libgcc.getBytes(), "");
            this.installBusyBox();
            this.installCacerts();
            if (this.spec.isStrace()) {
                this.ramDisk.installTarGzArchive(this.strace.getBytes(), "strace");
            }
            this.ramDisk.installTarGzArchive(this.vboxsf.getBytes(), "vboxsf");
            this.ramDisk.createSymLink("sbin/mount.vboxsf", "/vboxsf/mount.vboxsf");
            this.ramDisk.createDir(".IPs");
            if (this.spec.isLive()) {
                this.ramDisk.createDir("/live");
            }
            if (LogsType.CLOUDWATCH_LOGS == this.spec.getLogsType()) {
                this.ramDisk.createFile("cloudwatchlogs-agent/cloudwatchlogs-agent", true, IOUtils.copyToByteArray("generator/cloudwatchlogs-agent/cloudwatchlogs-agent"));
                this.ramDisk.createFile("cloudwatchlogs-agent/LICENSE", true, IOUtils.copyToByteArray("generator/cloudwatchlogs-agent/LICENSE"));
            }
            if (this.spec.getNewRelicLicenseKey() != null) {
                this.installNewRelicSysmond();
            }
            this.installPayloadWithDependencies();
            this.doBuild();
            this.installNativeBinariesAndLibs();
            this.installInfo(id);
            TreeMap<EnvVarName, EnvVarValue> envVars = new TreeMap<EnvVarName, EnvVarValue>();
            this.generateEnvVars(envVars);
            this.doGenerateEnvVars(envVars);
            envVars.putAll(this.spec.getEnvVars());
            this.installInit(envVars);
        }
        catch (IOException e) {
            throw new BoxfuseException("Unable to create initrd: " + e.getMessage(), e);
        }
    }

    private void installNewRelicSysmond() throws IOException {
        this.ramDisk.createFile("newrelic/nrsysmond.cfg", false, "license_key=" + this.spec.getNewRelicLicenseKey() + "\n");
        this.ramDisk.installTarGzArchive(this.newrelic_sysmond.getBytes(), "newrelic/");
    }

    protected void doBuild() throws IOException {
    }

    protected void installNativeBinariesAndLibs() throws IOException {
    }

    protected void doAdjustSpecBasedOnConfig() {
    }

    protected DbType detectDbType() {
        return DbType.NONE;
    }

    private void generateEnvVars(Map<EnvVarName, EnvVarValue> envVars) {
        envVars.put(EnvVarName.BOXFUSE_DEBUG, EnvVarValue.asIs("" + this.spec.isDebug()));
        envVars.put(EnvVarName.BOXFUSE_DEBUG_WAIT, EnvVarValue.asIs("" + this.spec.isDebugWait()));
        envVars.put(EnvVarName.BOXFUSE_LIVE, EnvVarValue.asIs("" + this.spec.isLive()));
        for (Component component : this.getComponents()) {
            envVars.put(EnvVarName.of(component.getId()), EnvVarValue.asIs(component.getVersion().getVersion()));
        }
        Map<PortName, Port> ports = this.spec.getPorts();
        for (Map.Entry<PortName, Port> portEntry : ports.entrySet()) {
            Port port = portEntry.getValue();
            envVars.put(EnvVarName.of(portEntry.getKey()), EnvVarValue.asIs("" + port.getNumber()));
        }
        if (ports.containsKey(PortName.HTTP) && ports.containsKey(PortName.HTTPS)) {
            envVars.put(EnvVarName.BOXFUSE_PORTS_HTTPS__REDIRECT, EnvVarValue.asIs("" + ports.get(PortName.HTTPS).getNumber()));
        }
        if (ports.containsKey(PortName.ADMIN_HTTP) && ports.containsKey(PortName.ADMIN_HTTPS)) {
            envVars.put(EnvVarName.BOXFUSE_PORTS_ADMIN_HTTPS__REDIRECT, EnvVarValue.asIs("" + ports.get(PortName.ADMIN_HTTPS).getNumber()));
        }
        envVars.put(EnvVarName.BOXFUSE_VERSION, EnvVarValue.asIs(BoxfuseConfig.VERSION.getVersion()));
        envVars.put(EnvVarName.BOXFUSE_ACCOUNT, EnvVarValue.asIs(this.spec.getCoordinates().getOwner().getOwner()));
        envVars.put(EnvVarName.BOXFUSE_APP, EnvVarValue.asIs(this.spec.getCoordinates().getName().getName()));
        envVars.put(EnvVarName.BOXFUSE_IMAGE_ID, EnvVarValue.asIs(this.id));
        envVars.put(EnvVarName.BOXFUSE_IMAGE_COORDINATES, EnvVarValue.asIs(this.spec.getCoordinates().toString()));
        envVars.put(EnvVarName.BOXFUSE_IMAGE_VERSION, EnvVarValue.asIs(this.spec.getCoordinates().getVersion().getVersion()));
        envVars.put(EnvVarName.BOXFUSE_TMP, EnvVarValue.asIs("" + this.spec.getTmp()));
        envVars.put(EnvVarName.BOXFUSE_PAYLOAD_NAME, EnvVarValue.asIs(this.spec.getPayload().getName()));
        envVars.put(EnvVarName.of("LD_LIBRARY_PATH"), EnvVarValue.asIs("/lib/x86_64-linux-gnu:/usr/lib/x86_64-linux-gnu" + this.extraLdLibraryPathDirs()));
        envVars.put(EnvVarName.of("PATH"), EnvVarValue.asIs("/sbin:/bin:/usr/bin" + this.extraPathDirs()));
    }

    protected String extraPathDirs() {
        return "";
    }

    protected String extraLdLibraryPathDirs() {
        return "";
    }

    protected void doGenerateEnvVars(Map<EnvVarName, EnvVarValue> envVars) {
    }

    protected final void autoConfigurePorts(Map<PortName, Port> ports) {
        for (Map.Entry<PortName, Port> portEntry : ports.entrySet()) {
            if (this.spec.getPorts().containsKey(portEntry.getKey())) continue;
            this.spec.getPorts().put(portEntry.getKey(), portEntry.getValue());
            if (this.messagesDisplayed) continue;
            LOGGER.debug("Auto-configured " + portEntry.getKey().getName() + " port to " + portEntry.getValue());
        }
    }

    protected abstract void installPayloadWithDependencies() throws IOException;

    private void installMountPoints() throws IOException {
        this.ramDisk.createDir("environment");
        this.ramDisk.createDir("proc");
        this.ramDisk.createDir("sys");
        this.ramDisk.createDir("tmp");
    }

    private void installConfig() throws IOException {
        this.ramDisk.createFile("etc/passwd", false, "root:x:0:0:root:/:/bin/sh");
        this.ramDisk.createFile("etc/group", false, "root:x:0:");
        this.ramDisk.createFile("etc/nsswitch.conf", false, IOUtils.copyToByteArray("generator/busybox/nsswitch.conf"));
        this.ramDisk.createFile("etc/mime.types", false, IOUtils.copyToByteArray("generator/busybox/mime.types"));
        this.ramDisk.createSymLink("etc/mtab", "/proc/mounts");
        this.ramDisk.createSymLink("etc/fstab", "/proc/mounts");
        this.createSysCtlConf();
        this.ramDisk.createFile("etc/host.conf", false, "order hosts,bind\nmulti on");
        this.ramDisk.createFile("etc/services", false, "https 443/tcp\nhttps 443/udp");
    }

    private void createSysCtlConf() throws IOException {
        Pair<String, byte[]> sysCtlConf = this.payload.getSysCtlConf();
        if (sysCtlConf == null) {
            this.ramDisk.createFile(ETC_SYSCTL_CONF, false, new byte[0]);
        } else if (sysCtlConf.getLeft() != null) {
            this.ramDisk.createSymLink(ETC_SYSCTL_CONF, this.getStartDir() + "/" + sysCtlConf.getLeft());
        } else {
            this.ramDisk.createFile(ETC_SYSCTL_CONF, false, sysCtlConf.getRight());
        }
    }

    private void installInit(Map<EnvVarName, EnvVarValue> envVars) throws IOException {
        String straceCmd = "";
        if (this.spec.isStrace()) {
            straceCmd = "/strace/strace -ftx";
        }
        this.installLaunchScript(envVars, straceCmd);
        ArrayList<String> preCmds = new ArrayList<String>();
        if (this.spec.getNewRelicLicenseKey() != null) {
            preCmds.add("/newrelic/newrelic-sysmond-*/daemon/nrsysmond.x64 -c /newrelic/nrsysmond.cfg &");
        }
        this.addAdditionalPreCmds(preCmds);
        String preCmdsStr = StringUtils.collectionToDelimitedString(preCmds, "\n");
        String supportedPlatforms = StringUtils.arrayToDelimitedString((Object[])this.spec.getPlatforms(), " ").toLowerCase();
        String exports = new EnvironmentScript(envVars).getScript();
        String launchCmd = LogsType.CLOUDWATCH_LOGS == this.spec.getLogsType() ? "{ /launch.sh 2>&1 1>&3 3>&- | /cloudwatchlogs-agent/cloudwatchlogs-agent -stderr; } 3>&1 1>&2 | /cloudwatchlogs-agent/cloudwatchlogs-agent" : "/launch.sh";
        String initScript = Template.process("generator/init.template", exports, supportedPlatforms, preCmdsStr, launchCmd);
        this.ramDisk.createFile("etc/inittab", false, IOUtils.copyToByteArray("generator/busybox/inittab"));
        this.ramDisk.createDir("etc/init.d");
        this.ramDisk.createFile("etc/init.d/rcS", true, initScript);
    }

    private void installLaunchScript(Map<EnvVarName, EnvVarValue> envVars, String straceCmd) throws IOException {
        String launchScript = this.createLaunchScript(straceCmd, envVars);
        launchScript = this.spec.getAppType() == AppType.ONE_OFF ? launchScript + "\necho \"Poweroff in 15 seconds ...\"\npoweroff -d 15\n" : launchScript + "\necho \"Rebooting in 15 seconds ...\"\nreboot -d 15\n";
        this.ramDisk.createFile("launch.sh", true, launchScript);
    }

    protected abstract String createLaunchScript(String var1, Map<EnvVarName, EnvVarValue> var2);

    protected void addAdditionalPreCmds(List<String> preCmds) {
    }

    protected void putIfAbsent(Map<EnvVarName, EnvVarValue> envVars, EnvVarName key, EnvVarValue value) {
        if (envVars.get(key) == null) {
            envVars.put(key, value);
        }
    }

    private void installInfo(String jobId) throws IOException {
        Payload payload = this.spec.getPayload();
        String payloadDetails = this.spec.isLive() ? "Live Mount  : " + payload.getFile().getAbsolutePath() : "Checksum    : " + StringUtils.intToHex(payload.getChecksum());
        String infoTxt = Template.process("generator/info.template", new Object[]{payload.getName(), payload.getType(), payloadDetails, jobId, this.spec.getCoordinates(), this.spec.isDebug(), this.spec.isStrace(), StringUtils.mapToDelimitedString(this.spec.getPorts(), ", ")});
        this.ramDisk.createFile("info.txt", false, "\n" + infoTxt + "\n");
    }

    protected abstract String getStartDir();

    protected void installCacerts() throws IOException {
        this.ramDisk.installTarGzArchive(this.cacerts.getBytes(), "cacerts/");
        this.ramDisk.createSymLink("etc/ssl/certs/ca-certificates.crt", "/cacerts/ca-certificates.crt");
    }

    private void installBusyBox() throws IOException {
        this.ramDisk.installTarGzArchive(this.busybox.getBytes(), "busybox/");
        String destination = "/busybox/busybox";
        this.ramDisk.createSymLink("init", destination);
        this.ramDisk.createSymLink("bin/acpid", destination);
        this.ramDisk.createSymLink("bin/bash", destination);
        this.ramDisk.createSymLink("bin/cat", destination);
        this.ramDisk.createSymLink("bin/cut", destination);
        this.ramDisk.createSymLink("bin/date", destination);
        this.ramDisk.createSymLink("bin/expr", destination);
        this.ramDisk.createSymLink("bin/free", destination);
        this.ramDisk.createSymLink("bin/grep", destination);
        this.ramDisk.createSymLink("bin/hostname", destination);
        this.ramDisk.createSymLink("bin/kill", destination);
        this.ramDisk.createSymLink("bin/killall", destination);
        this.ramDisk.createSymLink("bin/killall5", destination);
        this.ramDisk.createSymLink("bin/mdev", destination);
        this.ramDisk.createSymLink("bin/mke2fs", destination);
        this.ramDisk.createSymLink("bin/ls", destination);
        this.ramDisk.createSymLink("bin/mkfifo", destination);
        this.ramDisk.createSymLink("bin/mknod", destination);
        this.ramDisk.createSymLink("bin/mount", destination);
        this.ramDisk.createSymLink("bin/ntpd", destination);
        this.ramDisk.createSymLink("bin/pwd", destination);
        this.ramDisk.createSymLink("bin/sh", destination);
        this.ramDisk.createSymLink("bin/sleep", destination);
        this.ramDisk.createSymLink("bin/sort", destination);
        this.ramDisk.createSymLink("bin/tr", destination);
        this.ramDisk.createSymLink("bin/udhcpc", destination);
        this.ramDisk.createFile("bin/udhcpc.script", true, IOUtils.copyToByteArray("generator/busybox/udhcpc.script"));
        this.ramDisk.createSymLink("bin/uname", destination);
        this.ramDisk.createSymLink("bin/wget", destination);
        this.ramDisk.createSymLink("sbin/ifconfig", destination);
        this.ramDisk.createSymLink("sbin/insmod", destination);
        this.ramDisk.createSymLink("sbin/poweroff", destination);
        this.ramDisk.createSymLink("sbin/route", destination);
        this.ramDisk.createSymLink("sbin/reboot", destination);
        this.ramDisk.createSymLink("sbin/sysctl", destination);
        this.ramDisk.createSymLink("usr/bin/dirname", destination);
        this.ramDisk.createSymLink("usr/bin/env", destination);
        this.ramDisk.createFile("etc/acpid.conf", false, "PWRF poweroff\nPWRB reboot\n");
        this.ramDisk.createSymLink("etc/acpi/poweroff", "/sbin/poweroff");
        this.ramDisk.createSymLink("etc/acpi/reboot", "/sbin/reboot");
    }

    private void installDevices() throws IOException {
        this.ramDisk.createDir("dev");
        this.ramDisk.createCharacterDevice("dev/null", 1, 3);
        this.ramDisk.createCharacterDevice("dev/random", 1, 8);
        this.ramDisk.createCharacterDevice("dev/urandom", 1, 9);
        this.ramDisk.createCharacterDevice("dev/tty0", 4, 0);
        this.ramDisk.createCharacterDevice("dev/tty", 5, 0);
        this.ramDisk.createCharacterDevice("dev/console", 5, 1);
        this.ramDisk.createBlockDevice("dev/hdb", 3, 64);
        this.ramDisk.createBlockDevice("dev/hdc", 22, 0);
        this.ramDisk.createBlockDevice("dev/scd0", 11, 0);
        this.ramDisk.createBlockDevice("dev/sdb", 8, 16);
        this.ramDisk.createSymLink("dev/stdin", "/proc/self/fd/0");
        this.ramDisk.createSymLink("dev/stdout", "/proc/self/fd/1");
        this.ramDisk.createSymLink("dev/stderr", "/proc/self/fd/2");
        this.ramDisk.createBlockDevice("dev/xvdb", 202, 16);
        this.ramDisk.createBlockDevice("dev/xvdc", 202, 32);
        this.ramDisk.createBlockDevice("dev/xvdd", 202, 48);
        this.ramDisk.createBlockDevice("dev/xvde", 202, 64);
        this.ramDisk.createBlockDevice("dev/xvdf", 202, 80);
        this.ramDisk.createBlockDevice("dev/xvdg", 202, 96);
        this.ramDisk.createBlockDevice("dev/xvdh", 202, 112);
        this.ramDisk.createBlockDevice("dev/xvdi", 202, 128);
        this.ramDisk.createBlockDevice("dev/xvdj", 202, 144);
        this.ramDisk.createBlockDevice("dev/xvdk", 202, 160);
        this.ramDisk.createBlockDevice("dev/xvdl", 202, 176);
        this.ramDisk.createBlockDevice("dev/xvdm", 202, 192);
        this.ramDisk.createBlockDevice("dev/xvdn", 202, 208);
        this.ramDisk.createBlockDevice("dev/xvdo", 202, 224);
        this.ramDisk.createBlockDevice("dev/xvdp", 202, 240);
        this.ramDisk.createDir("dev/input");
        this.ramDisk.createCharacterDevice("dev/input/event0", 13, 64);
        this.ramDisk.createCharacterDevice("dev/input/event1", 13, 65);
    }
}

