/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.generic.go.revel;

import com.boxfuse.base.payload.PayloadEntry;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.types.Pair;
import com.boxfuse.base.util.OSUtils;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.base.util.ZipUtils;
import com.boxfuse.generator.builder.ramdisk.RamDisk;
import com.boxfuse.generator.builder.ramdisk.generic.go.revel.RevelPayload;
import com.boxfuse.generator.payload.FilePayload;
import com.boxfuse.generator.payload.PayloadFormat;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;

public class RevelTarGzPayload
extends FilePayload
implements RevelPayload {
    public static boolean supports(String name, PayloadFormat format, Map<String, PayloadEntry> entries, boolean live) {
        return name.endsWith(".tar.gz") && PayloadFormat.TARGZ == format && entries.keySet().contains("run.sh") && entries.keySet().contains(name.substring(0, name.indexOf(".tar.gz"))) && !live;
    }

    public RevelTarGzPayload(File file, byte[] bytes, Map<String, PayloadEntry> entries) {
        super(file, bytes, entries);
    }

    @Override
    public Pair<String, byte[]> getSysCtlConf() {
        String entryName = StringUtils.findFirstMatching(this.entries.keySet(), ".*/" + Pattern.quote(this.name.substring(0, this.name.indexOf(".tar.gz"))) + "/conf/sysctl.conf");
        if (entryName == null && (entryName = StringUtils.findFirstMatching(this.entries.keySet(), ".*\\\\" + Pattern.quote(this.name.substring(0, this.name.indexOf(".tar.gz"))) + "\\\\conf\\\\sysctl.conf")) == null) {
            return null;
        }
        return Pair.of(entryName, null);
    }

    @Override
    public void installInto(RamDisk ramDisk, String baseDir) throws IOException {
        ramDisk.installTarGzArchive(this.bytes, baseDir, "", OSUtils.runningOnWindows());
    }

    @Override
    public PayloadType getType() {
        return PayloadType.REVEL;
    }

    @Override
    public String getAppConf() {
        String entryName = StringUtils.findFirstMatching(this.entries.keySet(), ".*/" + Pattern.quote(this.name.substring(0, this.name.indexOf(".tar.gz"))) + "/conf/app.conf");
        if (entryName == null && (entryName = StringUtils.findFirstMatching(this.entries.keySet(), ".*\\\\" + Pattern.quote(this.name.substring(0, this.name.indexOf(".tar.gz"))) + "\\\\conf\\\\app.conf")) == null) {
            return null;
        }
        return ZipUtils.untarGzSingleEntryToString(this.bytes, entryName);
    }

    @Override
    public String getCmd() {
        return "run.sh";
    }
}

