/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.nodejs;

import com.boxfuse.base.coordinates.AppName;
import com.boxfuse.base.payload.PayloadEntry;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.types.Pair;
import com.boxfuse.base.types.Version;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.generator.builder.ramdisk.RamDisk;
import com.boxfuse.generator.builder.ramdisk.nodejs.NodeJsConfig;
import com.boxfuse.generator.builder.ramdisk.nodejs.NodeJsPayload;
import com.boxfuse.generator.payload.DirectoryPayload;
import com.boxfuse.generator.payload.PayloadFormat;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeJsDirectoryPayload
extends DirectoryPayload
implements NodeJsPayload {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeJsDirectoryPayload.class);
    private static final String SYSCTL_CONF = "sysctl.conf";
    private final NodeJsConfig nodeJsConfig;

    public static boolean supports(PayloadFormat format, File dir, Map<String, PayloadEntry> entries) {
        return PayloadFormat.DIRECTORY == format && entries.keySet().contains("package.json") && (!entries.keySet().contains(".yo-rc.json") || !IOUtils.copyToString(new File(dir, ".yo-rc.json")).contains("generator-jhipster"));
    }

    public NodeJsDirectoryPayload(File directory, long payloadSize, Map<String, PayloadEntry> entries, boolean live) {
        super(directory, payloadSize, entries, live);
        String packageJson = IOUtils.copyToString(new File(this.file, "package.json"));
        String npmShrinkwrapJson = IOUtils.copyToString(new File(this.file, "npm-shrinkwrap.json"));
        this.nodeJsConfig = new NodeJsConfig(packageJson, npmShrinkwrapJson);
    }

    @Override
    public PayloadType getType() {
        return PayloadType.NODEJS;
    }

    @Override
    public Pair<String, byte[]> getSysCtlConf() {
        if (this.entries.keySet().contains(SYSCTL_CONF)) {
            return Pair.of(SYSCTL_CONF, null);
        }
        return null;
    }

    @Override
    public String getNodeExecutable() {
        return this.live ? "node-supervisor -t -s -k -e js,json" : "node";
    }

    @Override
    public NodeJsConfig getNodeJsConfig() {
        return this.nodeJsConfig;
    }

    @Override
    public void installInto(RamDisk ramDisk, String baseDir) throws IOException {
        if (this.live) {
            ramDisk.installTarGzArchive(IOUtils.copyToByteArray("generator/node-supervisor.tar.gz"), "node-supervisor");
            ramDisk.createSymLink("usr/bin/node-supervisor", "/node-supervisor/cli-wrapper.js");
            ramDisk.createSymLink(baseDir, "/live");
        } else {
            ramDisk.installDirectory(this.file, baseDir, true);
        }
    }

    @Override
    public AppName extractAppName() {
        AppName name = this.nodeJsConfig.getName();
        if (name != null) {
            return name;
        }
        return super.extractAppName();
    }

    @Override
    public Version extractVersion(boolean fallback) {
        Version version = this.nodeJsConfig.getVersion();
        if (version != null) {
            LOGGER.debug("Detected version in package.json: " + version);
            return version;
        }
        return super.extractVersion(fallback);
    }
}

