/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.config;

import com.boxfuse.base.exception.BoxfuseException;

public final class InstanceId
implements Comparable<InstanceId> {
    private final String id;

    public InstanceId(String id) {
        if (!InstanceId.isValid(id)) {
            throw new BoxfuseException("Invalid instance id: " + id + "\n=> ensure it is in one of these formats: vb-abcd1234, i-abcd1234, i-abcd1234efab56789");
        }
        this.id = id;
    }

    public static boolean isValid(String id) {
        return id.matches("(vb|hv|i)-[0-9a-f]+");
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceId that = (InstanceId)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public int compareTo(InstanceId o) {
        return this.id.compareTo(o.id);
    }
}

