/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660.impl;

import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.Element;
import com.github.stephenc.javaisotools.sabre.Fixup;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import com.github.stephenc.javaisotools.sabre.impl.FileFixup;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class ISOImageFileHandler
implements StreamHandler {
    private File file = null;
    private RandomAccessFile raFile = null;
    private DataOutputStream dataOutputStream = null;
    private long position = 0L;

    public ISOImageFileHandler(File file) throws FileNotFoundException {
        this.file = file;
        this.raFile = new RandomAccessFile(file, "rw");
        this.dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)));
    }

    public void startDocument() throws HandlerException {
    }

    public void startElement(Element element) throws HandlerException {
    }

    public void data(DataReference reference) throws HandlerException {
        InputStream inputStream = null;
        byte[] buffer = null;
        int bytesToRead = 0;
        int bytesHandled = 0;
        int bufferLength = 65535;
        long lengthToWrite = 0L;
        long length = 0L;
        try {
            buffer = new byte[bufferLength];
            lengthToWrite = length = reference.getLength();
            inputStream = reference.createInputStream();
            while (lengthToWrite > 0L) {
                bytesToRead = lengthToWrite > (long)bufferLength ? bufferLength : (int)lengthToWrite;
                bytesHandled = inputStream.read(buffer, 0, bytesToRead);
                if (bytesHandled == -1) {
                    throw new HandlerException("Cannot read all data from reference.");
                }
                this.dataOutputStream.write(buffer, 0, bytesHandled);
                lengthToWrite -= (long)bytesHandled;
                this.position += (long)bytesHandled;
            }
            this.dataOutputStream.flush();
        }
        catch (IOException e) {
            throw new HandlerException((Exception)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
            }
            catch (IOException e) {}
        }
    }

    public Fixup fixup(DataReference reference) throws HandlerException {
        FileFixup fixup = null;
        fixup = new FileFixup(this.raFile, this.position, reference.getLength());
        this.data(reference);
        return fixup;
    }

    public long mark() throws HandlerException {
        return this.position;
    }

    public void endElement() throws HandlerException {
    }

    public void endDocument() throws HandlerException {
        try {
            this.raFile.close();
            this.dataOutputStream.close();
        }
        catch (IOException e) {
            throw new HandlerException((Exception)e);
        }
    }
}

