/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.fsimage;

import com.boxfuse.base.fsimage.FsFile;
import com.boxfuse.base.fsimage.FsFileMode;
import com.boxfuse.base.fsimage.FsFileType;
import com.boxfuse.base.fsimage.FsPath;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\u0003\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003J*\u0010\u0004\u001a\u00020\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00002\b\b\u0002\u0010\b\u001a\u00020\tH\u0016J7\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H&\u00a2\u0006\u0002\u0010\u0013J7\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H&\u00a2\u0006\u0002\u0010\u0013J'\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H&\u00a2\u0006\u0002\u0010\u0016J'\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H&\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u0002H\u0002J\u0015\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001cJ/\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010 J5\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020\u0012H&\u00a2\u0006\u0002\u0010$J/\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010%J\u001d\u0010\u001d\u001a\u00028\u00002\u0006\u0010&\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020#H\u0016\u00a2\u0006\u0002\u0010'J'\u0010(\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H&\u00a2\u0006\u0002\u0010\u0016J/\u0010)\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010*\u001a\u00028\u00002\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010+J/\u0010)\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010*\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H&\u00a2\u0006\u0002\u0010%J\u001d\u0010,\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010-J\u0015\u0010,\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010.J\r\u0010/\u001a\u00028\u0000H&\u00a2\u0006\u0002\u00100J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00028\u000002H\u0016J\u001b\u00103\u001a\b\u0012\u0004\u0012\u00028\u0000022\u0006\u0010\u000b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u00104\u00a8\u00065"}, d2={"Lcom/boxfuse/base/fsimage/FsImage;", "F", "Lcom/boxfuse/base/fsimage/FsFile;", "", "copyTo", "", "T", "target", "path", "Lcom/boxfuse/base/fsimage/FsPath;", "createBlockDevice", "directory", "name", "", "major", "", "minor", "mode", "Lcom/boxfuse/base/fsimage/FsFileMode;", "(Lcom/boxfuse/base/fsimage/FsFile;Ljava/lang/String;BBLcom/boxfuse/base/fsimage/FsFileMode;)Lcom/boxfuse/base/fsimage/FsFile;", "createCharacterDevice", "createDirectory", "(Lcom/boxfuse/base/fsimage/FsFile;Ljava/lang/String;Lcom/boxfuse/base/fsimage/FsFileMode;)Lcom/boxfuse/base/fsimage/FsFile;", "createFifo", "createFile", "file", "(Lcom/boxfuse/base/fsimage/FsFile;)Lcom/boxfuse/base/fsimage/FsFile;", "prefix", "(Lcom/boxfuse/base/fsimage/FsPath;Lcom/boxfuse/base/fsimage/FsFile;)Lcom/boxfuse/base/fsimage/FsFile;", "createRegularFile", "data", "", "(Lcom/boxfuse/base/fsimage/FsFile;Ljava/lang/String;[BLcom/boxfuse/base/fsimage/FsFileMode;)Lcom/boxfuse/base/fsimage/FsFile;", "size", "", "Ljava/io/InputStream;", "(Lcom/boxfuse/base/fsimage/FsFile;Ljava/lang/String;JLjava/io/InputStream;Lcom/boxfuse/base/fsimage/FsFileMode;)Lcom/boxfuse/base/fsimage/FsFile;", "(Lcom/boxfuse/base/fsimage/FsFile;Ljava/lang/String;Ljava/lang/String;Lcom/boxfuse/base/fsimage/FsFileMode;)Lcom/boxfuse/base/fsimage/FsFile;", "regularFile", "(Lcom/boxfuse/base/fsimage/FsFile;Ljava/io/InputStream;)Lcom/boxfuse/base/fsimage/FsFile;", "createSocket", "createSymbolicLink", "destination", "(Lcom/boxfuse/base/fsimage/FsFile;Ljava/lang/String;Lcom/boxfuse/base/fsimage/FsFile;Lcom/boxfuse/base/fsimage/FsFileMode;)Lcom/boxfuse/base/fsimage/FsFile;", "getFile", "(Lcom/boxfuse/base/fsimage/FsFile;Ljava/lang/String;)Lcom/boxfuse/base/fsimage/FsFile;", "(Lcom/boxfuse/base/fsimage/FsPath;)Lcom/boxfuse/base/fsimage/FsFile;", "getRootDirectory", "()Lcom/boxfuse/base/fsimage/FsFile;", "listAllFiles", "", "listDirectory", "(Lcom/boxfuse/base/fsimage/FsFile;)Ljava/util/List;", "boxfuse-base-fsimage"})
public interface FsImage<F extends FsFile> {
    @NotNull
    public F getRootDirectory();

    @NotNull
    public F getFile(@NotNull FsPath var1);

    @NotNull
    public F getFile(@NotNull F var1, @NotNull String var2);

    @NotNull
    public List<F> listDirectory(@NotNull F var1);

    @NotNull
    public F createFile(@NotNull FsFile var1);

    @NotNull
    public F createFile(@NotNull FsPath var1, @NotNull FsFile var2);

    @NotNull
    public F createRegularFile(@NotNull FsFile var1, @NotNull InputStream var2);

    @NotNull
    public F createRegularFile(@NotNull F var1, @NotNull String var2, long var3, @NotNull InputStream var5, @NotNull FsFileMode var6);

    @NotNull
    public F createRegularFile(@NotNull F var1, @NotNull String var2, @NotNull byte[] var3, @NotNull FsFileMode var4);

    @NotNull
    public F createRegularFile(@NotNull F var1, @NotNull String var2, @NotNull String var3, @NotNull FsFileMode var4);

    @NotNull
    public F createDirectory(@NotNull F var1, @NotNull String var2, @NotNull FsFileMode var3);

    @NotNull
    public F createSymbolicLink(@NotNull F var1, @NotNull String var2, @NotNull String var3, @NotNull FsFileMode var4);

    @NotNull
    public F createSymbolicLink(@NotNull F var1, @NotNull String var2, @NotNull F var3, @NotNull FsFileMode var4);

    @NotNull
    public F createBlockDevice(@NotNull F var1, @NotNull String var2, byte var3, byte var4, @NotNull FsFileMode var5);

    @NotNull
    public F createCharacterDevice(@NotNull F var1, @NotNull String var2, byte var3, byte var4, @NotNull FsFileMode var5);

    @NotNull
    public F createFifo(@NotNull F var1, @NotNull String var2, @NotNull FsFileMode var3);

    @NotNull
    public F createSocket(@NotNull F var1, @NotNull String var2, @NotNull FsFileMode var3);

    public <T extends FsFile> void copyTo(@NotNull FsImage<T> var1, @NotNull FsPath var2);

    @NotNull
    public List<F> listAllFiles();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FsFileType.values().length];
            nArray[FsFileType.DIRECTORY.ordinal()] = 1;
            nArray[FsFileType.SYMBOLIC_LINK.ordinal()] = 2;
            nArray[FsFileType.BLOCK_DEVICE.ordinal()] = 3;
            nArray[FsFileType.CHARACTER_DEVICE.ordinal()] = 4;
            nArray[FsFileType.FIFO.ordinal()] = 5;
            nArray[FsFileType.SOCKET.ordinal()] = 6;
            nArray[FsFileType.REGULAR_FILE.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static <F extends FsFile> F createFile(@NotNull FsImage<F> this_, @NotNull FsFile file) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            F directory = this_.getFile(file.getPath().getParent());
            return DefaultImpls.createFile(this_, directory, file);
        }

        @NotNull
        public static <F extends FsFile> F createFile(@NotNull FsImage<F> this_, @NotNull FsPath prefix, @NotNull FsFile file) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            F directory = this_.getFile(prefix.getChild(file.getPath().getParent()));
            return DefaultImpls.createFile(this_, directory, file);
        }

        private static <F extends FsFile> F createFile(FsImage<F> this_, F directory, FsFile file) {
            Object object;
            String name = file.getPath().getName();
            FsFileMode mode = file.getMode();
            FsFileType fsFileType = file.getType();
            int n = WhenMappings.$EnumSwitchMapping$0[fsFileType.ordinal()];
            switch (n) {
                case 1: {
                    object = this_.createDirectory((String)((Object)directory), name, mode);
                    break;
                }
                case 2: {
                    String string = file.getDestination();
                    Intrinsics.checkNotNull((Object)string);
                    object = this_.createSymbolicLink((String)((Object)directory), name, string, mode);
                    break;
                }
                case 3: {
                    Byte by = file.getMajor();
                    Intrinsics.checkNotNull((Object)by);
                    byte by2 = by;
                    by = file.getMinor();
                    Intrinsics.checkNotNull((Object)by);
                    object = this_.createBlockDevice((String)((Object)directory), name, by2, by, mode);
                    break;
                }
                case 4: {
                    Byte by = file.getMajor();
                    Intrinsics.checkNotNull((Object)by);
                    byte by3 = by;
                    by = file.getMinor();
                    Intrinsics.checkNotNull((Object)by);
                    object = this_.createCharacterDevice((String)((Object)directory), name, by3, by, mode);
                    break;
                }
                case 5: {
                    object = this_.createFifo((String)((Object)directory), name, mode);
                    break;
                }
                case 6: {
                    object = this_.createSocket((String)((Object)directory), name, mode);
                    break;
                }
                case 7: {
                    long l = file.getSize();
                    InputStream inputStream = file.getData();
                    Intrinsics.checkNotNull((Object)inputStream);
                    object = this_.createRegularFile((String)((Object)directory), name, l, inputStream, mode);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return object;
        }

        @NotNull
        public static <F extends FsFile> F createRegularFile(@NotNull FsImage<F> this_, @NotNull FsFile regularFile, @NotNull InputStream data) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)regularFile, (String)"regularFile");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            boolean bl = regularFile.getType() == FsFileType.REGULAR_FILE;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = regularFile.getPath() + " is not a regular file";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            F directory = this_.getFile(regularFile.getPath().getParent());
            return this_.createRegularFile(directory, regularFile.getPath().getName(), regularFile.getSize(), data, regularFile.getMode());
        }

        @NotNull
        public static <F extends FsFile> F createRegularFile(@NotNull FsImage<F> this_, @NotNull F directory, @NotNull String name, @NotNull byte[] data, @NotNull FsFileMode mode) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            Intrinsics.checkNotNullParameter(directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            byte[] byArray = data;
            boolean bl = false;
            return this_.createRegularFile(directory, name, data.length, new ByteArrayInputStream(byArray), mode);
        }

        public static /* synthetic */ FsFile createRegularFile$default(FsImage fsImage, FsFile fsFile, String string, byte[] byArray, FsFileMode fsFileMode, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createRegularFile");
            }
            if ((n & 8) != 0) {
                fsFileMode = FsFileMode.Companion.getR();
            }
            return fsImage.createRegularFile(fsFile, string, byArray, fsFileMode);
        }

        @NotNull
        public static <F extends FsFile> F createRegularFile(@NotNull FsImage<F> this_, @NotNull F directory, @NotNull String name, @NotNull String data, @NotNull FsFileMode mode) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            Intrinsics.checkNotNullParameter(directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            String string = data;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            return this_.createRegularFile(directory, name, byArray, mode);
        }

        public static /* synthetic */ FsFile createRegularFile$default(FsImage fsImage, FsFile fsFile, String string, String string2, FsFileMode fsFileMode, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createRegularFile");
            }
            if ((n & 8) != 0) {
                fsFileMode = FsFileMode.Companion.getR();
            }
            return fsImage.createRegularFile(fsFile, string, string2, fsFileMode);
        }

        public static /* synthetic */ FsFile createDirectory$default(FsImage fsImage, FsFile fsFile, String string, FsFileMode fsFileMode, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createDirectory");
            }
            if ((n & 4) != 0) {
                fsFileMode = FsFileMode.Companion.getRX();
            }
            return fsImage.createDirectory(fsFile, string, fsFileMode);
        }

        public static /* synthetic */ FsFile createSymbolicLink$default(FsImage fsImage, FsFile fsFile, String string, String string2, FsFileMode fsFileMode, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createSymbolicLink");
            }
            if ((n & 8) != 0) {
                fsFileMode = FsFileMode.Companion.getR();
            }
            return fsImage.createSymbolicLink(fsFile, string, string2, fsFileMode);
        }

        @NotNull
        public static <F extends FsFile> F createSymbolicLink(@NotNull FsImage<F> this_, @NotNull F directory, @NotNull String name, @NotNull F destination, @NotNull FsFileMode mode) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            Intrinsics.checkNotNullParameter(directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            return (F)this_.createSymbolicLink((String)((Object)directory), name, destination.getPath().getAbsolutePath(), mode);
        }

        public static /* synthetic */ FsFile createSymbolicLink$default(FsImage fsImage, FsFile fsFile, String string, FsFile fsFile2, FsFileMode fsFileMode, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createSymbolicLink");
            }
            if ((n & 8) != 0) {
                fsFileMode = fsFile2.getMode();
            }
            return fsImage.createSymbolicLink(fsFile, string, fsFile2, fsFileMode);
        }

        public static /* synthetic */ FsFile createBlockDevice$default(FsImage fsImage, FsFile fsFile, String string, byte by, byte by2, FsFileMode fsFileMode, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createBlockDevice");
            }
            if ((n & 0x10) != 0) {
                fsFileMode = FsFileMode.Companion.getRW();
            }
            return fsImage.createBlockDevice(fsFile, string, by, by2, fsFileMode);
        }

        public static /* synthetic */ FsFile createCharacterDevice$default(FsImage fsImage, FsFile fsFile, String string, byte by, byte by2, FsFileMode fsFileMode, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createCharacterDevice");
            }
            if ((n & 0x10) != 0) {
                fsFileMode = FsFileMode.Companion.getRW();
            }
            return fsImage.createCharacterDevice(fsFile, string, by, by2, fsFileMode);
        }

        public static /* synthetic */ FsFile createFifo$default(FsImage fsImage, FsFile fsFile, String string, FsFileMode fsFileMode, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createFifo");
            }
            if ((n & 4) != 0) {
                fsFileMode = FsFileMode.Companion.getRW();
            }
            return fsImage.createFifo(fsFile, string, fsFileMode);
        }

        public static /* synthetic */ FsFile createSocket$default(FsImage fsImage, FsFile fsFile, String string, FsFileMode fsFileMode, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createSocket");
            }
            if ((n & 4) != 0) {
                fsFileMode = FsFileMode.Companion.getRW();
            }
            return fsImage.createSocket(fsFile, string, fsFileMode);
        }

        public static <F extends FsFile, T extends FsFile> void copyTo(@NotNull FsImage<F> this_, @NotNull FsImage<T> target, @NotNull FsPath path) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            Intrinsics.checkNotNullParameter(target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Iterable $this$forEach$iv = this_.listAllFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FsFile it = (FsFile)element$iv;
                boolean bl = false;
                target.createFile(path, it);
            }
        }

        public static /* synthetic */ void copyTo$default(FsImage fsImage, FsImage fsImage2, FsPath fsPath, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyTo");
            }
            if ((n & 2) != 0) {
                fsPath = FsPath.Companion.getROOT();
            }
            fsImage.copyTo(fsImage2, fsPath);
        }

        @NotNull
        public static <F extends FsFile> List<F> listAllFiles(@NotNull FsImage<F> this_) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            boolean bl = false;
            List allFiles = new ArrayList();
            DefaultImpls.listAllFiles$addAllForDirectory(this_, allFiles, this_.getRootDirectory());
            return allFiles;
        }

        /*
         * WARNING - void declaration
         */
        private static <F extends FsFile> void listAllFiles$addAllForDirectory(FsImage<F> this$0, List<F> allFiles, F directory) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this$0.listDirectory(directory);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FsFile it = (FsFile)element$iv$iv;
                boolean bl = false;
                Object[] objectArray = new String[]{".", "..", "lost+found"};
                if (!(!CollectionsKt.listOf((Object[])objectArray).contains(it.getPath().getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FsFile it = (FsFile)element$iv;
                boolean bl = false;
                allFiles.add(it);
                if (it.getType() != FsFileType.DIRECTORY) continue;
                DefaultImpls.listAllFiles$addAllForDirectory(this$0, allFiles, it);
            }
        }
    }
}

