/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.coordinates;

import com.boxfuse.base.coordinates.AppName;
import com.boxfuse.base.coordinates.Owner;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;

public class AppCoordinates
implements Comparable<AppCoordinates> {
    private final Owner owner;
    private final AppName name;

    public static boolean validate(String coordinates, Owner defaultOwner) {
        if (coordinates == null) {
            return false;
        }
        try {
            new AppCoordinates(coordinates, defaultOwner);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static AppCoordinates of(String coordinates, Owner defaultOwner) {
        if (coordinates == null) {
            return null;
        }
        return new AppCoordinates(coordinates, defaultOwner);
    }

    public AppCoordinates(String coordinates) {
        this(coordinates, null);
    }

    public AppCoordinates(String coordinates, Owner defaultOwner) {
        if (!StringUtils.hasLength(coordinates)) {
            throw new BoxfuseException("Missing Image coordinates");
        }
        int ownerSplit = coordinates.indexOf("/");
        Owner owner = this.owner = ownerSplit > 0 ? new Owner(coordinates.substring(0, ownerSplit)) : defaultOwner;
        if (this.owner == null) {
            throw new BoxfuseException("Missing owner from coordinates " + coordinates);
        }
        this.name = AppName.of(coordinates.substring(ownerSplit + 1));
    }

    public AppCoordinates(Owner owner, AppName name) {
        this.owner = owner;
        this.name = name;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public AppName getName() {
        return this.name;
    }

    public String getCoordinates() {
        return this.owner + "/" + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppCoordinates that = (AppCoordinates)o;
        return this.name.equals(that.name) && this.owner.equals(that.owner);
    }

    public int hashCode() {
        int result = this.owner.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return this.getCoordinates();
    }

    @Override
    public int compareTo(AppCoordinates o) {
        int result = this.owner.compareTo(o.owner);
        if (result == 0) {
            result = this.name.compareTo(o.name);
        }
        return result;
    }
}

