/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.coordinates;

import com.boxfuse.base.exception.BoxfuseException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collection;

public class AppName
implements Comparable<AppName> {
    private final String name;

    public static boolean validate(String name) {
        if (name == null) {
            return false;
        }
        try {
            new AppName(name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @JsonCreator
    public static AppName of(String name) {
        return name == null ? null : new AppName(name);
    }

    private AppName(String name) {
        if (!name.matches("[a-z][a-z\\-0-9]*") || name.endsWith("-") || name.contains("--")) {
            throw new BoxfuseException("Invalid app name (must start with a letter and may only contain a-z, 0-9 and single dashes): " + name + " => set boxfuse.app or boxfuse.image to a valid app name to fix");
        }
        this.name = name;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public void ensureNoCollisions(Collection<AppName> appNames) {
        if (appNames.contains(this)) {
            throw new BoxfuseException("You already have an app named " + this.name + " => pick a different name or destroy your existing app");
        }
        for (AppName appName : appNames) {
            if (!appName.getName().replace("-", "").equals(this.name.replace("-", ""))) continue;
            throw new BoxfuseException("App name (" + appName + ") collides with the name of another app called " + this.name + " (names must be unique with all dashes removed) => pick a different name or destroy your existing app");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppName appName = (AppName)o;
        return this.name.equals(appName.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(AppName o) {
        return this.name.compareTo(o.name);
    }
}

